/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.device.manager.util;

import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import com.sun.jna.WString;
import java.util.logging.Level;
import org.tizen.device.manager.logging.DeviceLogger;

public class OSUtil {
    private static final String NAME = "os.name";
    private static boolean isMac = false;
    private static boolean isWin = false;
    private static boolean isWin8AndAbove = false;
    private static boolean isLinux = false;
    public static final String WINDOWS = "Windows";
    public static final String LINUX = "Linux";
    public static final String MAC = "Mac";

    public static void setProcessAppUserModelID(String appID) {
        long S_OK = 0L;
        try {
            NativeLong result = OSUtil.SetCurrentProcessExplicitAppUserModelID(new WString(appID));
            if (result.longValue() == S_OK) {
                DeviceLogger.getLogger().log(Level.INFO, "Set process AppUserModelID to " + appID);
            } else {
                DeviceLogger.getLogger().log(Level.WARNING, "Failed to set process AppUserModelID to " + appID);
            }
        }
        catch (UnsatisfiedLinkError e) {
            DeviceLogger.getLogger().log(Level.WARNING, e.getMessage());
        }
    }

    private static native NativeLong SetCurrentProcessExplicitAppUserModelID(WString var0);

    public static boolean isMac() {
        return isMac;
    }

    public static boolean isWin() {
        return isWin;
    }

    public static boolean isWin8AndAbove() {
        return isWin8AndAbove;
    }

    public static boolean isLinux() {
        return isLinux;
    }

    public static String getCurrentOSName() {
        if (isWin) {
            return WINDOWS;
        }
        if (isLinux) {
            return LINUX;
        }
        return MAC;
    }

    static {
        if (System.getProperty(NAME).toLowerCase().indexOf("linux") > -1) {
            isLinux = true;
        } else if (System.getProperty(NAME).toLowerCase().indexOf("win") > -1) {
            isWin = true;
            try {
                if (Float.compare(Float.parseFloat(System.getProperty("os.version")), 6.2f) >= 0) {
                    isWin8AndAbove = true;
                }
            }
            catch (NumberFormatException e) {
                DeviceLogger.getLogger().warning(e.getMessage());
                isWin8AndAbove = false;
            }
        } else if (System.getProperty(NAME).toLowerCase().indexOf("mac") > -1) {
            isMac = true;
        }
        if (isWin) {
            try {
                Native.register("shell32");
            }
            catch (UnsatisfiedLinkError e) {
                DeviceLogger.getLogger().log(Level.WARNING, e.getMessage());
            }
        }
    }
}

