/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.device.manager.controller;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import java.util.regex.Pattern;
import javafx.application.Platform;
import org.tizen.device.manager.logging.DeviceLogger;
import org.tizen.device.manager.model.RemoteDeviceItem;
import org.tizen.device.manager.ui.diaglog.RemoteDeviceManagerDialog;
import org.tizen.sdblib.util.IOUtil;

public class RemoteDeviceScanWorkerController
implements Runnable {
    private final int REMOTE_SOCKET_CONNECT_WAIT_TIME = 20000;
    private static final String AUTO_SCAN_PORT = "26101";
    private boolean isRunning = false;
    private RemoteDeviceManagerDialog dlg = null;

    public RemoteDeviceScanWorkerController(RemoteDeviceManagerDialog dlg) {
        this.dlg = dlg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.start();
        try {
            List<String> ipList = this.getHostAddressList();
            for (String hostIP : ipList) {
                if (!this.isRunning()) {
                    break;
                }
                this.updateReachableIPList(hostIP);
            }
        }
        catch (Exception e) {
            DeviceLogger.getLogger().log(Level.SEVERE, "Failed to scan remote device.", e);
        }
        finally {
            this.finish();
        }
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public void start() {
        this.isRunning = true;
        this.dlg.enableScanButton(false);
    }

    public void finish() {
        this.isRunning = false;
        this.dlg.enableScanButton(true);
    }

    private List<String> getHostAddressList() throws SocketException {
        ArrayList<String> addressList = new ArrayList<String>();
        Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
        if (networkInterfaces != null) {
            while (networkInterfaces.hasMoreElements()) {
                NetworkInterface networkInterface = networkInterfaces.nextElement();
                if (networkInterface.isLoopback()) continue;
                Enumeration<InetAddress> inetAddresses = networkInterface.getInetAddresses();
                while (inetAddresses.hasMoreElements()) {
                    InetAddress inetAddress = inetAddresses.nextElement();
                    if (!(inetAddress instanceof Inet4Address) || inetAddress.isLoopbackAddress() || inetAddress.isLinkLocalAddress()) continue;
                    String hostAddress = inetAddress.getHostAddress();
                    addressList.add(hostAddress);
                    DeviceLogger.getLogger().log(Level.INFO, "Add hostAddress: " + hostAddress + ", interface Name: " + networkInterface.getName());
                }
            }
        }
        return addressList;
    }

    private void updateReachableIPList(String hostIP) throws InterruptedException {
        String[] tokens = hostIP.split(Pattern.quote("."));
        ArrayList<Thread> threadList = new ArrayList<Thread>();
        if (tokens.length != 4) {
            DeviceLogger.getLogger().log(Level.INFO, "Failed to check reachable IP, cause it's invalid ip: " + hostIP);
            return;
        }
        for (int i = 1; i < 255; ++i) {
            final String ip = tokens[0] + "." + tokens[1] + "." + tokens[2] + "." + i;
            Thread th = new Thread(new Runnable(){

                @Override
                public void run() {
                    RemoteDeviceScanWorkerController.this.findReachableIP(ip);
                }
            });
            th.start();
            threadList.add(th);
        }
        for (Thread th : threadList) {
            try {
                th.join();
            }
            catch (InterruptedException e) {
                DeviceLogger.getLogger().log(Level.SEVERE, e.getMessage());
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findReachableIP(String ip) {
        InetSocketAddress destAddr;
        Socket socket;
        InetAddress inet;
        block5: {
            inet = null;
            socket = null;
            destAddr = null;
            try {
                inet = InetAddress.getByName(ip);
                DeviceLogger.getLogger().log(Level.INFO, "Start Thread for checking reachable ip: " + ip);
                if (inet.isReachable(4000)) {
                    DeviceLogger.getLogger().log(Level.INFO, "Is reachable ip: " + ip);
                    socket = new Socket();
                    destAddr = new InetSocketAddress(ip, Integer.parseInt(AUTO_SCAN_PORT));
                    DeviceLogger.getLogger().log(Level.INFO, "before connect ip: " + ip);
                    socket.connect(destAddr, 20000);
                    DeviceLogger.getLogger().log(Level.INFO, "after connect ip: " + ip);
                    this.addIPToTable(ip);
                    break block5;
                }
                DeviceLogger.getLogger().log(Level.INFO, "Is not reachable ip: " + ip);
            }
            catch (IOException e) {
                try {
                    DeviceLogger.getLogger().log(Level.INFO, "Failed to connect: " + ip, e);
                }
                catch (Throwable throwable) {
                    IOUtil.tryClose(destAddr);
                    IOUtil.tryClose(inet);
                    IOUtil.tryClose(socket);
                    throw throwable;
                }
                IOUtil.tryClose(destAddr);
                IOUtil.tryClose(inet);
                IOUtil.tryClose(socket);
            }
        }
        IOUtil.tryClose(destAddr);
        IOUtil.tryClose(inet);
        IOUtil.tryClose(socket);
    }

    private void addIPToTable(final String ip) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                if (RemoteDeviceScanWorkerController.this.isExistIP(ip)) {
                    return;
                }
                RemoteDeviceScanWorkerController.this.dlg.addRemoteDeviceItem(new RemoteDeviceItem("new", ip, RemoteDeviceScanWorkerController.AUTO_SCAN_PORT, false));
            }
        });
    }

    private boolean isExistIP(String ip) {
        if (this.dlg.getRemoteDeviceItemList().isEmpty()) {
            return false;
        }
        for (RemoteDeviceItem deviceItem : this.dlg.getRemoteDeviceItemList()) {
            if (!deviceItem.ipProperty().getValue().equals(ip)) continue;
            return true;
        }
        return false;
    }
}

