/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.device.manager.logging;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.tizen.device.manager.InstallDeviceInfo;
import org.tizen.device.manager.StringResources;
import org.tizen.device.manager.logging.LoggerFormatter;

public class DeviceLogger {
    private static final String DEFAULT_LOG_FILENAME = "device-manager.log";
    private static DeviceLogger instance;
    private static Logger logger;
    private static String staticLogger;
    private static File logFile;
    private static Handler logFileHandler;

    private DeviceLogger() {
    }

    public static void log(String message) {
        staticLogger = staticLogger + message + StringResources.NEW_LINE;
    }

    public static Logger getLogger() {
        if (logger == null) {
            instance.internalInitialize();
        }
        return logger;
    }

    public void setLevel(Level level) {
        if (logger != null) {
            logger.setLevel(level);
            if (logger.getUseParentHandlers()) {
                Handler[] logHandlers;
                for (Handler handler : logHandlers = logger.getParent().getHandlers()) {
                    handler.setLevel(logger.getLevel());
                }
            }
        }
        if (logFileHandler != null) {
            logFileHandler.setLevel(level);
        }
    }

    public void setConsoleLogger() {
        Handler[] logHandlers;
        if (logger == null) {
            return;
        }
        for (Handler handler : logHandlers = logger.getParent().getHandlers()) {
            handler.setFormatter(new LoggerFormatter());
        }
        logger.setUseParentHandlers(true);
    }

    public void setFileLogger(File file) {
        if (logger == null) {
            return;
        }
        logger.setUseParentHandlers(false);
        try {
            File logFolder;
            if (file == null) {
                logFolder = new File(InstallDeviceInfo.getTizenSDKDataPath());
                logFile = new File(logFolder.getAbsolutePath() + File.separator + DEFAULT_LOG_FILENAME);
            } else {
                logFolder = file.getParentFile();
                logFile = file;
            }
            if (logFolder != null && !logFolder.exists()) {
                logFolder.mkdirs();
            }
            logFileHandler = new FileHandler(logFile.getAbsolutePath());
            logFileHandler.setFormatter(new LoggerFormatter());
            logFileHandler.setEncoding("UTF-8");
            logger.addHandler(logFileHandler);
        }
        catch (SecurityException e) {
            logger.setLevel(Level.OFF);
        }
        catch (IOException e) {
            logger.setLevel(Level.OFF);
        }
        logger.info(StringResources.NEW_LINE + "=== Initial Information ===========" + StringResources.NEW_LINE + staticLogger);
    }

    public void initialize() {
        if (logger == null) {
            logger = Logger.getLogger("Device Manager Library");
        }
        logger.setLevel(Level.WARNING);
    }

    private void internalInitialize() {
        if (logger == null) {
            logger = Logger.getLogger("Device Manager Library");
        }
        logger.setLevel(Level.OFF);
    }

    public static void printStackTrace(Throwable e) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(os);
        e.printStackTrace(pw);
        pw.flush();
        Logger loggerObj = DeviceLogger.getLogger();
        if (loggerObj != null) {
            loggerObj.warning(os.toString());
        }
        try {
            pw.close();
            os.close();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    public static DeviceLogger getInstance() {
        return instance;
    }

    public static void makeBackupLog(Path source) {
        block3: {
            if (!Files.exists(source, new LinkOption[0])) {
                return;
            }
            Path target = DeviceLogger.makeBackupFilePath(source);
            try {
                Files.move(source, target, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (Exception e) {
                Logger loggerObj = DeviceLogger.getLogger();
                if (loggerObj == null) break block3;
                loggerObj.warning("Failed to make back log. " + e.getClass().getName() + ", " + e.getMessage());
            }
        }
    }

    private static Path makeBackupFilePath(Path source) {
        String sourcePath = source.toString();
        int index = sourcePath.lastIndexOf(File.separator);
        String filePath = sourcePath.substring(0, index);
        String fileName = sourcePath.substring(index + 1, sourcePath.length());
        String backupFilePath = filePath + File.separator + fileName + ".bak";
        return Paths.get(backupFilePath, new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Class<DeviceLogger> clazz = DeviceLogger.class;
        synchronized (DeviceLogger.class) {
            instance = new DeviceLogger();
            // ** MonitorExit[var0] (shouldn't be in output)
            logger = null;
            staticLogger = "";
            logFile = null;
            logFileHandler = null;
            return;
        }
    }
}

