/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.sdblib.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.tizen.sdblib.util.ArrayUtil;
import org.tizen.sdblib.util.Assert;
import org.tizen.sdblib.util.ObjectUtil;

public class CollectionUtil {
    protected static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    protected static final byte[] EMPTY_BYTES = EMPTY_BYTE_ARRAY;
    private static final String ARRAY_START = "{";
    private static final String ARRAY_END = "}";
    private static final String EMPTY_ARRAY = "{}";
    private static final String ARRAY_ELEMENT_SEPARATOR = ", ";
    private static final Set<Class<?>> APPROXIMABLE_COLLECTION_TYPES = Collections.unmodifiableSet(new HashSet<Class>(Arrays.asList(Collection.class, Set.class, HashSet.class, SortedSet.class, LinkedHashSet.class, TreeSet.class, List.class, LinkedList.class, ArrayList.class)));
    private static final Set<Class<?>> APPROXIMABLE_MAP_TYPES = Collections.unmodifiableSet(new HashSet<Class>(Arrays.asList(Map.class, SortedMap.class, HashMap.class, LinkedHashMap.class, TreeMap.class)));
    public static final Collection<Object> EMPTY_COLLECTION = Collections.unmodifiableCollection(new ArrayList());
    private static final int MULTIPLIER = 31;
    private static final int INITIAL_HASH = 7;

    protected CollectionUtil() {
    }

    public static boolean isEmpty(Collection<?> collection) {
        if (collection == null) {
            return true;
        }
        return collection.isEmpty();
    }

    public static int size(Collection<?> collection) {
        if (collection == null) {
            return 0;
        }
        return collection.size();
    }

    public static <T> T pickupFirst(Collection<T> collection) {
        if (CollectionUtil.isEmpty(collection)) {
            return null;
        }
        Iterator<T> iter = collection.iterator();
        return iter.hasNext() ? (T)iter.next() : null;
    }

    public static <T> T removeFirst(Collection<T> collection) {
        if (CollectionUtil.isEmpty(collection)) {
            return null;
        }
        Iterator<T> iter = collection.iterator();
        if (iter.hasNext()) {
            T ret = iter.next();
            iter.remove();
            return ret;
        }
        return null;
    }

    public static <T> T pickupLast(Collection<T> collection) {
        if (CollectionUtil.isEmpty(collection)) {
            return null;
        }
        Iterator<T> iter = collection.iterator();
        T temp = null;
        while (iter.hasNext()) {
            temp = iter.next();
        }
        return temp;
    }

    public static <T> T removeLast(Collection<T> collection) {
        if (CollectionUtil.isEmpty(collection)) {
            return null;
        }
        Iterator<T> iter = collection.iterator();
        T temp = null;
        while (iter.hasNext()) {
            temp = iter.next();
        }
        iter.remove();
        return temp;
    }

    public static <E> Iterator<E> iterator(Enumeration<E> enumeration) {
        return new EnumerationAdapter<E>(enumeration);
    }

    /*
     * Unable to fully structure code
     */
    public static boolean contains(Iterator<Object> iterator, Object element) {
        if (iterator != null) ** GOTO lbl6
        return false;
lbl-1000:
        // 1 sources

        {
            candidate = iterator.next();
            if (!ObjectUtil.equals(candidate, element)) continue;
            return true;
lbl6:
            // 2 sources

            ** while (iterator.hasNext())
        }
lbl7:
        // 1 sources

        return false;
    }

    /*
     * Unable to fully structure code
     */
    public static boolean contains(Enumeration<Object> enumeration, Object element) {
        if (enumeration != null) ** GOTO lbl6
        return false;
lbl-1000:
        // 1 sources

        {
            candidate = enumeration.nextElement();
            if (!ObjectUtil.equals(candidate, element)) continue;
            return true;
lbl6:
            // 2 sources

            ** while (enumeration.hasMoreElements())
        }
lbl7:
        // 1 sources

        return false;
    }

    public static boolean contains(Collection<Object> collection, Object element) {
        if (collection == null) {
            return false;
        }
        for (Object candidate : collection) {
            if (!ObjectUtil.equals(candidate, element)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsAny(Collection<?> source, Collection<?> candidates) {
        if (CollectionUtil.isEmpty(source) || CollectionUtil.isEmpty(candidates)) {
            return false;
        }
        for (Object candidate : candidates) {
            if (!source.contains(candidate)) continue;
            return true;
        }
        return false;
    }

    public static boolean isApproximableCollectionType(Class<?> collectionType) {
        return APPROXIMABLE_COLLECTION_TYPES.contains(collectionType);
    }

    public static boolean isApproximableMapType(Class<?> mapType) {
        return APPROXIMABLE_MAP_TYPES.contains(mapType);
    }

    public static <K> Collection<K> createApproximableCollection(Collection<K> collection, int initialCapacity) {
        if (collection instanceof LinkedList) {
            return new LinkedList();
        }
        if (collection instanceof List) {
            return new ArrayList(initialCapacity);
        }
        if (collection instanceof SortedSet) {
            return new TreeSet(((SortedSet)collection).comparator());
        }
        return new LinkedHashSet(initialCapacity);
    }

    public static <K, V> Map<K, V> createApproximableMap(Map<K, V> map, int initialCapacity) {
        if (map instanceof SortedMap) {
            return new TreeMap(((SortedMap)map).comparator());
        }
        return new LinkedHashMap(initialCapacity);
    }

    public static String toString(Object obj) {
        if (obj == null) {
            return "<<null>>";
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj.getClass().isArray()) {
            int length = Array.getLength(obj);
            if (length == 0) {
                return EMPTY_ARRAY;
            }
            StringBuilder buffer = new StringBuilder();
            buffer.append(ARRAY_START);
            int i = 0;
            while (i < length) {
                if (i != 0) {
                    buffer.append(ARRAY_ELEMENT_SEPARATOR);
                }
                buffer.append(CollectionUtil.toString(Array.get(obj, i)));
                ++i;
            }
            buffer.append(ARRAY_END);
            return buffer.toString();
        }
        return ObjectUtil.nvl(obj.toString(), "");
    }

    public static <E> String concatenate(E[] array, String separator) {
        return CollectionUtil.concatenate(array == null ? null : new ArrayUtil.ArrayIterator<E>(array), separator);
    }

    public static <E> String concatenate(Collection<E> col, String separator) {
        return CollectionUtil.concatenate(col == null ? null : col.iterator(), separator);
    }

    public static <E> String concatenate(Iterator<E> iter, String separator) {
        if (iter == null) {
            return "<<null>>";
        }
        if (!iter.hasNext()) {
            return EMPTY_ARRAY;
        }
        StringBuilder buffer = new StringBuilder();
        boolean bInit = false;
        while (iter.hasNext()) {
            E obj = iter.next();
            if (bInit) {
                buffer.append(separator);
            }
            bInit = true;
            buffer.append(CollectionUtil.toString(obj));
        }
        return buffer.toString();
    }

    public static int hashCode(Object obj) {
        if (obj == null) {
            return 0;
        }
        if (obj.getClass().isArray()) {
            if (obj instanceof Object[]) {
                return CollectionUtil.hashCode((Object[])obj);
            }
            if (obj instanceof boolean[]) {
                return CollectionUtil.hashCode((boolean[])obj);
            }
            if (obj instanceof byte[]) {
                return CollectionUtil.hashCode((byte[])obj);
            }
            if (obj instanceof char[]) {
                return CollectionUtil.hashCode((char[])obj);
            }
            if (obj instanceof double[]) {
                return CollectionUtil.hashCode((double[])obj);
            }
            if (obj instanceof float[]) {
                return CollectionUtil.hashCode((float[])obj);
            }
            if (obj instanceof int[]) {
                return CollectionUtil.hashCode((int[])obj);
            }
            if (obj instanceof long[]) {
                return CollectionUtil.hashCode((long[])obj);
            }
            if (obj instanceof short[]) {
                return CollectionUtil.hashCode((short[])obj);
            }
        }
        return obj.hashCode();
    }

    public static int hashCode(Object[] array) {
        if (array == null) {
            return 0;
        }
        int hash = 7;
        int i = 0;
        int arraySize = array.length;
        while (i < arraySize) {
            hash = 31 * hash + CollectionUtil.hashCode(array[i]);
            ++i;
        }
        return hash;
    }

    public static int hashCode(boolean[] array) {
        if (array == null) {
            return 0;
        }
        int hash = 7;
        int i = 0;
        int arraySize = array.length;
        while (i < arraySize) {
            hash = 31 * hash + CollectionUtil.hashCode(array[i]);
            ++i;
        }
        return hash;
    }

    public static int hashCode(byte[] array) {
        if (array == null) {
            return 0;
        }
        int hash = 7;
        int i = 0;
        int arraySize = array.length;
        while (i < arraySize) {
            hash = 31 * hash + array[i];
            ++i;
        }
        return hash;
    }

    public static int hashCode(char[] array) {
        if (array == null) {
            return 0;
        }
        int hash = 7;
        int i = 0;
        int arraySize = array.length;
        while (i < arraySize) {
            hash = 31 * hash + CollectionUtil.hashCode(array[i]);
            ++i;
        }
        return hash;
    }

    public static int hashCode(double[] array) {
        if (array == null) {
            return 0;
        }
        int hash = 7;
        int i = 0;
        int arraySize = array.length;
        while (i < arraySize) {
            hash = 31 * hash + CollectionUtil.hashCode(array[i]);
            ++i;
        }
        return hash;
    }

    public static int hashCode(float[] array) {
        if (array == null) {
            return 0;
        }
        int hash = 7;
        int i = 0;
        int arraySize = array.length;
        while (i < arraySize) {
            hash = 31 * hash + CollectionUtil.hashCode(array[i]);
            ++i;
        }
        return hash;
    }

    public static int hashCode(int[] array) {
        if (array == null) {
            return 0;
        }
        int hash = 7;
        int i = 0;
        int arraySize = array.length;
        while (i < arraySize) {
            hash = 31 * hash + CollectionUtil.hashCode(array[i]);
            ++i;
        }
        return hash;
    }

    public static int hashCode(long[] array) {
        if (array == null) {
            return 0;
        }
        int hash = 7;
        int i = 0;
        int arraySize = array.length;
        while (i < arraySize) {
            hash = 31 * hash + CollectionUtil.hashCode(array[i]);
            ++i;
        }
        return hash;
    }

    public static int hashCode(short[] array) {
        if (array == null) {
            return 0;
        }
        int hash = 7;
        int i = 0;
        int arraySize = array.length;
        while (i < arraySize) {
            hash = 31 * hash + CollectionUtil.hashCode(array[i]);
            ++i;
        }
        return hash;
    }

    public static int hashCode(boolean bool) {
        return bool ? 1231 : 1237;
    }

    public static int hashCode(double dbl) {
        long bits = Double.doubleToLongBits(dbl);
        return CollectionUtil.hashCode(bits);
    }

    public static int hashCode(float flt) {
        return Float.floatToIntBits(flt);
    }

    public static int hashCode(long lng) {
        return (int)(lng ^ lng >>> 32);
    }

    public static <K> boolean equals(Collection<? extends K> ... cols) {
        boolean bInit = false;
        int size = 0;
        Collection<? extends K>[] collectionArray = cols;
        int n = cols.length;
        int n2 = 0;
        while (n2 < n) {
            Collection<K> col = collectionArray[n2];
            if (!bInit) {
                size = col == null ? -1 : col.size();
                bInit = true;
            }
            if (size < 0 ? col != null : col == null || col.size() != size) {
                return false;
            }
            ++n2;
        }
        if (size < 0) {
            return true;
        }
        Iterator[] iters = new Iterator[cols.length];
        int i = 0;
        int n3 = iters.length;
        while (i < n3) {
            iters[i] = cols[i].iterator();
            ++i;
        }
        while (iters[0].hasNext()) {
            Object obj = iters[0].next();
            int i2 = 1;
            int n4 = iters.length;
            while (i2 < n4) {
                Object other = iters[i2].next();
                if (!ObjectUtil.equals(obj, other)) {
                    return false;
                }
                ++i2;
            }
        }
        return true;
    }

    public static boolean equals(Object[] ... objsVar) {
        boolean bInit = false;
        int size = 0;
        Object[][] objectArray = objsVar;
        int n = objsVar.length;
        int n2 = 0;
        while (n2 < n) {
            Object[] objs = objectArray[n2];
            if (!bInit) {
                size = objs == null ? -1 : objs.length;
                bInit = true;
            }
            if (size < 0 ? objs != null : objs == null || objs.length != size) {
                return false;
            }
            ++n2;
        }
        if (size < 0) {
            return true;
        }
        int i = 1;
        int n3 = objsVar.length;
        while (i < n3) {
            int j = 0;
            while (j < size) {
                if (!ObjectUtil.equals(objsVar[0][j], objsVar[i][j])) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    public static void swap(Object[] objs, int i, int j) {
        Object temp = objs[i];
        objs[i] = objs[j];
        objs[j] = temp;
    }

    public static int isAvailableGenericTypeForCollection(Collection<?> collection, Class<?> targetClass) {
        if (collection.size() < 1) {
            return 0;
        }
        boolean foundNotNull = false;
        for (Object o : collection) {
            if (o == null) continue;
            foundNotNull = true;
            if (!o.getClass().isAssignableFrom(targetClass)) continue;
            return 1;
        }
        if (foundNotNull) {
            return -1;
        }
        return 0;
    }

    public static <E> List<E> resolveSetAsList(Set<E> set) {
        Iterator<E> itr = set.iterator();
        ArrayList<E> result = new ArrayList<E>();
        while (itr.hasNext()) {
            E obj = itr.next();
            result.add(obj);
        }
        return result;
    }

    static class EnumerationAdapter<K>
    implements Iterator<K> {
        protected final Enumeration<K> enumeration;

        public EnumerationAdapter(Enumeration<K> enumeration) {
            Assert.notNull(enumeration);
            this.enumeration = enumeration;
        }

        @Override
        public boolean hasNext() {
            return this.enumeration.hasMoreElements();
        }

        @Override
        public K next() {
            return this.enumeration.nextElement();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

