/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.device.manager.control;

import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import org.tizen.device.manager.control.ButtonToggleEvent;
import org.tizen.device.manager.resources.ImageKind;
import org.tizen.device.manager.resources.ImagesView;

public class DeviceToggleButton
extends HBox {
    private final Label iconLabel;
    private final ImageView ON_IMAGE;
    private final ImageView OFF_IMAGE;
    private final int IMAGE_WIDTH = 50;
    private final int BOX_HEIGHT = 24;
    private boolean isOn;
    private EventHandler<ButtonToggleEvent> onSelected = new EventHandler<ButtonToggleEvent>(){

        public void handle(ButtonToggleEvent arg0) {
        }
    };

    public void setOn(boolean on) {
        this.isOn = on;
        this.changeButton();
    }

    public void setDisableLabel(boolean disable) {
        this.iconLabel.setDisable(disable);
    }

    public boolean getOn() {
        return this.isOn;
    }

    public void setOnSelected(EventHandler<ButtonToggleEvent> handler) {
        this.onSelected = handler;
    }

    public DeviceToggleButton() {
        this.ON_IMAGE = ImagesView.getImageView(ImageKind.TOGGLE_ON.getFullName());
        this.OFF_IMAGE = ImagesView.getImageView(ImageKind.TOGGLE_OFF.getFullName());
        this.iconLabel = new Label();
        this.setAlignment(Pos.CENTER);
        this.getChildren().addAll((Object[])new Node[]{this.iconLabel});
        this.iconLabel.setPrefSize(50.0, 24.0);
        this.iconLabel.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent arg0) {
                DeviceToggleButton.this.setOn(!DeviceToggleButton.this.isOn);
                DeviceToggleButton.this.onSelected.handle((Event)new ButtonToggleEvent(DeviceToggleButton.this.isOn));
            }
        });
    }

    private void changeButton() {
        if (this.isOn) {
            this.iconLabel.setGraphic((Node)this.ON_IMAGE);
        } else {
            this.iconLabel.setGraphic((Node)this.OFF_IMAGE);
        }
    }
}

