/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.device.manager.logview.controller;

import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.control.SplitPane;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TableView;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import org.tizen.device.manager.Main;
import org.tizen.device.manager.control.ImageButton;
import org.tizen.device.manager.data.DeviceDescriptor;
import org.tizen.device.manager.data.DeviceStateType;
import org.tizen.device.manager.logging.DeviceLogger;
import org.tizen.device.manager.logview.data.LogModel;
import org.tizen.device.manager.logview.model.LogItem;
import org.tizen.device.manager.logview.view.CustomLogTabDialog;
import org.tizen.device.manager.logview.view.LogTab;
import org.tizen.device.manager.model.DeviceItem;
import org.tizen.device.manager.resources.ImageKind;
import org.tizen.device.manager.service.IDeviceChangeListener;
import org.tizen.device.manager.service.impl.DeviceChangedListenerManager;

public class FXMLLogViewController
implements Initializable {
    private AnchorPane rootPane;
    @FXML
    private AnchorPane logviewPane;
    @FXML
    private TabPane tabPane;
    private SplitPane splitPane;
    private ImageButton collapseButton;
    private double prevDividerPosition;
    private boolean isCollapsed;
    private DeviceDescriptor selectedDevice;
    private ArrayList<DeviceDescriptor> connectedDeviceDescriptortList;
    private final String DEVICE_ONLINE = "online";
    private final String DEVICE_OFFLINE = "offline";
    private final String ID_DEVICE_TABLE = "#deviceTable";
    private final String CLASS_TAB_LABEL = ".tab-label";
    private final String TAB_DISABLED = "disabled";
    private final String TAB_ADD = "tab-add";
    private final String BTN_ADD = "add-button";
    private static double COLLAPSING_MIN_SIZE = 35.0;
    private static FXMLLogViewController instance;
    private ChangeListener<Number> heightChangedListener = new ChangeListener<Number>(){

        public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
            if (newValue != null && FXMLLogViewController.this.splitPane != null && FXMLLogViewController.this.isCollapsed) {
                FXMLLogViewController.this.splitPane.setDividerPositions(new double[]{(FXMLLogViewController.this.splitPane.getHeight() - COLLAPSING_MIN_SIZE) / FXMLLogViewController.this.splitPane.getHeight()});
            }
        }
    };
    private ChangeListener<Number> dividerPositionChangedListener = new ChangeListener<Number>(){

        public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
            if (newValue != null && FXMLLogViewController.this.splitPane != null && FXMLLogViewController.this.isCollapsed) {
                FXMLLogViewController.this.splitPane.setDividerPositions(new double[]{(FXMLLogViewController.this.splitPane.getHeight() - COLLAPSING_MIN_SIZE) / FXMLLogViewController.this.splitPane.getHeight()});
            }
        }
    };

    public void initialize(URL url, ResourceBundle rb) {
        this.logviewPane.getStylesheets().add((Object)Main.class.getResource("/view/log_view_tab.css").toExternalForm());
        this.addDeviceChangedListener();
        this.addCustomizableTab();
        this.addCollapsingButton();
        instance = this;
    }

    private ArrayList<LogTab> getSameDeviceLogTabs(DeviceDescriptor device) {
        ArrayList<LogTab> sameDeviceLogTabs = new ArrayList<LogTab>();
        for (Tab tab : this.tabPane.getTabs()) {
            LogModel model;
            if (!(tab instanceof LogTab) || !(model = ((LogTab)tab).getLogModel()).isSameDevice(device)) continue;
            sameDeviceLogTabs.add((LogTab)tab);
        }
        return sameDeviceLogTabs;
    }

    private void enableLogTabs(DeviceDescriptor device) {
        ArrayList<LogTab> sameDeviceLogTabs = this.getSameDeviceLogTabs(device);
        if (sameDeviceLogTabs.size() == 0) {
            try {
                this.createNewLogTab(device, LogTab.generateDefaultTabName(device));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            for (LogTab tab : sameDeviceLogTabs) {
                tab.getLogModel().setDevice(device);
                Node node = (Node)new ArrayList(this.tabPane.lookupAll(".tab-label")).get(this.tabPane.getTabs().indexOf((Object)tab));
                node.getStyleClass().remove((Object)"disabled");
                tab.connect();
            }
        }
    }

    private void disableLogTabs(DeviceDescriptor device) {
        ArrayList<LogTab> sameDeviceLogTabs = this.getSameDeviceLogTabs(device);
        for (LogTab tab : sameDeviceLogTabs) {
            Node node = (Node)new ArrayList(this.tabPane.lookupAll(".tab-label")).get(this.tabPane.getTabs().indexOf((Object)tab));
            node.getStyleClass().add((Object)"disabled");
            tab.disconnect();
        }
    }

    private void addCustomizableTab() {
        ImageButton addButton = new ImageButton(ImageKind.ICON_LOGVIEW_ADD_TAB_NOR, ImageKind.ICON_LOGVIEW_ADD_TAB_OVER, ImageKind.ICON_LOGVIEW_ADD_TAB_DIM);
        Label headerAdd = new Label();
        headerAdd.setGraphic((Node)addButton.getPane());
        headerAdd.setPadding(new Insets(3.0, 0.0, 0.0, 0.0));
        headerAdd.getStyleClass().add((Object)"add-button");
        headerAdd.setMinSize(58.0, 30.0);
        headerAdd.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                if (FXMLLogViewController.this.selectedDevice != null) {
                    CustomLogTabDialog customDialog = new CustomLogTabDialog(FXMLLogViewController.this.selectedDevice);
                    try {
                        String tabname = (String)customDialog.showAndWait();
                        if (tabname != null) {
                            FXMLLogViewController.this.createNewLogTab(FXMLLogViewController.this.selectedDevice, tabname);
                        }
                    }
                    catch (Exception e) {
                        DeviceLogger.getLogger().log(Level.WARNING, e.getMessage());
                    }
                }
            }
        });
        this.logviewPane.getChildren().add((Object)headerAdd);
        AnchorPane.setTopAnchor((Node)headerAdd, (Double)3.0);
        AnchorPane.setLeftAnchor((Node)headerAdd, (Double)1.0);
    }

    private void addCollapsingButton() {
        this.collapseButton = new ImageButton(ImageKind.ICON_COLLAPSE_NOR, ImageKind.ICON_COLLAPSE_OVER, ImageKind.ICON_COLLAPSE_SEL, ImageKind.ICON_COLLAPSE_DIM);
        this.collapseButton.getPane().setPadding(new Insets(3.0, 0.0, 0.0, 0.0));
        this.logviewPane.getChildren().add((Object)this.collapseButton.getPane());
        AnchorPane.setTopAnchor((Node)this.collapseButton.getPane(), (Double)3.0);
        AnchorPane.setRightAnchor((Node)this.collapseButton.getPane(), (Double)5.0);
        AnchorPane.setTopAnchor((Node)this.tabPane, (Double)1.0);
        AnchorPane.setRightAnchor((Node)this.tabPane, (Double)1.0);
        AnchorPane.setLeftAnchor((Node)this.tabPane, (Double)1.0);
        AnchorPane.setBottomAnchor((Node)this.tabPane, (Double)1.0);
        this.collapseButton.setOnMouseClicked(new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                if (!FXMLLogViewController.this.isCollapsed) {
                    FXMLLogViewController.this.collapseSplitPane();
                } else {
                    FXMLLogViewController.this.expandSplitPane();
                }
            }
        });
    }

    private void collapseSplitPane() {
        if (this.splitPane != null) {
            this.collapseButton.setSelected(true);
            this.isCollapsed = true;
            this.prevDividerPosition = this.splitPane.getDividerPositions()[0];
            this.splitPane.setDividerPositions(new double[]{(this.splitPane.getHeight() - COLLAPSING_MIN_SIZE) / this.splitPane.getHeight()});
        }
    }

    private void expandSplitPane() {
        if (this.splitPane != null) {
            this.collapseButton.setSelected(false);
            this.isCollapsed = false;
            this.splitPane.setDividerPositions(new double[]{this.prevDividerPosition});
        }
    }

    private void addDeviceChangedListener() {
        this.connectedDeviceDescriptortList = new ArrayList();
        DeviceChangedListenerManager.addListener(new IDeviceChangeListener(){

            @Override
            public void targetsChanged(final DeviceDescriptor device, final DeviceStateType changeMask) {
                if (FXMLLogViewController.this.selectedDevice == null) {
                    FXMLLogViewController.this.addDeviceTableSelectionListener();
                    FXMLLogViewController.this.addCopyAcceleratorListener();
                }
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (changeMask.getTypeName().toLowerCase().equals("online")) {
                            DeviceLogger.getLogger().fine("Create Device Info: " + device.getDeviceName());
                            FXMLLogViewController.this.enableLogTabs(device);
                            if (!FXMLLogViewController.this.connectedDeviceDescriptortList.contains(device)) {
                                FXMLLogViewController.this.connectedDeviceDescriptortList.add(device);
                            }
                        } else if (changeMask.getTypeName().toLowerCase().equals("offline")) {
                            FXMLLogViewController.this.disableLogTabs(device);
                            FXMLLogViewController.this.connectedDeviceDescriptortList.remove(device);
                            if (FXMLLogViewController.this.selectedDevice == device) {
                                FXMLLogViewController.this.selectedDevice = null;
                            }
                        }
                    }
                });
            }
        });
    }

    private void visitParent() {
        Parent root = this.logviewPane.getParent();
        if (root != null) {
            while (root.getParent() != null) {
                if (!((root = root.getParent()) instanceof SplitPane)) continue;
                this.splitPane = (SplitPane)root;
                this.splitPane.heightProperty().addListener(this.heightChangedListener);
                ((SplitPane.Divider)this.splitPane.getDividers().get(0)).positionProperty().addListener(this.dividerPositionChangedListener);
            }
        }
        if (root instanceof AnchorPane) {
            this.rootPane = (AnchorPane)root;
        }
    }

    private void addDeviceTableSelectionListener() {
        this.visitParent();
        TableView deviceTable = (TableView)this.rootPane.lookup("#deviceTable");
        deviceTable.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<DeviceItem>(){

            public void changed(ObservableValue<? extends DeviceItem> observable, DeviceItem oldValue, DeviceItem newValue) {
                if (newValue != null) {
                    DeviceDescriptor device = newValue.getDeviceDescriptor();
                    FXMLLogViewController.this.selectedDevice = device;
                }
            }
        });
    }

    private void addCopyAcceleratorListener() {
        Scene sc = this.logviewPane.getScene();
        if (sc != null) {
            sc.getAccelerators().put((Object)new KeyCodeCombination(KeyCode.C, new KeyCombination.Modifier[]{KeyCombination.CONTROL_ANY, KeyCombination.SHORTCUT_ANY}), (Object)new Runnable(){

                @Override
                public void run() {
                    LogItem item;
                    Tab selectedTab = (Tab)FXMLLogViewController.this.tabPane.getSelectionModel().getSelectedItem();
                    if (selectedTab != null && selectedTab instanceof LogTab && (item = ((LogTab)selectedTab).getSelectedItem()) != null) {
                        Clipboard clipboard = Clipboard.getSystemClipboard();
                        ClipboardContent content = new ClipboardContent();
                        content.putString(item.messageProperty().get());
                        clipboard.setContent((Map)content);
                    }
                }
            });
        }
    }

    public void createNewLogTab(DeviceDescriptor device, String tabname) throws Exception {
        final LogTab tab = new LogTab(device, tabname);
        tab.setOnClosed((EventHandler)new EventHandler<Event>(){

            public void handle(Event event) {
                LogModel model = tab.getLogModel();
                if (model != null) {
                    model.release();
                }
            }
        });
        tab.connect();
        ObservableList tabs = this.tabPane.getTabs();
        tabs.add(tabs.size(), (Object)tab);
        this.tabPane.getSelectionModel().select((Object)tab);
    }

    public void removeLogTabs(DeviceDescriptor device) {
        ArrayList<LogTab> sameDeviceLogTabs = this.getSameDeviceLogTabs(device);
        for (LogTab tab : sameDeviceLogTabs) {
            tab.disconnect();
            this.tabPane.getTabs().remove((Object)tab);
        }
    }

    public boolean hasLogTabs(DeviceDescriptor device) {
        ArrayList<LogTab> sameDeviceLogTabs = this.getSameDeviceLogTabs(device);
        return !sameDeviceLogTabs.isEmpty();
    }

    public static FXMLLogViewController getInstance() {
        return instance;
    }
}

