/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.device.manager.model;

import javafx.scene.image.Image;
import org.tizen.device.manager.data.DeviceType;
import org.tizen.device.manager.resources.ImageKind;
import org.tizen.device.manager.resources.Images;

public class DeviceTypeImageData {
    private DeviceType deviceType;
    private ImageKind icon;
    private ImageKind selectedIcon;
    private ImageKind overIcon;
    private ImageKind tooltipIcon;

    public DeviceTypeImageData(DeviceType deviceType) {
        this.deviceType = deviceType;
        this.setDeviceTypeIconData(deviceType);
    }

    public void setDeviceTypeIconData(DeviceType deviceType) {
        if (deviceType.isRemoteDevice()) {
            this.setIcon(ImageKind.ICON_TYPE_REMOTE_DEVICE_NOR);
            this.setSelectedIcon(ImageKind.ICON_TYPE_REMOTE_DEVICE_SEL);
            this.setOverIcon(ImageKind.ICON_TYPE_REMOTE_DEVICE_OVER);
            this.setTooltipIcon(ImageKind.ICON_TYPE_REMOTE_DEVICE_TOOLTIP);
        } else if (deviceType.isEmulator()) {
            this.setIcon(ImageKind.ICON_TYPE_LOCAL_EMULATOR_NOR);
            this.setSelectedIcon(ImageKind.ICON_TYPE_LOCAL_EMULATOR_SEL);
            this.setOverIcon(ImageKind.ICON_TYPE_LOCAL_EMULATOR_OVER);
            this.setTooltipIcon(ImageKind.ICON_TYPE_LOCAL_EMULATOR_TOOLTIP);
        } else {
            this.setIcon(ImageKind.ICON_TYPE_LOCAL_DEVICE_NOR);
            this.setSelectedIcon(ImageKind.ICON_TYPE_LOCAL_DEVICE_SEL);
            this.setOverIcon(ImageKind.ICON_TYPE_LOCAL_DEVICE_OVER);
            this.setTooltipIcon(ImageKind.ICON_TYPE_LOCAL_DEVICE_TOOLTIP);
        }
    }

    public DeviceType getDeviceType() {
        return this.deviceType;
    }

    public void setDeviceType(DeviceType deviceType) {
        this.deviceType = deviceType;
    }

    public Image getIcon() {
        return Images.get(this.icon);
    }

    void setIcon(ImageKind icon) {
        this.icon = icon;
    }

    public Image getTooltipIcon() {
        if (this.tooltipIcon == null) {
            return null;
        }
        return Images.get(this.tooltipIcon);
    }

    void setTooltipIcon(ImageKind tooltipIcon) {
        this.tooltipIcon = tooltipIcon;
    }

    public Image getSelectedIcon() {
        return Images.get(this.selectedIcon);
    }

    public void setSelectedIcon(ImageKind selectedIcon) {
        this.selectedIcon = selectedIcon;
    }

    public Image getOverIcon() {
        return Images.get(this.overIcon);
    }

    public void setOverIcon(ImageKind overIcon) {
        this.overIcon = overIcon;
    }
}

