/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.device.manager.ui.diaglog;

import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import org.tizen.device.manager.Messages;
import org.tizen.device.manager.model.RemoteDeviceItem;
import org.tizen.device.manager.ui.diaglog.ButtonType;
import org.tizen.device.manager.ui.diaglog.Dialog;
import org.tizen.device.manager.ui.diaglog.RemoteDeviceManagerDialog;

public class RemoteDeviceManagerSubDialog
extends Dialog<String> {
    private BorderPane borderPane;
    public static String LABEL_DIALOG_ADD_NAME = Messages.Remote_Device_Manager_ADD_Device_Button_Tooltip;
    public static String LABEL_DIALOG_EDIT_NAME = Messages.Remote_Device_Manager_Edit_Device_Button_Tooltip;
    public static String LABEL_NAME = Messages.Remote_Device_Manager_Label_Name;
    public static String LABEL_IP = Messages.Remote_Device_Manager_Label_Ip;
    public static String LABEL_PORT = Messages.Remote_Device_Manager_Label_Port;
    public static String LABEL_GUIDE = Messages.Remote_Device_Manager_Guide_Message;
    public static String PORT_DEFAULT = Messages.Remote_Device_Manager_Default_Port;
    private Label guidLabel;
    private Label nameLabel;
    private Label ipLabel;
    private Label portLabel;
    private Button cancelButton;
    private Button addButton;
    private String nameStr = "";
    private String ipStr = "";
    private String portStr = "";
    private String titleStr = "";
    private Dialog<String> dialog;
    private boolean isAddOperation = true;
    private RemoteDeviceManagerDialog dlg = null;

    public RemoteDeviceManagerSubDialog(RemoteDeviceManagerDialog dlg, boolean isAddOperation) {
        this.dlg = dlg;
        this.isAddOperation = isAddOperation;
        if (!isAddOperation) {
            this.titleStr = LABEL_DIALOG_EDIT_NAME;
            RemoteDeviceItem item = dlg.getSelectedRemoteDeviceItem();
            if (item != null) {
                this.nameStr = item.nameProperty().getValue();
                this.ipStr = item.ipProperty().getValue();
                this.portStr = item.portProperty().getValue();
            }
        } else {
            this.titleStr = LABEL_DIALOG_ADD_NAME;
            this.portStr = PORT_DEFAULT;
        }
        this.createContents();
    }

    private void createContents() {
        this.dialog = new Dialog();
        this.dialog.setTitle(this.titleStr);
        this.dialog.setResizable(false);
        this.dialog.getDialogPane().addButonType(ButtonType.CANCEL);
        if (this.isAddOperation) {
            this.dialog.getDialogPane().addButonType(ButtonType.ADD);
        } else {
            this.dialog.getDialogPane().addButonType(ButtonType.SAVE);
        }
        this.borderPane = new BorderPane();
        VBox mainVBox = new VBox();
        mainVBox.setAlignment(Pos.BASELINE_LEFT);
        mainVBox.setSpacing(5.0);
        mainVBox.setPadding(new Insets(15.0, 15.0, 15.0, 15.0));
        HBox guideHBox = new HBox();
        this.guidLabel = new Label(LABEL_GUIDE);
        guideHBox.getChildren().addAll((Object[])new Node[]{this.guidLabel});
        guideHBox.setSpacing(10.0);
        guideHBox.setPadding(new Insets(0.0, 0.0, 10.0, 0.0));
        HBox nameHBox = new HBox();
        this.nameLabel = new Label(LABEL_NAME);
        final TextField nameTextField = new TextField();
        nameTextField.setPromptText(Messages.Remote_Device_Manager_Edit_PromptText_Name);
        nameTextField.setText(this.nameStr);
        nameTextField.setPrefColumnCount(10);
        nameTextField.setPrefWidth(190.0);
        nameHBox.getChildren().addAll((Object[])new Node[]{this.nameLabel, nameTextField});
        nameHBox.setSpacing(10.0);
        nameHBox.setAlignment(Pos.CENTER_LEFT);
        HBox ipHBox = new HBox();
        this.ipLabel = new Label(LABEL_IP);
        final TextField ipTextField = new TextField();
        ipTextField.setPromptText(Messages.Remote_Device_Manager_Edit_PromptText_Ip);
        ipTextField.setText(this.ipStr);
        ipTextField.setPrefColumnCount(10);
        ipTextField.setPrefWidth(190.0);
        ipHBox.getChildren().addAll((Object[])new Node[]{this.ipLabel, ipTextField});
        ipHBox.setSpacing(31.0);
        ipHBox.setAlignment(Pos.CENTER_LEFT);
        HBox portHBox = new HBox();
        this.portLabel = new Label(LABEL_PORT);
        final TextField portTextField = new TextField();
        portTextField.setText(this.portStr);
        portTextField.setPrefColumnCount(10);
        portTextField.setPrefWidth(190.0);
        portHBox.getChildren().addAll((Object[])new Node[]{this.portLabel, portTextField});
        portHBox.setSpacing(19.0);
        portHBox.setAlignment(Pos.CENTER_LEFT);
        mainVBox.getChildren().addAll((Object[])new Node[]{guideHBox, nameHBox, ipHBox, portHBox});
        this.borderPane.setCenter((Node)mainVBox);
        this.dialog.getDialogPane().setContent((Node)this.borderPane);
        this.cancelButton = this.dialog.getDialogPane().getButton(ButtonType.CANCEL);
        this.cancelButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                RemoteDeviceManagerSubDialog.this.cancelButton.setDisable(true);
                RemoteDeviceManagerSubDialog.this.dialog.close();
            }
        });
        this.addButton = this.isAddOperation ? this.dialog.getDialogPane().getButton(ButtonType.ADD) : this.dialog.getDialogPane().getButton(ButtonType.SAVE);
        this.addButton = this.dialog.getDialogPane().getButton(ButtonType.ADD);
        this.addButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                String name = nameTextField.getText();
                String ip = ipTextField.getText();
                String port = portTextField.getText();
                boolean isSuccess = false;
                isSuccess = RemoteDeviceManagerSubDialog.this.isAddOperation ? RemoteDeviceManagerSubDialog.this.dlg.addDeviceInfo(name, ip, port) : RemoteDeviceManagerSubDialog.this.dlg.modifyDeviceInfo(name, ip, port);
                if (isSuccess) {
                    RemoteDeviceManagerSubDialog.this.dialog.close();
                }
            }
        });
        this.dialog.show();
    }
}

