/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.device.manager.logview.view;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.css.PseudoClass;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Tab;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.util.Callback;
import org.tizen.device.manager.Messages;
import org.tizen.device.manager.control.ImageButton;
import org.tizen.device.manager.data.DeviceDescriptor;
import org.tizen.device.manager.data.SettingsPageInfo;
import org.tizen.device.manager.logview.controller.LogTabToolBarController;
import org.tizen.device.manager.logview.data.LimitedQueue;
import org.tizen.device.manager.logview.data.Log;
import org.tizen.device.manager.logview.data.LogLevel;
import org.tizen.device.manager.logview.data.LogMatcher;
import org.tizen.device.manager.logview.data.LogModel;
import org.tizen.device.manager.logview.model.LogItem;
import org.tizen.device.manager.logview.service.LogModelChangedListener;
import org.tizen.device.manager.logview.view.LogTabToolBar;
import org.tizen.device.manager.logview.view.LogTableView;
import org.tizen.device.manager.resources.ImageKind;
import org.tizen.device.manager.service.impl.SettingsInfoChangedListener;

public class LogTab
extends Tab {
    private DeviceDescriptor deviceDescriptor;
    private LogModel logModel;
    private BorderPane borderPane;
    private LogTabToolBar toolbar;
    private LogTableView tableView;
    private LimitedQueue<LogItem> logItems;
    private int limitedBufferSize;
    private LogTabToolBarController toolbarController;
    private boolean isScrollLock;
    public static final String LABEL_TIME = Messages.Log_Tab_Label_Time;
    public static final String LABEL_LEVEL = Messages.Log_Tab_Label_Level;
    public static final String LABEL_PID = Messages.Log_Tab_Label_Pid;
    public static final String LABEL_TID = Messages.Log_Tab_Label_Tid;
    public static final String LABEL_TAG = Messages.Log_Tab_Label_Tag;
    public static final String LABEL_MESSAGE = Messages.Log_Tab_Label_Message;
    private final LogModelChangedListener logModelChanedListener = new LogModelChangedListener(){

        @Override
        public void logAdded(final List<Log> matchedLogs) {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    for (Log log : matchedLogs) {
                        LogTab.this.logItems.add(new LogItem(log));
                    }
                    LogTab.this.tableView.getItems().setAll((Collection)LogTab.this.logItems);
                }
            });
        }

        @Override
        public void logCleared() {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    LogTab.this.logItems.clear();
                    LogTab.this.tableView.getItems().clear();
                    LogTab.this.tableView.getItems().setAll((Collection)LogTab.this.logItems);
                }
            });
        }

        @Override
        public void matcherChanged(LogMatcher logMatcher) {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    LogTab.this.logItems.clear();
                    LogTab.this.tableView.getItems().clear();
                    ArrayList<Log> matchedLogs = LogTab.this.logModel.getMatchedLogs();
                    for (Log log : matchedLogs) {
                        LogTab.this.logItems.add(new LogItem(log));
                    }
                    LogTab.this.tableView.getItems().setAll((Collection)LogTab.this.logItems);
                }
            });
        }
    };
    private final SettingsInfoChangedListener settingsInfoChangedListener = new SettingsInfoChangedListener(){

        @Override
        public void settingsInfoChanged(SettingsPageInfo settingsPageInfo) {
            int newSize = settingsPageInfo.getLogBufferSize();
            if (LogTab.this.limitedBufferSize != newSize) {
                LogTab.this.logItems = new LimitedQueue(newSize);
                LogTab.this.limitedBufferSize = newSize;
            }
        }
    };
    private final ListChangeListener<LogItem> itemChangeListener = new ListChangeListener<LogItem>(){

        public void onChanged(ListChangeListener.Change<? extends LogItem> c) {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    int size = LogTab.this.tableView.getItems().size();
                    if (!LogTab.this.isScrollLock && 0 < size) {
                        LogTab.this.tableView.scrollTo(size - 1);
                    }
                }
            });
        }
    };
    private final ChangeListener<String> messageTextFieldChangeListener = new ChangeListener<String>(){

        public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
            LogTab.this.toolbarController.changeMessageFilter(newValue);
        }
    };
    private final EventHandler<MouseEvent> editTabButtonClickedEventHandler = new EventHandler<MouseEvent>(){

        public void handle(MouseEvent event) {
            String tabname = LogTab.this.toolbarController.getNewTabName(LogTab.this.getText(), LogTab.this.deviceDescriptor);
            if (tabname != null) {
                LogTab.this.setText(tabname);
            }
        }
    };
    private final EventHandler<MouseEvent> clearLogButtonClickedEventHandler = new EventHandler<MouseEvent>(){

        public void handle(MouseEvent event) {
            LogTab.this.toolbarController.clearLog();
        }
    };
    private final EventHandler<MouseEvent> exportLogButtonClickedEventHandler = new EventHandler<MouseEvent>(){

        public void handle(MouseEvent event) {
            LogTab.this.toolbarController.exportLogToFile(LogTab.this.getText());
        }
    };
    private final EventHandler<MouseEvent> scrollLockButtonClickedEventHandler = new EventHandler<MouseEvent>(){

        public void handle(MouseEvent event) {
            LogTab.this.isScrollLock = !LogTab.this.isScrollLock;
        }
    };

    public static String generateDefaultTabName(DeviceDescriptor device) {
        return device.getSerialId() + " (" + device.getDeviceName() + ")";
    }

    public LogTab(DeviceDescriptor device, String tabname) throws Exception {
        super(tabname);
        this.setClosable(false);
        int limitSize = SettingsPageInfo.getInstance().getLogBufferSize();
        this.logItems = new LimitedQueue(SettingsPageInfo.getInstance().getLogBufferSize());
        this.limitedBufferSize = limitSize;
        this.deviceDescriptor = device;
        this.logModel = new LogModel(device, new LogMatcher());
        this.logModel.addModelChangedListener(this.logModelChanedListener);
        this.toolbarController = new LogTabToolBarController(this.logModel);
        this.isScrollLock = false;
        SettingsPageInfo.getInstance().addChangedListener(this.settingsInfoChangedListener);
        this.addCloseButton();
        this.createContent();
    }

    private void addCloseButton() {
        final LogTab tab = this;
        ImageButton closeButton = new ImageButton(ImageKind.ICON_LOGVIEW_CLOSE_TAB_NOR, ImageKind.ICON_LOGVIEW_CLOSE_TAB_OVER, ImageKind.ICON_LOGVIEW_CLOSE_TAB_DIM);
        closeButton.getPane().paddingProperty().set((Object)new Insets(0.0, 19.0, 0.0, 10.0));
        this.setGraphic((Node)closeButton.getPane());
        closeButton.setOnMouseClicked(new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                EventHandler handler = tab.getOnClosed();
                if (handler != null) {
                    handler.handle(null);
                }
                tab.getTabPane().getTabs().remove((Object)tab);
            }
        });
    }

    private void createContent() {
        this.borderPane = new BorderPane();
        this.toolbar = new LogTabToolBar();
        this.toolbar.addMessageTextFieldChangedEventListener(this.messageTextFieldChangeListener);
        this.toolbar.addEditTabButtonClickedEventHandler(this.editTabButtonClickedEventHandler);
        this.toolbar.addClearLogButtonClickedEventHandler(this.clearLogButtonClickedEventHandler);
        this.toolbar.addExportLogButtonClickedEventHandler(this.exportLogButtonClickedEventHandler);
        this.toolbar.addScrollLockButtonClickedEventHandler(this.scrollLockButtonClickedEventHandler);
        this.tableView = new LogTableView(this.logModel);
        ((ObservableList)this.tableView.itemsProperty().get()).addListener(this.itemChangeListener);
        this.tableView.setRowFactory((Callback)new Callback<TableView<LogItem>, TableRow<LogItem>>(){

            public TableRow<LogItem> call(TableView<LogItem> param) {
                return new TableRow<LogItem>(){

                    public void updateItem(LogItem item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        this.pseudoClassStateChanged(PseudoClass.getPseudoClass((String)LogLevel.ERROR.getName()), !empty && item.levelProperty().get() == LogLevel.ERROR.getName());
                        this.pseudoClassStateChanged(PseudoClass.getPseudoClass((String)LogLevel.DEBUG.getName()), !empty && item.levelProperty().get() == LogLevel.DEBUG.getName());
                        this.pseudoClassStateChanged(PseudoClass.getPseudoClass((String)LogLevel.WARN.getName()), !empty && item.levelProperty().get() == LogLevel.WARN.getName());
                        this.pseudoClassStateChanged(PseudoClass.getPseudoClass((String)LogLevel.INFO.getName()), !empty && item.levelProperty().get() == LogLevel.INFO.getName());
                    }
                };
            }
        });
        this.borderPane.setTop((Node)this.toolbar);
        this.borderPane.setCenter((Node)this.tableView);
        this.setContent((Node)this.borderPane);
    }

    public void connect() {
        this.logModel.listen();
        this.toolbar.setDisable(false);
    }

    public void disconnect() {
        this.logModel.release();
        this.toolbar.setDisable(true);
    }

    public LogModel getLogModel() {
        return this.logModel;
    }

    public LogItem getSelectedItem() {
        return (LogItem)this.tableView.getSelectionModel().getSelectedItem();
    }
}

