/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.device.manager.data;

public enum DeviceType {
    LOCAL_EMULATOR(1, "LOCAL-EMULATOR"),
    REMOTE_EMULATOR(2, "REMOTE-EMULATOR"),
    LOCAL_DEVICE(3, "LOCAL-DEVICE"),
    REMOTE_DEVICE(4, "REMOTE-DEVICE");

    private int typeCode;
    private String typeName;

    private DeviceType(int typeCode, String typeName) {
        this.typeCode = typeCode;
        this.typeName = typeName;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String toString() {
        return this.name();
    }

    public int getTypeCode() {
        return this.typeCode;
    }

    public boolean isRemoteDevice() {
        return this.typeCode == REMOTE_EMULATOR.getTypeCode() || this.typeCode == REMOTE_DEVICE.getTypeCode();
    }

    public boolean isEmulator() {
        return this.typeCode == LOCAL_EMULATOR.getTypeCode() || this.typeCode == REMOTE_EMULATOR.getTypeCode();
    }

    public static DeviceType getStateType(int typeCode) {
        for (DeviceType type : DeviceType.values()) {
            if (type.getTypeCode() != typeCode) continue;
            return type;
        }
        return null;
    }
}

