/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.device.manager.ui.diaglog;

import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import org.tizen.device.manager.Main;
import org.tizen.device.manager.Messages;
import org.tizen.device.manager.ui.diaglog.ButtonType;
import org.tizen.device.manager.ui.diaglog.Dialog;
import org.tizen.device.manager.ui.diaglog.FileEntryPropertyInfoPage;
import org.tizen.device.manager.ui.diaglog.FileEntryPropertyPermissionPage;
import org.tizen.device.manager.ui.diaglog.IFileEntryPropertyPage;
import org.tizen.sdblib.service.FileEntry;

public class FileEntryPropertyDialog
extends Dialog<String> {
    private TabPane tabPane;
    private FileEntryPropertyInfoPage infoPage;
    private FileEntryPropertyPermissionPage permissionPage;

    public FileEntryPropertyDialog(FileEntry fileEntry) {
        this.createContent(fileEntry);
    }

    private void createContent(FileEntry fileEntry) {
        this.setTitle(Messages.Properties_Dialog_Title + " " + fileEntry.getName());
        this.getDialogPane().getButtonTypes().add((Object)ButtonType.OK);
        this.getDialogPane().getButtonTypes().add((Object)ButtonType.CLOSE);
        this.tabPane = new TabPane();
        this.tabPane.setSide(Side.LEFT);
        this.tabPane.setRotateGraphic(true);
        this.tabPane.setTabClosingPolicy(TabPane.TabClosingPolicy.UNAVAILABLE);
        this.tabPane.getStylesheets().add((Object)Main.class.getResource("/view/tab_view.css").toExternalForm());
        this.tabPane.getStylesheets().addAll(Main.getBaseCssUrl());
        this.tabPane.setMinSize(700.0, 350.0);
        this.getDialogPane().setContent((Node)this.tabPane);
        this.infoPage = new FileEntryPropertyInfoPage(fileEntry);
        this.tabPane.getTabs().add((Object)this.createNewTab(this.infoPage));
        this.permissionPage = new FileEntryPropertyPermissionPage(fileEntry);
        this.tabPane.getTabs().add((Object)this.createNewTab(this.permissionPage));
    }

    private Tab createNewTab(IFileEntryPropertyPage page) {
        Tab tab = new Tab();
        Label label = new Label(page.getTitle());
        label.setMinWidth(80.0);
        label.getStyleClass().add((Object)"left-tab-label");
        label.setRotate(90.0);
        tab.setGraphic((Node)label);
        tab.setClosable(false);
        tab.setContent(page.getNode());
        return tab;
    }
}

