/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.device.manager.control;

import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.GridPane;
import org.tizen.device.manager.control.ButtonToggleEvent;
import org.tizen.device.manager.resources.ImageKind;
import org.tizen.device.manager.resources.Images;

public class ImageButton {
    protected GridPane pane;
    private final Label iconLabel;
    private ImageKind icon;
    private ImageKind hoverIcon;
    private ImageKind pressIcon;
    private ImageKind selectIcon;
    private ImageKind selectHoverIcon;
    private ImageKind selectPressIcon;
    private EventHandler<MouseEvent> onMouseClick = new EventHandler<MouseEvent>(){

        public void handle(MouseEvent arg0) {
        }
    };
    private EventHandler<ButtonToggleEvent> onSelected = new EventHandler<ButtonToggleEvent>(){

        public void handle(ButtonToggleEvent arg0) {
        }
    };
    protected final SimpleObjectProperty<BUTTON_STATE> stateProperty = new SimpleObjectProperty();
    boolean isToggleButton;
    boolean isSelected;

    public ImageButton(ImageKind icon, ImageKind overIcon, ImageKind pressIcon) {
        this(icon, overIcon, pressIcon, pressIcon);
        this.isToggleButton = false;
    }

    public ImageButton(ImageKind icon, ImageKind overIcon, ImageKind pressIcon, ImageKind selectIcon) {
        this(icon, overIcon, pressIcon, selectIcon, selectIcon, selectIcon);
        this.isToggleButton = true;
    }

    public ImageButton(ImageKind icon, ImageKind overIcon, ImageKind pressIcon, ImageKind selectIcon, ImageKind selectHoverIcon, ImageKind selectPressIcon) {
        this.pane = new GridPane();
        this.pane.setAlignment(Pos.CENTER);
        this.iconLabel = new Label();
        this.pane.add((Node)this.iconLabel, 0, 0);
        this.icon = icon;
        this.hoverIcon = overIcon;
        this.selectIcon = selectIcon;
        this.pressIcon = pressIcon;
        this.selectHoverIcon = selectHoverIcon;
        this.selectPressIcon = selectPressIcon;
        this.isSelected = false;
        this.stateProperty.set((Object)BUTTON_STATE.NORMAL);
        this.drawIcon();
        this.addMouseListener();
        this.addStateListener();
        this.isToggleButton = true;
    }

    protected void changeIcons(ImageKind icon, ImageKind hoverIcon, ImageKind pressIcon, ImageKind selectIcon) {
        if (icon != null) {
            this.icon = icon;
        }
        if (hoverIcon != null) {
            this.hoverIcon = hoverIcon;
        }
        if (pressIcon != null) {
            this.pressIcon = pressIcon;
        }
        if (selectIcon != null) {
            this.selectIcon = selectIcon;
            this.selectHoverIcon = selectIcon;
            this.selectPressIcon = selectIcon;
        }
        this.drawIcon();
    }

    public void setOnMouseClicked(EventHandler<MouseEvent> handler) {
        this.onMouseClick = handler;
    }

    public void setOnSelected(EventHandler<ButtonToggleEvent> handler) {
        this.onSelected = handler;
    }

    public GridPane getPane() {
        return this.pane;
    }

    public Label getIconLabel() {
        return this.iconLabel;
    }

    protected void setSelected(boolean selected, boolean isHover) {
        if (!this.isToggleButton) {
            this.stateProperty.set((Object)(isHover ? BUTTON_STATE.HOVER : BUTTON_STATE.NORMAL));
            return;
        }
        if (this.isSelected == selected) {
            return;
        }
        this.isSelected = selected;
        BUTTON_STATE bState = selected ? (isHover ? BUTTON_STATE.SELECT_HOVER : BUTTON_STATE.SELECT_NORMAL) : (isHover ? BUTTON_STATE.HOVER : BUTTON_STATE.NORMAL);
        this.stateProperty.set((Object)bState);
        this.onSelected.handle((Event)new ButtonToggleEvent(this.isSelected));
    }

    public void setDisable(boolean disable) {
        this.pane.setDisable(disable);
    }

    public void setSelected(boolean selected) {
        this.setSelected(selected, false);
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    private void addStateListener() {
        this.stateProperty.addListener((ChangeListener)new ChangeListener<BUTTON_STATE>(){

            public void changed(ObservableValue<? extends BUTTON_STATE> arg0, BUTTON_STATE arg1, BUTTON_STATE arg2) {
                ImageButton.this.drawIcon(arg2);
            }
        });
    }

    protected void drawIcon() {
        this.drawIcon((BUTTON_STATE)((Object)this.stateProperty.get()));
    }

    private void drawIcon(BUTTON_STATE state) {
        if (this.pane.isFocused()) {
            if (this.isSelected) {
                this.iconLabel.setGraphic((Node)new ImageView(Images.get(this.selectPressIcon)));
            } else {
                this.iconLabel.setGraphic((Node)new ImageView(Images.get(this.pressIcon)));
            }
            return;
        }
        switch (state) {
            case NORMAL: {
                this.iconLabel.setGraphic((Node)new ImageView(Images.get(this.icon)));
                break;
            }
            case HOVER: {
                this.iconLabel.setGraphic((Node)new ImageView(Images.get(this.hoverIcon)));
                break;
            }
            case PRESS: {
                this.iconLabel.setGraphic((Node)new ImageView(Images.get(this.pressIcon)));
                break;
            }
            case SELECT_NORMAL: {
                this.iconLabel.setGraphic((Node)new ImageView(Images.get(this.selectIcon)));
                break;
            }
            case SELECT_HOVER: {
                this.iconLabel.setGraphic((Node)new ImageView(Images.get(this.selectHoverIcon)));
                break;
            }
            case SELECT_PRESS: {
                this.iconLabel.setGraphic((Node)new ImageView(Images.get(this.selectPressIcon)));
                break;
            }
        }
    }

    protected void buttonReleased() {
        this.setSelected(!this.isSelected, true);
    }

    private void addMouseListener() {
        this.pane.setOnMouseReleased((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent e) {
                Bounds bound = ImageButton.this.pane.getBoundsInLocal();
                if (e.getX() > 0.0 && e.getX() < bound.getWidth() && e.getY() > 0.0 && e.getY() < bound.getHeight()) {
                    ImageButton.this.buttonReleased();
                    ImageButton.this.onMouseClick.handle((Event)e);
                }
            }
        });
        this.pane.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent arg0) {
                ImageButton.this.stateProperty.set((Object)(ImageButton.this.isToggleButton && ImageButton.this.isSelected ? BUTTON_STATE.SELECT_PRESS : BUTTON_STATE.PRESS));
            }
        });
        this.pane.setOnMouseEntered((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent arg0) {
                ImageButton.this.stateProperty.set((Object)(ImageButton.this.isToggleButton && ImageButton.this.isSelected ? BUTTON_STATE.SELECT_HOVER : BUTTON_STATE.HOVER));
            }
        });
        this.pane.setOnMouseExited((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent arg0) {
                ImageButton.this.stateProperty.set((Object)(ImageButton.this.isToggleButton && ImageButton.this.isSelected ? BUTTON_STATE.SELECT_NORMAL : BUTTON_STATE.NORMAL));
            }
        });
    }

    public void setTooltipText(String tooltip) {
        this.iconLabel.setTooltip(new Tooltip(tooltip));
    }

    static enum BUTTON_STATE {
        NORMAL,
        HOVER,
        PRESS,
        SELECT_NORMAL,
        SELECT_HOVER,
        SELECT_PRESS;

    }
}

