/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.device.manager.controller;

import java.util.ArrayList;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Callback;
import org.tizen.device.manager.Messages;
import org.tizen.device.manager.file.explorer.FileEntryTreeData;
import org.tizen.device.manager.logging.DeviceLogger;
import org.tizen.device.manager.model.DeviceFileExplorerEventHandler;
import org.tizen.device.manager.resources.ImageKind;
import org.tizen.device.manager.resources.ImagesView;

public class DeviceFileTreeCell
extends TreeCell<FileEntryTreeData> {
    static final Color TEXT_FILL_NORMAL = Color.web((String)"#585858");
    Label iconLabel;
    Label pathLabel;
    FileEntryTreeData treeData;
    private HBox hBox;
    private final ContextMenu contextMenu = new ContextMenu();
    private final Menu newMenu = new Menu(Messages.Device_File_Context_menu_Label_New);
    private final MenuItem mNewFileItem = new MenuItem(Messages.Device_File_Context_menu_Label_New_File);
    private final MenuItem mNewFolderItem = new MenuItem(Messages.Device_File_Context_menu_Label_New_Folder);
    private final MenuItem mRenameItem = new MenuItem(Messages.Device_File_Context_menu_Label_Rename);
    private final MenuItem mDeleteItem = new MenuItem(Messages.Device_File_Context_menu_Label_Delete);
    private final MenuItem mPushFileItem = new MenuItem(Messages.Device_File_Context_menu_Label_Push_File);
    private final MenuItem mPullFileItem = new MenuItem(Messages.Device_File_Context_menu_Label_Pull_File);
    private final MenuItem mRefreshItem = new MenuItem(Messages.Device_File_Context_menu_Label_Refresh);
    private final MenuItem mPropertiesItem = new MenuItem(Messages.Device_File_Context_menu_Label_Properties);
    private final MenuItem mOpenShellItem = new MenuItem(Messages.Device_File_Context_menu_Label_Open_Shell);
    private TreeView<FileEntryTreeData> selectTreeData;
    private final EventHandler<MouseEvent> mouseEvent = new EventHandler<MouseEvent>(){

        public void handle(MouseEvent event) {
            DeviceFileTreeCell.this.mouseEventHandler(event);
        }
    };

    public DeviceFileTreeCell(final TreeView<FileEntryTreeData> selectTreeData) {
        this.selectTreeData = selectTreeData;
        this.setOnMouseClicked(this.mouseEvent);
        this.setOnMouseEntered(this.mouseEvent);
        this.setOnMouseExited(this.mouseEvent);
        ObservableList items = this.contextMenu.getItems();
        ObservableList newMenuItems = this.newMenu.getItems();
        newMenuItems.addAll((Object[])new MenuItem[]{this.mNewFileItem, this.mNewFolderItem});
        items.add((Object)this.newMenu);
        items.add((Object)this.mRenameItem);
        items.add((Object)this.mDeleteItem);
        items.add((Object)new SeparatorMenuItem());
        items.add((Object)this.mPushFileItem);
        items.add((Object)this.mPullFileItem);
        items.add((Object)new SeparatorMenuItem());
        items.add((Object)this.mRefreshItem);
        items.add((Object)new SeparatorMenuItem());
        items.add((Object)this.mPropertiesItem);
        items.add((Object)this.mOpenShellItem);
        this.mNewFileItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                DeviceLogger.getLogger().fine("Click New File.....");
                DeviceFileExplorerEventHandler.addNewFileToDevice((FileEntryTreeData)((TreeItem)selectTreeData.getSelectionModel().getSelectedItem()).getValue(), (TreeView<FileEntryTreeData>)selectTreeData);
            }
        });
        this.mNewFolderItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                DeviceLogger.getLogger().fine("Click New Folder.....");
                DeviceFileExplorerEventHandler.addNewFolderToDevice((FileEntryTreeData)((TreeItem)selectTreeData.getSelectionModel().getSelectedItem()).getValue(), (TreeView<FileEntryTreeData>)selectTreeData);
            }
        });
        this.mRenameItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                DeviceLogger.getLogger().fine("Click Rename.....");
                DeviceFileExplorerEventHandler.renameToDevice((FileEntryTreeData)((TreeItem)selectTreeData.getSelectionModel().getSelectedItem()).getValue(), (TreeView<FileEntryTreeData>)selectTreeData);
            }
        });
        this.mDeleteItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                DeviceLogger.getLogger().fine("Click Delete.....");
                ObservableList selectTreeItems = selectTreeData.getSelectionModel().getSelectedItems();
                ArrayList<TreeItem<FileEntryTreeData>> deleteSelectTreeItems = new ArrayList<TreeItem<FileEntryTreeData>>();
                for (TreeItem seletTreeItem : selectTreeItems) {
                    deleteSelectTreeItems.add((TreeItem<FileEntryTreeData>)seletTreeItem);
                }
                DeviceFileExplorerEventHandler.deleteToDevice(deleteSelectTreeItems, (TreeView<FileEntryTreeData>)selectTreeData);
            }
        });
        this.mPushFileItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                DeviceLogger.getLogger().fine("Click Push the file.....");
                DeviceFileExplorerEventHandler.pushToDevice((FileEntryTreeData)((TreeItem)selectTreeData.getSelectionModel().getSelectedItem()).getValue(), (TreeView<FileEntryTreeData>)selectTreeData);
            }
        });
        this.mPullFileItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                DeviceLogger.getLogger().fine("Click Pull the file....");
                DeviceFileExplorerEventHandler.pullFromDevice((FileEntryTreeData)((TreeItem)selectTreeData.getSelectionModel().getSelectedItem()).getValue(), (TreeView<FileEntryTreeData>)selectTreeData);
            }
        });
        this.mRefreshItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                DeviceLogger.getLogger().fine("Click Refresh....");
                DeviceFileExplorerEventHandler.refreshToDevice((FileEntryTreeData)((TreeItem)selectTreeData.getSelectionModel().getSelectedItem()).getValue(), (TreeView<FileEntryTreeData>)selectTreeData);
            }
        });
        this.mPropertiesItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                DeviceLogger.getLogger().fine("Click Properties.....");
                DeviceFileExplorerEventHandler.showProperty((FileEntryTreeData)((TreeItem)selectTreeData.getSelectionModel().getSelectedItem()).getValue(), (TreeView<FileEntryTreeData>)selectTreeData);
            }
        });
        this.mOpenShellItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                DeviceLogger.getLogger().fine("Click Open shell.....");
                DeviceFileExplorerEventHandler.openShellToDevice((FileEntryTreeData)((TreeItem)selectTreeData.getSelectionModel().getSelectedItem()).getValue());
            }
        });
    }

    protected void updateItem(FileEntryTreeData data, boolean isblank) {
        super.updateItem((Object)data, isblank);
        this.setGraphic(null);
        if (isblank) {
            return;
        }
        this.hBox = new HBox();
        this.hBox.setAlignment(Pos.CENTER_LEFT);
        if (data == null) {
            ProgressIndicator indicator = new ProgressIndicator();
            indicator.setProgress(-1.0);
            indicator.setPrefSize(15.0, 15.0);
            this.hBox.getChildren().addAll((Object[])new Node[]{indicator, new Label(" (listing files...)  ")});
            this.setGraphic((Node)this.hBox);
            return;
        }
        this.treeData = data;
        this.iconLabel = new Label();
        this.pathLabel = new Label(data.getFileName());
        this.hBox.getChildren().addAll((Object[])new Node[]{this.iconLabel, this.pathLabel});
        this.pathLabel.setTextFill((Paint)TEXT_FILL_NORMAL);
        if (data.getFileType() == FileEntryTreeData.FileEntryTypeState.TYPE_FILE_LINK) {
            this.iconLabel.setGraphic((Node)ImagesView.getImageView(ImageKind.IMAGE_FILE_LINK.getFullName()));
        } else if (data.getFileType() == FileEntryTreeData.FileEntryTypeState.TYPE_DIRECTORY) {
            this.iconLabel.setGraphic((Node)ImagesView.getImageView(ImageKind.IMAGE_DIRECTORY.getFullName()));
        } else if (data.getFileType() == FileEntryTreeData.FileEntryTypeState.TYPE_DIRECTORY_LINK) {
            this.iconLabel.setGraphic((Node)ImagesView.getImageView(ImageKind.IMAGE_DIRECTORY_LINK.getFullName()));
        } else if (data.getFileType() == FileEntryTreeData.FileEntryTypeState.TYPE_ROOT_EMULATOR) {
            this.iconLabel.setGraphic((Node)ImagesView.getImageView(ImageKind.IMAGE_ROOT_EMULATOR.getFullName()));
        } else if (data.getFileType() == FileEntryTreeData.FileEntryTypeState.TYPE_ROOT_DEVICE) {
            this.iconLabel.setGraphic((Node)ImagesView.getImageView(ImageKind.IMAGE_ROOT_DEVICE.getFullName()));
        } else {
            this.iconLabel.setGraphic((Node)ImagesView.getImageView(ImageKind.IMAGE_FILE.getFullName()));
        }
        this.setGraphic((Node)this.hBox);
    }

    public static Callback<TreeView<FileEntryTreeData>, TreeCell<FileEntryTreeData>> extractor() {
        return new Callback<TreeView<FileEntryTreeData>, TreeCell<FileEntryTreeData>>(){

            public TreeCell<FileEntryTreeData> call(TreeView<FileEntryTreeData> arg0) {
                return new DeviceFileTreeCell(arg0);
            }
        };
    }

    void mouseEventHandler(MouseEvent event) {
        FileEntryTreeData deviceItem = (FileEntryTreeData)this.getItem();
        if (deviceItem == null) {
            return;
        }
        EventType type = event.getEventType();
        if (type == MouseEvent.MOUSE_CLICKED) {
            this.contextMenu.hide();
            if (this.selectTreeData == null) {
                return;
            }
            if (event.getButton() == MouseButton.SECONDARY) {
                if (this.selectTreeData == null) {
                    return;
                }
                boolean isFileType = !((FileEntryTreeData)((TreeItem)this.selectTreeData.getSelectionModel().getSelectedItem()).getValue()).isDirectory();
                this.mNewFileItem.setDisable(isFileType);
                this.mNewFolderItem.setDisable(isFileType);
                this.mRenameItem.setDisable(false);
                this.mDeleteItem.setDisable(false);
                this.mPushFileItem.setDisable(isFileType);
                this.mPullFileItem.setDisable(false);
                this.mPropertiesItem.setDisable(false);
                this.mOpenShellItem.setDisable(false);
                this.contextMenu.show((Node)this, event.getScreenX(), event.getScreenY());
            }
            return;
        }
        if (this.selectedProperty().get()) {
            return;
        }
    }
}

