/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.device.manager.service.impl;

import java.io.File;
import java.io.IOException;
import org.tizen.device.manager.InstallDeviceInfo;
import org.tizen.device.manager.Messages;
import org.tizen.device.manager.util.HostUtil;
import org.tizen.device.manager.util.OSUtil;
import org.tizen.library.sdkutils.api.impl.SDKUtils;

public class ActionProcessor {
    public static void startEmulatorManager() throws IOException {
        String exePath = InstallDeviceInfo.getToolEmulatorExeFile();
        if (exePath.equals("") || !HostUtil.exists(exePath)) {
            throw new IOException(Messages.getString("Device.Manager.Excutable.Processor.Start.Error"));
        }
        if (exePath.contains(" ")) {
            exePath = "\"" + exePath + "\"";
        }
        String command = OSUtil.isMac() ? "open " + exePath + ".app" : exePath;
        if (OSUtil.isLinux()) {
            command = command + " 1>/dev/null 2>/dev/null &";
            HostUtil.execute(command);
        } else {
            HostUtil.batchExecute(command, null, new File(InstallDeviceInfo.getToolEmulatorBinPath()));
        }
    }

    public static String remoteDeviceConnect(String deviceIp, String devicePort) throws IOException {
        String sdbPath = InstallDeviceInfo.getSdbPath();
        if (sdbPath.contains(" ")) {
            sdbPath = "\"" + sdbPath + "\"";
        }
        String sdbConnectDeviceCommand = sdbPath + " connect " + deviceIp + ":" + devicePort;
        String retStr = HostUtil.returnExecute(sdbConnectDeviceCommand);
        return retStr;
    }

    public static boolean remoteDeviceDisConnect(String deviceIp, String devicePort) {
        String sdbPath = InstallDeviceInfo.getSdbPath();
        if (sdbPath.contains(" ")) {
            sdbPath = "\"" + sdbPath + "\"";
        }
        String sdbConnectDeviceCommand = sdbPath + " disconnect " + deviceIp + ":" + devicePort;
        boolean isSuccess = HostUtil.execute(sdbConnectDeviceCommand);
        return isSuccess;
    }

    public static boolean startPackageManager() {
        SDKUtils sdkUtils = SDKUtils.getInstance();
        boolean isSuccess = sdkUtils.executePackageManager();
        return isSuccess;
    }

    public static void startCertificateManager() throws IOException {
        String exePath = InstallDeviceInfo.getToolCertificateManagerExeFile();
        if (exePath.equals("") || !HostUtil.exists(exePath)) {
            throw new IOException(Messages.getString("Certificate.Manager.Excutable.Processor.Start.Error"));
        }
        if (exePath.contains(" ")) {
            exePath = "\"" + exePath + "\"";
        }
        String command = OSUtil.isMac() ? "open " + exePath + ".app" : exePath;
        if (OSUtil.isLinux()) {
            command = command + " 1>/dev/null 2>/dev/null &";
            HostUtil.execute(command);
        } else {
            HostUtil.batchExecute(command, null, new File(InstallDeviceInfo.getToolCertificateManagerRootPath()));
        }
    }
}

