/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.device.manager.util;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.channels.Selector;
import java.util.logging.Level;
import org.tizen.device.manager.logging.DeviceLogger;

public class IOUtil {
    private static final int BUFFER_SIZE = 8192;

    public static void tryClose(Object ... closeables) {
        if (null == closeables) {
            return;
        }
        for (Object obj : closeables) {
            if (null == obj) continue;
            try {
                if (obj instanceof Closeable) {
                    ((Closeable)obj).close();
                    continue;
                }
                if (obj instanceof Selector) {
                    ((Selector)obj).close();
                    continue;
                }
                if (obj instanceof Socket) {
                    ((Socket)obj).close();
                    continue;
                }
                if (!(obj instanceof ServerSocket)) continue;
                ((ServerSocket)obj).close();
            }
            catch (IOException e) {
                DeviceLogger.getLogger().log(Level.WARNING, "Fail to close " + obj, e);
            }
        }
    }

    public static void tryFlush(Flushable ... flushables) {
        if (null == flushables) {
            return;
        }
        for (Flushable flushable : flushables) {
            if (null == flushable) continue;
            try {
                flushable.flush();
            }
            catch (IOException e) {
                DeviceLogger.getLogger().log(Level.WARNING, "Fail to flush " + flushable, e);
            }
        }
    }

    public static void redirect(InputStream in, OutputStream out) throws IOException {
        byte[] buffer = new byte[8192];
        int nRead = 0;
        int totalBytes = 0;
        while (0 < (nRead = in.read(buffer))) {
            out.write(buffer, 0, nRead);
            totalBytes += nRead;
        }
        IOUtil.tryFlush(out);
    }

    public static void redirect(Reader reader, Writer writer) throws IOException {
        char[] buffer = new char[8192];
        int nRead = 0;
        while (0 < (nRead = reader.read(buffer))) {
            writer.write(buffer, 0, nRead);
        }
        IOUtil.tryFlush(writer);
    }

    public static void redirect(Reader reader, StringBuffer writer) throws IOException {
        char[] buffer = new char[8192];
        int nRead = 0;
        while (0 < (nRead = reader.read(buffer))) {
            writer.append(buffer, 0, nRead);
        }
    }

    public static void redirect(Reader reader, StringBuilder writer) throws IOException {
        if (null == reader) {
            return;
        }
        char[] buffer = new char[8192];
        int nRead = 0;
        while (0 < (nRead = reader.read(buffer))) {
            writer.append(buffer, 0, nRead);
        }
    }

    public static byte[] getBytes(InputStream in) throws IOException {
        return IOUtil.getBytes(in, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getBytes(InputStream in, boolean bClose) throws IOException {
        byte[] byArray;
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        try {
            IOUtil.redirect(in, byteOut);
            byArray = byteOut.toByteArray();
        }
        catch (Throwable throwable) {
            IOUtil.tryClose(byteOut);
            if (bClose) {
                IOUtil.tryClose(in);
            }
            throw throwable;
        }
        IOUtil.tryClose(byteOut);
        if (bClose) {
            IOUtil.tryClose(in);
        }
        return byArray;
    }

    public static String getString(Reader reader) throws IOException {
        return IOUtil.getString(reader, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getString(Reader reader, boolean bClose) throws IOException {
        String string;
        StringBuilder writer = new StringBuilder();
        try {
            IOUtil.redirect(reader, writer);
            string = writer.toString();
        }
        catch (Throwable throwable) {
            IOUtil.tryClose(writer);
            if (bClose) {
                IOUtil.tryClose(reader);
            }
            throw throwable;
        }
        IOUtil.tryClose(writer);
        if (bClose) {
            IOUtil.tryClose(reader);
        }
        return string;
    }

    public static String getString(InputStream in) throws IOException {
        return IOUtil.getString(new InputStreamReader(in));
    }

    public static String getString(InputStream in, boolean bClose) throws IOException {
        return IOUtil.getString(new InputStreamReader(in), bClose);
    }
}

