/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.device.manager.util;

public enum ProfileAppType {
    NATIVE(0, "NATIVE_IDE"),
    WEB(1, "WEB_IDE"),
    PLATFORM(2, "PLATFORM_IDE");

    private int stateCode;
    private String stateName;

    private ProfileAppType(int stateCode, String stateName) {
        this.stateCode = stateCode;
        this.stateName = stateName;
    }

    public String getStateName() {
        return this.stateName;
    }

    public String toString() {
        return this.name();
    }

    public int getStateCode() {
        return this.stateCode;
    }

    public static ProfileAppType getAppTypeToCode(int stateCode) {
        for (ProfileAppType type : ProfileAppType.values()) {
            if (type.getStateCode() != stateCode) continue;
            return type;
        }
        return null;
    }

    public static ProfileAppType getAppTypeToName(String appType) {
        for (ProfileAppType type : ProfileAppType.values()) {
            if (!type.name().toLowerCase().equals(appType.toLowerCase())) continue;
            return type;
        }
        return null;
    }

    public static ProfileAppType getAppTypeToStateName(String appType) {
        for (ProfileAppType type : ProfileAppType.values()) {
            if (!type.stateName.toLowerCase().equals(appType.toLowerCase())) continue;
            return type;
        }
        return null;
    }
}

