/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.device.manager.control;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.tizen.sdblib.util.Assert;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XMLUtil {
    public static final String FILE_EXT_XML = "xml";

    public static Document create(InputStream in) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.parse(in);
    }

    public static Document create() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.newDocument();
    }

    public static void removeChildElements(Element element) {
        Assert.notNull(element);
        while (element.hasChildNodes()) {
            element.removeChild(element.getFirstChild());
        }
    }

    public static boolean isElementByAttributeWithValue(Node node, String attributeName, String attributeValue) {
        Assert.notNull(node);
        Assert.notNull(attributeName);
        Assert.notNull(attributeValue);
        if (node instanceof Element) {
            String attribute = ((Element)node).getAttribute(attributeName);
            return attributeValue.equals(attribute);
        }
        return false;
    }

    public static ByteArrayOutputStream createOutputStreamFromDocument(Document doc) throws TransformerException {
        Assert.notNull(doc);
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.transform(new DOMSource(doc), new StreamResult(outStream));
        return outStream;
    }

    public static Element getDocumentRootFromFile(File file) throws Exception {
        Assert.notNull(file);
        if (!file.isFile()) {
            return null;
        }
        URL fileUrl = file.toURI().toURL();
        InputStream in = fileUrl.openStream();
        Document fileDoc = XMLUtil.create(in);
        return fileDoc.getDocumentElement();
    }

    public static List<Element> getElementsByTag(Element parent, String tag) {
        Assert.notNull(parent);
        Assert.notNull(tag);
        ArrayList<Element> result = new ArrayList<Element>();
        NodeList nodeList = parent.getElementsByTagName(tag);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            result.add((Element)node);
        }
        return result;
    }

    public static List<Element> getChildrenOfElement(Element element) {
        ArrayList<Element> list = new ArrayList<Element>();
        NodeList children = element.getChildNodes();
        int l = children.getLength();
        for (int i = 0; i < l; ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1) continue;
            list.add((Element)child);
        }
        return list;
    }

    public static void setElementAttribute(Document doc, String attribute, String value, Element parent) {
        Attr attr = doc.createAttribute(attribute);
        attr.setNodeValue(value);
        parent.setAttributeNode(attr);
    }
}

