/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.device.manager.logview.data;

import java.util.ArrayList;
import java.util.logging.Level;
import org.tizen.device.manager.data.DeviceDescriptor;
import org.tizen.device.manager.data.SettingsPageInfo;
import org.tizen.device.manager.logging.DeviceLogger;
import org.tizen.device.manager.logview.data.LimitedQueue;
import org.tizen.device.manager.logview.data.Log;
import org.tizen.device.manager.logview.data.LogMatcher;
import org.tizen.device.manager.logview.parser.DlogParser;
import org.tizen.device.manager.logview.parser.DlogParserNew;
import org.tizen.device.manager.logview.parser.DlogTVParser;
import org.tizen.device.manager.logview.parser.DlogTVParserNew;
import org.tizen.device.manager.logview.parser.IDlogParser;
import org.tizen.device.manager.logview.service.LogModelChangedListener;
import org.tizen.device.manager.service.impl.SettingsInfoChangedListener;
import org.tizen.device.manager.util.ProfileInfo;
import org.tizen.device.manager.util.Version;
import org.tizen.sdblib.IDevice;
import org.tizen.sdblib.IShellOutputReceiver;
import org.tizen.sdblib.receiver.MultiLineReceiver;
import org.tizen.sdblib.util.DeviceUtil;

public class LogModel {
    private DeviceDescriptor device;
    private LogMatcher logMatcher;
    private LimitedQueue<Log> logs;
    private IDlogParser dlogParser;
    private Thread logReceiverThread;
    private LogReceiver logReceiver;
    private int limitedBufferSize;
    private ArrayList<LogModelChangedListener> logModelChangedListeners;
    private SettingsInfoChangedListener settingsChangedListener = new SettingsInfoChangedListener(){

        @Override
        public void settingsInfoChanged(SettingsPageInfo settingsPageInfo) {
            int newSize = settingsPageInfo.getLogBufferSize();
            if (LogModel.this.limitedBufferSize != newSize) {
                LogModel.this.stopLogReceiverThread();
                LogModel.this.logs = new LimitedQueue(newSize);
                LogModel.this.limitedBufferSize = newSize;
                LogModel.this.startLogReceiverThread();
            }
        }
    };
    private boolean levelNoneSelected = false;
    private boolean pIdNoneSelected = false;
    private boolean tIdNoneSelected = false;
    private boolean tagNoneSelected = false;

    public LogModel(DeviceDescriptor device, LogMatcher logMatcher) throws Exception {
        this.device = device;
        this.logMatcher = logMatcher;
        this.logs = new LimitedQueue(SettingsPageInfo.getInstance().getLogBufferSize());
        this.limitedBufferSize = SettingsPageInfo.getInstance().getLogBufferSize();
        this.logModelChangedListeners = new ArrayList();
        this.logReceiver = new LogReceiver();
        SettingsPageInfo.getInstance().addChangedListener(this.settingsChangedListener);
        ProfileInfo profileInfo = ProfileInfo.getProfileInfo(device.getIDevice());
        if (profileInfo != null) {
            if (profileInfo.isTV()) {
                boolean less4;
                String version = profileInfo.getLatestPlatformVersion();
                boolean bl = less4 = !new Version(version).isSameOrBiggerThanVersion4();
                this.dlogParser = less4 ? new DlogTVParser() : new DlogTVParserNew();
            } else {
                boolean less3;
                String version = profileInfo.getLatestPlatformVersion();
                boolean bl = less3 = !new Version(version).isSameOrBiggerThanVersion3();
                this.dlogParser = less3 ? new DlogParser() : new DlogParserNew();
            }
        } else {
            throw new Exception("cannot parse platform version for " + device.getPlatformName());
        }
    }

    private void startLogReceiverThread() {
        if (this.logReceiverThread != null) {
            this.logReceiverThread.interrupt();
        }
        this.logReceiverThread = new Thread(this.device.getSerialId() + " Logger"){

            @Override
            public void run() {
                while (!DeviceUtil.isOnline((IDevice)LogModel.this.device.getIDevice()) || LogModel.this.logReceiver == null || ((LogModel)LogModel.this).logReceiver.isCancelled) {
                    try {
                        2.sleep(2000L);
                    }
                    catch (InterruptedException e) {
                        DeviceLogger.getLogger().log(Level.INFO, "LogModel : Device is not online or logger is null/cancelled");
                        return;
                    }
                }
                if (LogModel.this.logReceiver == null || ((LogModel)LogModel.this).logReceiver.isCancelled) {
                    return;
                }
                try {
                    String command = null;
                    command = String.format(LogModel.this.dlogParser.getDlogUtilCommandFormat(), "*");
                    LogModel.this.device.getIDevice().executeShellCommand(command, (IShellOutputReceiver)LogModel.this.logReceiver, 0, "ISO-8859-1");
                }
                catch (Exception e) {
                    DeviceLogger.getLogger().log(Level.FINE, e.getMessage());
                }
            }
        };
        this.logReceiverThread.start();
    }

    private void stopLogReceiverThread() {
        if (this.logReceiverThread != null) {
            this.logReceiverThread.interrupt();
        }
    }

    public LimitedQueue<Log> getLogs() {
        return this.logs;
    }

    public ArrayList<Log> getMatchedLogs() {
        ArrayList<Log> matchedLogs = new ArrayList<Log>();
        if (this.isNoneSelected()) {
            return matchedLogs;
        }
        if (this.logMatcher.isEmptyMatcher()) {
            for (Log log : this.logs) {
                matchedLogs.add(log);
            }
        } else {
            for (Log log : this.logs) {
                if (!this.logMatcher.isMatched(log)) continue;
                matchedLogs.add(log);
            }
        }
        return matchedLogs;
    }

    public ArrayList<String> getUniqLogLevels() {
        ArrayList<String> levels = new ArrayList<String>();
        for (Log log : this.logs) {
            String level = log.getLevelName();
            if (levels.contains(level)) continue;
            levels.add(level);
        }
        return levels;
    }

    public ArrayList<String> getUniqPids() {
        ArrayList<String> pids = new ArrayList<String>();
        for (Log log : this.logs) {
            String pid = log.getPid();
            if (pids.contains(pid)) continue;
            pids.add(pid);
        }
        return pids;
    }

    public ArrayList<String> getUniqTids() {
        ArrayList<String> tids = new ArrayList<String>();
        for (Log log : this.logs) {
            String tid = log.getTid();
            if (tids.contains(tid)) continue;
            tids.add(tid);
        }
        return tids;
    }

    public ArrayList<String> getUniqTags() {
        ArrayList<String> tags = new ArrayList<String>();
        for (Log log : this.logs) {
            String tag = log.getTag();
            if (tags.contains(tag)) continue;
            tags.add(tag);
        }
        return tags;
    }

    public void addModelChangedListener(LogModelChangedListener listener) {
        this.logModelChangedListeners.add(listener);
    }

    public void removeModelChangedListener(LogModelChangedListener listener) {
        this.logModelChangedListeners.remove(listener);
    }

    public void listen() {
        this.startLogReceiverThread();
    }

    public void release() {
        this.stopLogReceiverThread();
    }

    public boolean isSameDevice(DeviceDescriptor targetDevice) {
        return this.device.getSerialId().equalsIgnoreCase(targetDevice.getSerialId()) && this.device.getDeviceName().equalsIgnoreCase(targetDevice.getDeviceName());
    }

    public void setDevice(DeviceDescriptor targetDevice) {
        this.device = targetDevice;
    }

    public ArrayList<String> getLogLevelCriterion() {
        return this.logMatcher.getLogLevel();
    }

    public ArrayList<String> getPidCriterion() {
        return this.logMatcher.getPids();
    }

    public ArrayList<String> getTidCriterion() {
        return this.logMatcher.getTids();
    }

    public ArrayList<String> getTagCriterion() {
        return this.logMatcher.getTags();
    }

    public void setLogLevelCriterion(ArrayList<String> levels) {
        this.logMatcher.setLogLevels(levels);
        for (LogModelChangedListener listener : this.logModelChangedListeners) {
            listener.matcherChanged(this.logMatcher);
        }
    }

    public void setPidCriterion(ArrayList<String> pids) {
        this.logMatcher.setPids(pids);
        for (LogModelChangedListener listener : this.logModelChangedListeners) {
            listener.matcherChanged(this.logMatcher);
        }
    }

    public void setTidCriterion(ArrayList<String> tids) {
        this.logMatcher.setTids(tids);
        for (LogModelChangedListener listener : this.logModelChangedListeners) {
            listener.matcherChanged(this.logMatcher);
        }
    }

    public void setTagCriterion(ArrayList<String> tags) {
        this.logMatcher.setTags(tags);
        for (LogModelChangedListener listener : this.logModelChangedListeners) {
            listener.matcherChanged(this.logMatcher);
        }
    }

    public void setMessageCriterion(ArrayList<String> messages) {
        this.logMatcher.setMessages(messages);
        for (LogModelChangedListener listener : this.logModelChangedListeners) {
            listener.matcherChanged(this.logMatcher);
        }
    }

    public void clearAllLogs() {
        this.logs.clear();
        for (LogModelChangedListener listener : this.logModelChangedListeners) {
            listener.logCleared();
        }
    }

    public boolean isNoneSelected() {
        return this.levelNoneSelected || this.pIdNoneSelected || this.tIdNoneSelected || this.tagNoneSelected;
    }

    public void setLogLevelNoneSelected(boolean value) {
        this.levelNoneSelected = value;
    }

    public void setPidLevelNoneSelected(boolean value) {
        this.pIdNoneSelected = value;
    }

    public void setTidLevelNoneSelected(boolean value) {
        this.tIdNoneSelected = value;
    }

    public void setTagLevelNoneSelected(boolean value) {
        this.tagNoneSelected = value;
    }

    private class LogReceiver
    extends MultiLineReceiver {
        public boolean isCancelled = false;

        public LogReceiver() {
            this.setTrimLines(false);
        }

        public void processNewLines(String[] lines) {
            if (!this.isCancelled) {
                ArrayList<Log> matchedLogs = new ArrayList<Log>();
                ArrayList<Log> parsedLogs = LogModel.this.dlogParser.parse(lines);
                LogModel.this.logs.addAll(parsedLogs);
                if (LogModel.this.isNoneSelected()) {
                    return;
                }
                for (Log log : parsedLogs) {
                    if (!LogModel.this.logMatcher.isMatched(log)) continue;
                    matchedLogs.add(log);
                }
                if (0 < matchedLogs.size()) {
                    for (LogModelChangedListener listener : LogModel.this.logModelChangedListeners) {
                        listener.logAdded(matchedLogs);
                    }
                }
            }
        }

        public boolean isCancelled() {
            return this.isCancelled;
        }
    }
}

