/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalysis.ide.eplugin.popup.actions;

import java.util.ArrayList;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.tizen.dynamicanalysis.ide.eplugin.nl.Labels;

public class SelectCheckpointDialog
extends SelectionDialog {
    private static final CheckPointColumn[] inputElement = new CheckPointColumn[]{new CheckPointColumn(Labels.INTERACTIVE_CHECKPOINT_LOCATION_BEFORE_DESCRIPTION, 1), new CheckPointColumn(Labels.INTERACTIVE_CHECKPOINT_LOCATION_AFTER_DESCRIPTION, 2)};
    private ILabelProvider labelProvider;
    private IStructuredContentProvider contentProvider;
    CheckboxTableViewer listViewer;
    private static final int SIZING_SELECTION_WIDGET_HEIGHT = 50;
    private static final int SIZING_SELECTION_WIDGET_WIDTH = 350;

    public SelectCheckpointDialog(Shell parentShell) {
        this(parentShell, inputElement, (IStructuredContentProvider)ArrayContentProvider.getInstance(), (ILabelProvider)new LabelProvider(), Labels.INTERACTIVE_CHECKPOINT_LOCATION_DIALOG_DESCRITPION);
    }

    public SelectCheckpointDialog(Shell parentShell, Object input, IStructuredContentProvider contentProvider, ILabelProvider labelProvider, String message) {
        super(parentShell);
        this.setTitle(Labels.INTERACTIVE_CHECKPOINT_LOCATION_DIALOG_TITLE);
        this.contentProvider = contentProvider;
        this.labelProvider = labelProvider;
        this.setMessage(message);
    }

    public int getLocation() {
        this.setHelpAvailable(false);
        int resultCode = this.open();
        if (resultCode == 0) {
            Object[] checkedElements = this.getResult();
            if (checkedElements.length == 2) {
                return 3;
            }
            return ((CheckPointColumn)checkedElements[0]).code;
        }
        return 0;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.initializeDialogUnits((Control)composite);
        this.createMessageArea(composite);
        this.listViewer = CheckboxTableViewer.newCheckList((Composite)composite, (int)2075);
        GridData data = new GridData(1808);
        data.heightHint = 50;
        data.widthHint = 350;
        this.listViewer.getTable().setLayoutData((Object)data);
        this.listViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.listViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.initializeViewer();
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    private void initializeViewer() {
        this.listViewer.setInput((Object)inputElement);
        this.listViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                SelectCheckpointDialog.this.listViewer.getTable().deselectAll();
                Object[] checkedElements = SelectCheckpointDialog.this.listViewer.getCheckedElements();
                if (checkedElements == null || checkedElements.length == 0) {
                    SelectCheckpointDialog.this.getOkButton().setEnabled(false);
                } else {
                    SelectCheckpointDialog.this.getOkButton().setEnabled(true);
                }
            }
        });
        this.listViewer.getTable().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SelectCheckpointDialog.this.listViewer.getTable().deselectAll();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                SelectCheckpointDialog.this.listViewer.getTable().deselectAll();
            }
        });
    }

    protected void okPressed() {
        Object[] children = this.contentProvider.getElements((Object)inputElement);
        if (children != null) {
            ArrayList<Object> list = new ArrayList<Object>();
            int i = 0;
            while (i < children.length) {
                Object element = children[i];
                if (this.listViewer.getChecked(element)) {
                    list.add(element);
                }
                ++i;
            }
            this.setResult(list);
        }
        super.okPressed();
    }

    protected Control createContents(Composite parent) {
        Composite composite = (Composite)super.createContents(parent);
        this.getOkButton().setEnabled(false);
        return composite;
    }

    private static class CheckPointColumn {
        String description;
        int code;

        CheckPointColumn(String description, int code) {
            this.description = description;
            this.code = code;
        }

        public String toString() {
            return this.description;
        }
    }
}

