/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalysis.ide.eplugin.launch;

import java.io.File;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.tizen.common.gom.launch.GomLaunchData;
import org.tizen.common.util.SWTUtil;
import org.tizen.dynamicanalysis.ide.eplugin.DALog;
import org.tizen.dynamicanalysis.ide.eplugin.nl.Labels;
import org.tizen.nativecommon.IXMLStore;
import org.tizen.nativecommon.ProjectUtil;
import org.tizen.nativecommon.launch.LaunchUtils;
import org.tizen.nativecommon.launch.TizenLaunchConfiguration;
import org.tizen.nativecommon.launch.ui.shortcut.TizenLaunchShortcut;
import org.tizen.sdblib.IDevice;

public class TizenNativeApplicationDAShortcut
extends TizenLaunchShortcut {
    private static String prevBuildConfigName = null;

    static String getPrevBuildConfigName() {
        String returnValue = prevBuildConfigName;
        prevBuildConfigName = null;
        return returnValue;
    }

    public void launch(ISelection selection, String mode) {
        IStructuredSelection structuredSelection = (IStructuredSelection)selection;
        Object firstElement = structuredSelection.getFirstElement();
        IProject project = null;
        if (firstElement instanceof IBinary) {
            IBinary binary = (IBinary)firstElement;
            project = binary.getCProject().getProject();
        } else if (firstElement instanceof IResource) {
            IResource resource = (IResource)firstElement;
            project = resource.getProject();
        }
        if (project != null) {
            try {
                if (this.isUnitTestProject(project)) {
                    DALog.dlgErrorMessage(Labels.MESSAGE_ERROR, Labels.MESSAGE_NOT_SUPPORT_UNIT_TEST_PROJECT);
                } else if (this.isIMEProject(project)) {
                    DALog.dlgErrorMessage(Labels.MESSAGE_ERROR, Labels.MESSAGE_NOT_SUPPORT_IME_PROJECT);
                } else {
                    this.searchAndLaunch(((IStructuredSelection)selection).toArray(), mode);
                }
            }
            catch (CoreException e) {
                this.rollBackBuildConfigSetting(project);
                DALog.dlgErrorMessage(Labels.MESSAGE_ERROR, e.getMessage());
            }
        }
    }

    public void launch(IEditorPart editor, String mode) {
        IFileEditorInput input = (IFileEditorInput)editor.getEditorInput();
        IProject project = input.getFile().getProject();
        if (project != null) {
            try {
                if (this.isUnitTestProject(project)) {
                    DALog.dlgErrorMessage(Labels.MESSAGE_ERROR, Labels.MESSAGE_NOT_SUPPORT_UNIT_TEST_PROJECT);
                } else if (this.isIMEProject(project)) {
                    DALog.dlgErrorMessage(Labels.MESSAGE_ERROR, Labels.MESSAGE_NOT_SUPPORT_IME_PROJECT);
                } else {
                    this.searchAndLaunch(new Object[]{editor.getEditorInput()}, mode);
                }
            }
            catch (CoreException e) {
                this.rollBackBuildConfigSetting(project);
                DALog.dlgErrorMessage(Labels.MESSAGE_ERROR, e.getMessage());
            }
        }
    }

    private ILaunchConfiguration createLaunchConfiguration(GomLaunchData data) {
        ILaunchConfiguration config = null;
        IProject project = data.getProject();
        IDevice device = LaunchUtils.getCurrentDeployDevice();
        try {
            String projectName = project.getName();
            String configName = data.getLaunchConfigurationName();
            ILaunchConfigurationType configType = this.getCLaunchConfigType();
            ILaunchConfigurationWorkingCopy wc = configType.newInstance(null, this.getLaunchManager().generateLaunchConfigurationName(configName));
            TizenLaunchConfiguration tc = new TizenLaunchConfiguration(wc, device);
            tc.setDefaults();
            String programName = String.valueOf(ProjectUtil.getDefaultConfiguration((IProject)project).getName()) + File.separatorChar + ProjectUtil.getBinaryName((IProject)project);
            wc.setAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", programName);
            wc.setAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", projectName);
            wc.setMappedResources(new IResource[]{project});
            wc.setAttribute("org.eclipse.cdt.launch.WORKING_DIRECTORY", "");
            LaunchUtils.setDeviceToLaunchConfiguration((ILaunchConfigurationWorkingCopy)wc, (IDevice)device);
            this.setStopAtMain(wc, project);
            ICProjectDescription projDes = CCorePlugin.getDefault().getProjectDescription(project);
            if (projDes != null) {
                String buildConfigID = projDes.getActiveConfiguration().getId();
                wc.setAttribute("org.eclipse.cdt.launch.PROJECT_BUILD_CONFIG_ID_ATTR", buildConfigID);
                String buildConfigName = projDes.getActiveConfiguration().getName();
                wc.setAttribute("org.tizen.nativeapp.launch.PROJECT_BUILD_CONFIG_NAME_ATTR", buildConfigName);
                config = wc.doSave();
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return config;
    }

    public ILaunchConfigurationType getCLaunchConfigType() {
        return this.getLaunchManager().getLaunchConfigurationType("%daProfileConfigTypeID");
    }

    private boolean isIMEProject(IProject project) {
        IXMLStore store = ProjectUtil.getXmlStore((IProject)project);
        return store.isImeCategory();
    }

    private boolean isUnitTestProject(IProject project) throws CoreException {
        String[] natures;
        String[] stringArray = natures = project.getDescription().getNatureIds();
        int n = natures.length;
        int n2 = 0;
        while (n2 < n) {
            String nature = stringArray[n2];
            if (nature.equals("org.tizen.tizentest.nature")) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void rollBackBuildConfigSetting(IProject project) {
        if (prevBuildConfigName != null) {
            ManagedBuildManager.getBuildInfo((IResource)project).setDefaultConfiguration(prevBuildConfigName);
            prevBuildConfigName = null;
        }
    }

    public void smartLaunch(final GomLaunchData data) {
        final ILaunchConfiguration configuration = this.createLaunchConfiguration(data);
        SWTUtil.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                DebugUITools.launch((ILaunchConfiguration)configuration, (String)data.getMode());
            }
        });
    }
}

