/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalysis.ide.eplugin;

import java.util.HashMap;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNodeSelector;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.ui.CDTUITools;
import org.eclipse.cdt.ui.text.SharedASTJob;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.tizen.dynamicanalysis.ide.eplugin.DALog;
import org.tizen.dynamicanalysis.ide.eplugin.communication.ServerStartup;
import org.tizen.dynamicanalysis.ide.eplugin.popup.actions.InteractiveUtil;

public class Activator
implements BundleActivator {
    public static final String PLUGIN_ID = "org.tizen.dynamicanalyzer";
    public static final String PROFILE_MODE = "profile";
    public static final Object InteractiveValidCheckJobLock = new Object();
    private static BundleContext context;
    private IResourceChangeListener listener;

    static BundleContext getContext() {
        return context;
    }

    public void start(BundleContext bundleContext) throws Exception {
        context = bundleContext;
        final IWorkspace workspace = ResourcesPlugin.getWorkspace();
        this.listener = new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                switch (event.getType()) {
                    case 1: {
                        final IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
                        final HashMap editorMap = new HashMap();
                        try {
                            event.getDelta().accept(new IResourceDeltaVisitor(){

                                public boolean visit(IResourceDelta delta) throws CoreException {
                                    IEditorInput editorInput;
                                    if (delta.getKind() == 4 && (editorInput = InteractiveUtil.getEditorInput(delta.getResource())) != null) {
                                        int i = 0;
                                        while (i < windows.length) {
                                            IWorkbenchPage[] pages = windows[i].getPages();
                                            int j = 0;
                                            while (j < pages.length) {
                                                IEditorPart editor = pages[j].findEditor(editorInput);
                                                if (editor != null) {
                                                    IMarker[] markers = delta.getResource().findMarkers("org.tizen.dynamicanalysis.ide.eplugin.interactivemarker", true, 1);
                                                    editorMap.put(editor, markers);
                                                }
                                                ++j;
                                            }
                                            ++i;
                                        }
                                    }
                                    return true;
                                }
                            });
                        }
                        catch (CoreException e) {
                            DALog.printLog((Exception)((Object)e));
                        }
                        for (final IEditorPart editorPart : editorMap.keySet()) {
                            final IMarker[] markerList = (IMarker[])editorMap.get(editorPart);
                            ITranslationUnit tu = (ITranslationUnit)CDTUITools.getEditorInputCElement((IEditorInput)editorPart.getEditorInput());
                            if (tu == null) continue;
                            SharedASTJob job = new SharedASTJob("Check validation of interactive checkpoint", tu){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                public IStatus runOnAST(ILanguage lang, IASTTranslationUnit ast) throws CoreException {
                                    IASTNodeSelector nodeSelector = ast.getNodeSelector(null);
                                    Object object = InteractiveValidCheckJobLock;
                                    synchronized (object) {
                                        workspace.removeResourceChangeListener(Activator.this.listener);
                                        int i = 0;
                                        while (i < markerList.length) {
                                            IMarker marker = markerList[i];
                                            Object offset = marker.getAttribute("charStart");
                                            if (offset != null) {
                                                IASTName name = nodeSelector.findEnclosingName(((Integer)offset).intValue(), 0);
                                                if (editorPart.isDirty()) break;
                                                boolean isValid = InteractiveUtil.isValidVariable(name);
                                                if (isValid) {
                                                    marker.setAttribute("variableName", (Object)InteractiveUtil.makeFullVariableName(name));
                                                }
                                                marker.setAttribute("isValid", isValid);
                                            }
                                            ++i;
                                        }
                                        workspace.addResourceChangeListener(Activator.this.listener);
                                    }
                                    return Status.OK_STATUS;
                                }
                            };
                            job.schedule();
                        }
                        break;
                    }
                }
            }
        };
        workspace.addResourceChangeListener(this.listener);
    }

    public void stop(BundleContext bundleContext) throws Exception {
        context = null;
        ServerStartup.stopServerThread();
    }
}

