/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalysis.ide.eplugin.launch;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.tizen.common.IApplicationConfiguration;
import org.tizen.common.connection.ConnectionPlugin;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.common.launch.LaunchMessages;
import org.tizen.common.rds.ui.preference.RdsPreferencePage;
import org.tizen.common.ui.view.console.ConsoleManager;
import org.tizen.common.util.HostUtil;
import org.tizen.common.util.OSChecker;
import org.tizen.common.util.log.FileAppender;
import org.tizen.common.util.log.UserLogger;
import org.tizen.dynamicanalysis.ide.eplugin.Activator;
import org.tizen.dynamicanalysis.ide.eplugin.DALog;
import org.tizen.dynamicanalysis.ide.eplugin.communication.DAServerManager;
import org.tizen.dynamicanalysis.ide.eplugin.launch.CheckPointInfo;
import org.tizen.dynamicanalysis.ide.eplugin.launch.ProjectType;
import org.tizen.dynamicanalysis.ide.eplugin.nl.Labels;
import org.tizen.nativecommon.ProjectUtil;
import org.tizen.nativecommon.build.CommonConfigurationManager;
import org.tizen.nativecommon.launch.LaunchUtils;
import org.tizen.nativecommon.launch.TizenLaunchCommand;
import org.tizen.nativecommon.launch.TizenLaunchDelegate;
import org.tizen.nativecommon.launch.TizenLaunchMessages;

public class TizenNativeApplicationDADelegate
extends TizenLaunchDelegate {
    private static final String TOOLS = "tools";
    private static final String DYNAMIC_ANALYZER = "dynamic-analyzer";
    private boolean doProfileWithCheckPoint = false;
    private boolean doProfile = true;

    public boolean buildForLaunch(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        IProject project = ProjectUtil.getProject((ILaunchConfiguration)configuration);
        boolean isDebug = CommonConfigurationManager.isDebugMode((IConfiguration)this.getBuildConfiguration(this.getBuildConfigName(configuration), project));
        if (isDebug) {
            this.doProfile = true;
            this.doProfileWithCheckPoint = true;
            return super.buildForLaunch(configuration, mode, monitor);
        }
        this.doProfileWithCheckPoint = false;
        IMarker[] markers = project.findMarkers("org.tizen.dynamicanalysis.ide.eplugin.interactivemarker", true, 2);
        if (markers == null || markers.length == 0) {
            this.doProfile = true;
            return this.doProfile;
        }
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                TizenNativeApplicationDADelegate.this.doProfile = MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Labels.INTERACTIVE_DIALOG_TITLE_WARNING_BUILD_MODE, (String)Labels.INTERACTIVE_DIALOG_MSG_WARNING_BUILD_MODE);
            }
        });
        return this.doProfile;
    }

    public void launch(ILaunchConfiguration config, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        if (!this.doProfile) {
            ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
            launchManager.removeLaunch(launch);
            return;
        }
        UserLogger.start((String)"native.launch");
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        IProject project = ProjectUtil.getProject((ILaunchConfiguration)config);
        try {
            try {
                monitor.beginTask(TizenLaunchMessages.LAUNCH_APPLICATION, 20);
                monitor.subTask(TizenLaunchMessages.LAUNCH_APPLICATION);
                if ("launched already".equals(launch.getAttribute("LAUNCH_ATTR_KEY_IS_LAUNCHING"))) {
                    throw new CoreException((IStatus)new Status(4, "org.tizen.dynamicanalyzer", NLS.bind((String)LaunchMessages.LAUNCHED_ALREADY, (Object)project.getName())));
                }
                LaunchUtils.verifyExecutableProject((IProject)project);
                this.verifyCProjectConfigurationSettings(config);
                this.currentDevice = ConnectionPlugin.getDefault().getTargetToolBarManager().getDefaultLaunchTarget(project, (IProgressMonitor)new SubProgressMonitor(monitor, 15));
                this.verifyBuildConfiguration(config, mode, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                this.setConsole(config);
                this.tizenCommand = LaunchUtils.isVerboseMode((ILaunchConfiguration)config) ? new TizenLaunchCommand(this.currentDevice, (ConsoleManager)this.launchConsole) : new TizenLaunchCommand(this.currentDevice, null);
                this.launchConsole.show();
                FileAppender fileAppender = (FileAppender)Logger.getRootLogger().getAppender("TIZEN_FILE_APPENDER");
                String logPath = fileAppender != null ? fileAppender.getLogPath() : "";
                this.launchConsole.println(NLS.bind((String)LaunchMessages.LAUNCH_START, (Object)logPath));
                Long startLaunchTime = 0L;
                Long endLaunchTime = 0L;
                try {
                    monitor.beginTask(TizenLaunchMessages.LAUNCH_APPLICATION, 10);
                    monitor.subTask(TizenLaunchMessages.LAUNCH_APPLICATION);
                    startLaunchTime = System.currentTimeMillis();
                    this.deployApplication(config, (IProgressMonitor)new SubProgressMonitor(monitor, 9));
                    this.verifyLaunchableProject(config, "run");
                    String device = LaunchUtils.getCurrentDeployDevice().toString();
                    ProjectType projectType = ProjectType.OSP;
                    String binaryOfTarget = "";
                    String executablePath = "";
                    List<String> localPackagePathList = null;
                    if (this.isDAReady()) {
                        IApplicationConfiguration adapter = (IApplicationConfiguration)project.getAdapter(IApplicationConfiguration.class);
                        binaryOfTarget = adapter.getAppId();
                        String debugBinaryPath = null;
                        IPath exePath = CDebugUtils.verifyProgramPath((ILaunchConfiguration)config);
                        if (exePath != null) {
                            debugBinaryPath = exePath.toOSString();
                        }
                        this.runDynamicAnalyzer(device, projectType, binaryOfTarget, executablePath, localPackagePathList, this.getProfileVariableInfos(project, config), debugBinaryPath);
                    }
                }
                finally {
                    endLaunchTime = System.currentTimeMillis();
                    this.launchConsole.println(LaunchMessages.getElapsedTimeMessage((Long)startLaunchTime, (Long)endLaunchTime));
                    monitor.done();
                }
            }
            catch (OperationCanceledException operationCanceledException) {
                if (!launch.isTerminated()) {
                    launch.terminate();
                }
                ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
                launchManager.removeLaunch(launch);
                this.firePostLaunched(project, RdsPreferencePage.isRdsMode((IProject)project));
                monitor.done();
                UserLogger.end((String)"native.launch");
                return;
            }
        }
        finally {
            if (!launch.isTerminated()) {
                launch.terminate();
            }
            ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
            launchManager.removeLaunch(launch);
            this.firePostLaunched(project, RdsPreferencePage.isRdsMode((IProject)project));
            monitor.done();
            UserLogger.end((String)"native.launch");
        }
    }

    private Set<CheckPointInfo> getProfileVariableInfos(final IProject project, ILaunchConfiguration config) {
        final HashSet<CheckPointInfo> profileVariableInfos = new HashSet<CheckPointInfo>();
        if (this.doProfileWithCheckPoint) {
            Display.getDefault().syncExec(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        IMarker[] markers = project.findMarkers("org.tizen.dynamicanalysis.ide.eplugin.interactivemarker", true, 2);
                        Object object = Activator.InteractiveValidCheckJobLock;
                        synchronized (object) {
                            int i = 0;
                            while (i < markers.length) {
                                boolean isChecked = (Boolean)markers[i].getAttribute("done");
                                boolean isValid = (Boolean)markers[i].getAttribute("isValid");
                                if (isChecked && isValid) {
                                    String sourcePath = markers[i].getAttribute("sourcePath", "");
                                    String variableName = markers[i].getAttribute("variableName", "");
                                    int line = markers[i].getAttribute("lineNumber", 0);
                                    int arrayCount = markers[i].getAttribute("arrayCount", 0);
                                    int checkLocation = markers[i].getAttribute("checkLocation", 0);
                                    CheckPointInfo info = new CheckPointInfo(sourcePath, variableName, line, arrayCount, checkLocation);
                                    profileVariableInfos.add(info);
                                }
                                ++i;
                            }
                        }
                    }
                    catch (CoreException e) {
                        DALog.printLog((Exception)((Object)e));
                    }
                }
            });
        }
        return profileVariableInfos;
    }

    private boolean isDAReady() {
        if (DAServerManager.getInstance().getClientSocket() != null) {
            return DAServerManager.getInstance().sendDAStatusMessage();
        }
        return true;
    }

    private boolean executeWindowsCommand(String command) {
        if (command == null) {
            return false;
        }
        Process proc = null;
        Runtime runtime = Runtime.getRuntime();
        String[] fullCommand = new String[]{"cmd", "/c", command, "isAutoStart"};
        boolean bSuccuss = true;
        try {
            try {
                proc = runtime.exec(fullCommand);
                Thread.sleep(1000L);
            }
            catch (IOException iOException) {
                bSuccuss = false;
                DALog.printLog("TizenNativeApplicationProfileDelegate - executeWindowsCommand - IOException");
                if (proc != null) {
                    proc.destroy();
                }
            }
            catch (InterruptedException interruptedException) {
                bSuccuss = false;
                DALog.printLog("TizenNativeApplicationProfileDelegate - executeWindowsCommand - InterruptedException");
                if (proc != null) {
                    proc.destroy();
                }
            }
        }
        finally {
            if (proc != null) {
                proc.destroy();
            }
        }
        return bSuccuss;
    }

    private void runDynamicAnalyzer(String device, ProjectType projectType, String binaryOfTarget, String executablePath, List<String> localPackagePathList, Set<CheckPointInfo> interactiveInfoSet, String debugBinaryPath) {
        if (DAServerManager.getInstance().getClientSocket() == null) {
            StringBuffer command = new StringBuffer();
            if (OSChecker.isWindows()) {
                command.append(String.valueOf(InstallPathConfig.getSDKPath()) + File.separatorChar + TOOLS + File.separator + DYNAMIC_ANALYZER + File.separatorChar + DYNAMIC_ANALYZER + ".exe");
            } else if (OSChecker.isMAC()) {
                command.append(String.valueOf(InstallPathConfig.getSDKPath()) + File.separatorChar + TOOLS + File.separator + DYNAMIC_ANALYZER + File.separatorChar + DYNAMIC_ANALYZER + ".app");
            } else {
                command.append(String.valueOf(InstallPathConfig.getSDKPath()) + File.separatorChar + TOOLS + File.separator + DYNAMIC_ANALYZER + File.separatorChar + DYNAMIC_ANALYZER);
            }
            File file = new File(command.toString());
            if (OSChecker.isMAC()) {
                if (!file.isDirectory()) {
                    DALog.dlgErrorMessage(Labels.MESSAGE_ERROR, Labels.MESSAGE_DYNAMIC_ANALYZER_IS_NOT_INSTALLED);
                } else {
                    String macCommand = "open " + command.toString() + " --args isAutoStart&";
                    DALog.printLog(macCommand);
                    HostUtil.execute((String)macCommand);
                }
            } else if (!file.isFile()) {
                DALog.dlgErrorMessage(Labels.MESSAGE_ERROR, Labels.MESSAGE_DYNAMIC_ANALYZER_IS_NOT_INSTALLED);
            } else if (OSChecker.isWindows()) {
                if (!this.executeWindowsCommand(command.toString())) {
                    return;
                }
            } else {
                command.append(" isAutoStart&");
                HostUtil.execute((String)command.toString());
            }
            DAServerManager.getInstance().reserveTraceApplication(device, projectType, binaryOfTarget, executablePath, localPackagePathList, interactiveInfoSet, debugBinaryPath);
        } else {
            DAServerManager.getInstance().runTraceApplication(device, projectType, binaryOfTarget, executablePath, localPackagePathList, interactiveInfoSet, debugBinaryPath);
        }
    }

    protected String getPluginID() {
        return "org.tizen.dynamicanalyzer";
    }

    protected String getBuildConfigName(ILaunchConfiguration config) throws CoreException {
        String buildConfigName = config.getAttribute("org.tizen.nativeapp.launch.PROJECT_BUILD_CONFIG_NAME_ATTR", "");
        if (buildConfigName.isEmpty()) {
            IProject project = ProjectUtil.getProject((ILaunchConfiguration)config);
            IConfiguration configuration = ManagedBuildManager.getBuildInfo((IResource)project).getDefaultConfiguration();
            return configuration.getName();
        }
        return buildConfigName;
    }

    protected IConfiguration getBuildConfiguration(String buildConfigName, IProject project) throws CoreException {
        IConfiguration[] configurations;
        IConfiguration configuration = null;
        IConfiguration[] iConfigurationArray = configurations = ManagedBuildManager.getBuildInfo((IResource)project).getManagedProject().getConfigurations();
        int n = configurations.length;
        int n2 = 0;
        while (n2 < n) {
            IConfiguration c = iConfigurationArray[n2];
            if (c.getName().equals(buildConfigName)) {
                configuration = c;
                break;
            }
            ++n2;
        }
        if (configuration == null) {
            this.newCoreException(TizenLaunchMessages.BUILD_CONFIGURATION_DOES_NOT_MATCH_WITH_CURRENT_DEVICE_TYPE, null);
        }
        return configuration;
    }

    protected String getArguments(ILaunchConfiguration config) throws CoreException {
        String appPath = config.getAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", "");
        String arguments = org.eclipse.cdt.launch.LaunchUtils.getProgramArguments((ILaunchConfiguration)config);
        String executableWithArguments = "";
        executableWithArguments = arguments != null && !arguments.equals("") ? String.valueOf(appPath) + " " + arguments : appPath;
        return executableWithArguments;
    }
}

