/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalysis.ide.eplugin.popup.actions;

import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNodeSelector;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IArrayType;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IVariable;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.ui.CDTUITools;
import org.eclipse.cdt.ui.ICEditor;
import org.eclipse.cdt.ui.text.SharedASTJob;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionDelegate;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.tizen.dynamicanalysis.ide.eplugin.DALog;
import org.tizen.dynamicanalysis.ide.eplugin.nl.Labels;
import org.tizen.dynamicanalysis.ide.eplugin.popup.actions.InteractiveUtil;
import org.tizen.dynamicanalysis.ide.eplugin.popup.actions.SelectCheckpointDialog;
import org.tizen.dynamicanalysis.ide.eplugin.views.InteractiveProfileView;

public class AddProfileVariableActionDelegate
extends ActionDelegate
implements IEditorActionDelegate {
    public void run(IAction action) {
        IEditorPart part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (part instanceof ICEditor) {
            ICEditor editor = (ICEditor)part;
            IEditorInput input = editor.getEditorInput();
            final IFile file = ((FileEditorInput)input).getFile();
            ISelection sel = editor.getSelectionProvider().getSelection();
            if (sel instanceof TextSelection) {
                final ITextSelection textSel = (ITextSelection)sel;
                ITranslationUnit tu = (ITranslationUnit)CDTUITools.getEditorInputCElement((IEditorInput)part.getEditorInput());
                IDocumentProvider prov = editor.getDocumentProvider();
                IDocument doc = prov.getDocument((Object)editor.getEditorInput());
                int lineNum = textSel.getStartLine() + 1;
                if (!InteractiveUtil.isValidLine(tu, lineNum, textSel.getOffset(), doc)) {
                    this.notifyInvalidLine();
                    return;
                }
                SharedASTJob job = new SharedASTJob("Check validation of interactive checkpoint", tu){

                    public IStatus runOnAST(ILanguage lang, IASTTranslationUnit ast) throws CoreException {
                        IASTNodeSelector nodeSelector = ast.getNodeSelector(null);
                        IASTName name = nodeSelector.findEnclosingName(textSel.getOffset(), textSel.getLength());
                        if (name != null) {
                            IBinding b = name.resolveBinding();
                            if (b == null || !(b instanceof IVariable)) {
                                AddProfileVariableActionDelegate.this.notifyInvalidVariable();
                            } else {
                                int arrayCount = 0;
                                if (((IVariable)b).getType() instanceof IArrayType) {
                                    arrayCount = ((IArrayType)((IVariable)b).getType()).getSize().numericalValue().intValue();
                                }
                                int line = textSel.getStartLine() + 1;
                                int offset = textSel.getOffset();
                                int length = name.toString().length();
                                String fullName = InteractiveUtil.makeFullVariableName(name);
                                AddProfileVariableActionDelegate.this.setInteractiveInfo(fullName, arrayCount, line, offset, length, file);
                            }
                        } else {
                            AddProfileVariableActionDelegate.this.notifyInvalidVariable();
                        }
                        return Status.OK_STATUS;
                    }
                };
                job.schedule();
            }
        }
    }

    private void setInteractiveInfo(final String varName, final int arrayCount, final int line, final int offset, int length, final IFile file) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    InteractiveProfileView view = (InteractiveProfileView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.tizen.dynamicanalysis.ide.eplugin.views.InteractiveProfileView");
                    view.showBusy(true);
                }
                catch (PartInitException e) {
                    DALog.printLog((Exception)((Object)e));
                }
                SelectCheckpointDialog selectCheckPointDialog = new SelectCheckpointDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
                int checkLocation = selectCheckPointDialog.getLocation();
                if (checkLocation != 0) {
                    try {
                        IMarker marker = file.createMarker("org.tizen.dynamicanalysis.ide.eplugin.interactivemarker");
                        if (marker != null) {
                            marker.setAttribute("lineNumber", line);
                            marker.setAttribute("charStart", offset);
                            marker.setAttribute("charEnd", offset);
                            marker.setAttribute("userEditable", true);
                            marker.setAttribute("done", true);
                            marker.setAttribute("variableName", (Object)varName);
                            marker.setAttribute("sourcePath", (Object)file.getLocation().toOSString());
                            marker.setAttribute("arrayCount", arrayCount);
                            marker.setAttribute("checkLocation", checkLocation);
                            marker.setAttribute("isValid", true);
                        }
                    }
                    catch (CoreException e) {
                        DALog.printLog((Exception)((Object)e));
                    }
                    MessageBox box = new MessageBox(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
                    box.setText(Labels.INTERACTIVE_DIALOG_TITLE_SUCCESS);
                    box.setMessage(Labels.INTERACTIVE_DIALOG_MSG_SUCCESS);
                    box.open();
                }
            }
        });
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
    }

    private void notifyInvalidVariable() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageBox box = new MessageBox(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 1);
                box.setText(Labels.INTERACTIVE_DIALOG_TITLE_ERROR);
                box.setMessage(Labels.INTERACTIVE_DIALOG_MSG_INVALID_VARIABLE);
                box.open();
            }
        });
    }

    private void notifyInvalidLine() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageBox box = new MessageBox(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 1);
                box.setText(Labels.INTERACTIVE_DIALOG_TITLE_ERROR);
                box.setMessage(Labels.INTERACTIVE_DIALOG_MSG_INVALID_LINE);
                box.open();
            }
        });
    }
}

