/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalysis.ide.web.eplugin.launch;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.tizen.common.ITizenProject;
import org.tizen.common.connection.ConnectionPlugin;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.common.launch.context.ILaunchContext;
import org.tizen.common.util.HostUtil;
import org.tizen.common.util.OSChecker;
import org.tizen.common.util.ProjectUtil;
import org.tizen.dynamicanalysis.ide.web.eplugin.DALog;
import org.tizen.dynamicanalysis.ide.web.eplugin.communication.DAServerManager;
import org.tizen.dynamicanalysis.ide.web.eplugin.launch.CheckPointInfo;
import org.tizen.dynamicanalysis.ide.web.eplugin.launch.ProjectType;
import org.tizen.dynamicanalysis.ide.web.eplugin.nl.Labels;
import org.tizen.web.zimlaunch.core.CompositeStep;
import org.tizen.web.zimlaunch.core.IStep;
import org.tizen.web.zimlaunch.util.LaunchUtil;

public class DARunStep
extends CompositeStep {
    private static final String TOOLS = "tools";
    private static final String DYNAMIC_ANALYZER = "dynamic-analyzer";

    public DARunStep() {
        super(new IStep[0]);
    }

    public void executeStep(ILaunchContext ctx) throws Exception {
        String device = ConnectionPlugin.getDefault().getCurrentDevice().toString();
        ProjectType projectType = ProjectType.WEBAPP;
        String binaryOfTarget = "";
        String executablePath = "";
        List<String> localPackagePathList = null;
        HashSet<CheckPointInfo> interactiveInfoSet = new HashSet<CheckPointInfo>();
        String debugBinaryPath = " ";
        if (this.isDAReady()) {
            ILaunchConfiguration configuration = (ILaunchConfiguration)ctx.getValue((Object)"config");
            IProject project = LaunchUtil.getProject((ILaunchConfiguration)configuration);
            ITizenProject tizenProject = ProjectUtil.getTizenProject((IProject)project);
            binaryOfTarget = tizenProject.getAppId();
            this.runDynamicAnalyzer(device, projectType, binaryOfTarget, executablePath, localPackagePathList, interactiveInfoSet, debugBinaryPath);
        }
    }

    private boolean isDAReady() {
        if (DAServerManager.getInstance().getClientSocket() != null) {
            return DAServerManager.getInstance().sendDAStatusMessage();
        }
        return true;
    }

    private boolean executeWindowsCommand(String command) {
        if (command == null) {
            return false;
        }
        Process proc = null;
        Runtime runtime = Runtime.getRuntime();
        String[] fullCommand = new String[]{"cmd", "/c", command, "isAutoStart"};
        boolean bSuccuss = true;
        try {
            try {
                proc = runtime.exec(fullCommand);
                Thread.sleep(1000L);
            }
            catch (IOException iOException) {
                bSuccuss = false;
                DALog.printLog("TizenWebApplicationProfileDelegate - executeWindowsCommand - IOException");
                if (proc != null) {
                    proc.destroy();
                }
            }
            catch (InterruptedException interruptedException) {
                bSuccuss = false;
                DALog.printLog("TizenWebApplicationProfileDelegate - executeWindowsCommand - InterruptedException");
                if (proc != null) {
                    proc.destroy();
                }
            }
        }
        finally {
            if (proc != null) {
                proc.destroy();
            }
        }
        return bSuccuss;
    }

    private void runDynamicAnalyzer(String device, ProjectType projectType, String binaryOfTarget, String executablePath, List<String> localPackagePathList, Set<CheckPointInfo> interactiveInfoSet, String debugBinaryPath) {
        if (DAServerManager.getInstance().getClientSocket() == null) {
            StringBuffer command = new StringBuffer();
            if (OSChecker.isWindows()) {
                command.append(String.valueOf(InstallPathConfig.getSDKPath()) + File.separatorChar + TOOLS + File.separator + DYNAMIC_ANALYZER + File.separatorChar + DYNAMIC_ANALYZER + ".exe");
            } else if (OSChecker.isMAC()) {
                command.append(String.valueOf(InstallPathConfig.getSDKPath()) + File.separatorChar + TOOLS + File.separator + DYNAMIC_ANALYZER + File.separatorChar + DYNAMIC_ANALYZER + ".app");
            } else {
                command.append(String.valueOf(InstallPathConfig.getSDKPath()) + File.separatorChar + TOOLS + File.separator + DYNAMIC_ANALYZER + File.separatorChar + DYNAMIC_ANALYZER);
            }
            File file = new File(command.toString());
            if (OSChecker.isMAC()) {
                if (!file.isDirectory()) {
                    DALog.dlgErrorMessage(Labels.MESSAGE_ERROR, Labels.MESSAGE_DYNAMIC_ANALYZER_IS_NOT_INSTALLED);
                } else {
                    String macCommand = "open " + command.toString() + " --args isAutoStart&";
                    DALog.printLog(macCommand);
                    HostUtil.execute((String)macCommand);
                }
            } else if (!file.isFile()) {
                DALog.dlgErrorMessage(Labels.MESSAGE_ERROR, Labels.MESSAGE_DYNAMIC_ANALYZER_IS_NOT_INSTALLED);
            } else if (OSChecker.isWindows()) {
                if (!this.executeWindowsCommand(command.toString())) {
                    return;
                }
            } else {
                command.append(" isAutoStart&");
                HostUtil.execute((String)command.toString());
            }
            DAServerManager.getInstance().reserveTraceApplication(device, projectType, binaryOfTarget, executablePath, localPackagePathList, interactiveInfoSet, debugBinaryPath);
        } else {
            DAServerManager.getInstance().runTraceApplication(device, projectType, binaryOfTarget, executablePath, localPackagePathList, interactiveInfoSet, debugBinaryPath);
        }
    }
}

