/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalysis.ide.web.eplugin.communication;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.tizen.common.util.OSChecker;
import org.tizen.dynamicanalysis.ide.web.eplugin.DALog;

public class OpenEditManager
implements Runnable {
    private ITextEditor _editor;
    private IDocument _document;
    private String filepath;
    private int fileline;

    public OpenEditManager(String path, int line) {
        this.filepath = path;
        this.fileline = line;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initEditor(String path) throws IOException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IFile ifile = root.getFile((IPath)new Path(path));
        IEditorPart part = null;
        if (!ifile.exists()) {
            File targetfile = new File(path);
            if (!targetfile.exists() || !targetfile.isFile()) throw new IOException("Source file (" + path + ") is not found.");
            IFileStore filestore = EFS.getLocalFileSystem().getStore(targetfile.toURI());
            part = this.openEditor(filestore);
        } else {
            part = this.openEditor(ifile);
        }
        if (part == null || !(part instanceof ITextEditor)) return;
        this._editor = (ITextEditor)part;
        IDocumentProvider provider = this._editor.getDocumentProvider();
        this._document = provider.getDocument((Object)this._editor.getEditorInput());
    }

    private IEditorPart openEditor(IFile ifile) {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        try {
            IDE.openEditor((IWorkbenchPage)page, (IFile)ifile);
        }
        catch (PartInitException partInitException) {
            DALog.printLog("OpenEditManager - openEditor - PartInitException");
        }
        return page.getActiveEditor();
    }

    private IEditorPart openEditor(IFileStore ifilestr) {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        try {
            IDE.openEditorOnFileStore((IWorkbenchPage)page, (IFileStore)ifilestr);
        }
        catch (PartInitException partInitException) {
            DALog.printLog("OpenEditManager - openEditor - PartInitException");
        }
        return page.getActiveEditor();
    }

    private ITextEditor getEditor() {
        return this._editor;
    }

    @Override
    public void run() {
        try {
            this.initEditor(this.filepath);
            int offset = this.fileline > 0 ? this._document.getLineOffset(this.fileline - 1) : 0;
            this.getEditor().setHighlightRange(offset, 0, true);
            if (OSChecker.isWindows()) {
                this.forceActiveOnWindows();
            } else {
                DALog.printLog("OS should be Windows. It's Error case. IDE is not focus on.");
            }
        }
        catch (IOException iOException) {
            DALog.printLog("OpenEditManager - run - IOException");
        }
        catch (BadLocationException badLocationException) {
            DALog.printLog("OpenEditManager - run - BadLocationException");
        }
    }

    public void forceActiveOnWindows() {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        if (OS.GetForegroundWindow() <= 0) {
            DALog.printLog("Failed Active on IDE.");
            return;
        }
        int pid = OS.GetWindowThreadProcessId((int)OS.GetForegroundWindow(), null);
        int threadid = OS.GetWindowThreadProcessId((int)shell.handle, null);
        if (threadid == pid) {
            OS.SetForegroundWindow((int)shell.handle);
            DALog.printLog("Success Active on IDE.");
            return;
        }
        if (pid > 0) {
            if (!OS.AttachThreadInput((int)threadid, (int)pid, (boolean)true)) {
                DALog.printLog("Failed Active on IDE.");
                return;
            }
            OS.SetForegroundWindow((int)shell.handle);
            OS.AttachThreadInput((int)threadid, (int)pid, (boolean)false);
        }
        OS.BringWindowToTop((int)shell.handle);
        OS.UpdateWindow((int)shell.handle);
        OS.SetActiveWindow((int)shell.handle);
        if (OS.IsIconic((int)shell.handle)) {
            OS.ShowWindow((int)shell.handle, (int)OS.SW_RESTORE);
        }
        DALog.printLog("Success Active on IDE.");
    }
}

