/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalysis.ide.web.eplugin;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.tizen.common.core.application.InstallPathConfig;

public class DALog {
    private static boolean LOG_TO_FILE = true;
    static File file = null;
    static FileOutputStream fos = null;
    static DataOutputStream dos = null;
    static boolean setInit = false;
    static final String IDE_LOG_NAME = "da_web_ide_log_";
    static final int IDE_LOG_SAVE_COUNT = 3;

    private static boolean init() {
        if (LOG_TO_FILE) {
            if (InstallPathConfig.getUserDataPath() == null) {
                LOG_TO_FILE = false;
                System.out.println("exception -NULL InstallPathConfig.getUserDataPath()");
                return false;
            }
            StringBuffer logPath = new StringBuffer();
            logPath.append(InstallPathConfig.getUserDataPath()).append(File.separatorChar).append("dynamic-analyzer").append(File.separatorChar).append("logs");
            File logsSaveFolderPath = new File(logPath.toString());
            if (!logsSaveFolderPath.exists() && !logsSaveFolderPath.mkdirs()) {
                return false;
            }
            if (DALog.manageIDELogFileCount(logsSaveFolderPath)) {
                SimpleDateFormat format = new SimpleDateFormat("yyyy_MM_dd_HH-mm-ss", Locale.KOREA);
                Date date = new Date();
                String logFileName = IDE_LOG_NAME + format.format(date);
                logPath.append(File.separatorChar).append(logFileName);
                file = new File(logPath.toString());
                file.getParentFile().mkdirs();
                try {
                    fos = new FileOutputStream(file);
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                dos = new DataOutputStream(fos);
            } else {
                LOG_TO_FILE = false;
            }
        }
        return true;
    }

    private static boolean manageIDELogFileCount(File logsSaveFolderPath) {
        File[] logFiles = logsSaveFolderPath.listFiles();
        if (logFiles == null) {
            System.out.println("exception - manageIDELogFileCount");
            LOG_TO_FILE = false;
            return false;
        }
        List<File> listLogFile = DALog.sortIDELogFile(logFiles);
        int logSize = listLogFile.size();
        int i = 2;
        while (i < logSize) {
            listLogFile.get(i).delete();
            ++i;
        }
        return true;
    }

    private static List<File> sortIDELogFile(File[] logFiles) {
        ArrayList<File> ideLogFile = new ArrayList<File>();
        File[] fileArray = logFiles;
        int n = logFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.getName().contains(IDE_LOG_NAME)) {
                ideLogFile.add(file);
            }
            ++n2;
        }
        Collections.sort(ideLogFile, new Comparator<File>(){

            @Override
            public int compare(File object1, File object2) {
                return object2.getName().compareTo(object1.getName());
            }
        });
        return ideLogFile;
    }

    public static void printLog(String logMsg) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
        if (LOG_TO_FILE) {
            if (!setInit) {
                setInit = true;
                if (!DALog.init()) {
                    return;
                }
            }
            try {
                dos.writeBytes(String.valueOf(dateFormat.format(new Date())) + ": " + logMsg);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                dos.writeChars("\n");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                dos.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            System.out.println(String.valueOf(dateFormat.format(new Date())) + ": " + logMsg);
        }
    }

    public static void printLog(Exception errMsg) {
        if (LOG_TO_FILE) {
            if (!setInit) {
                setInit = true;
                DALog.init();
            }
            try {
                dos.writeBytes(DALog.printStackTraceToString(errMsg));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                dos.writeChars("\n");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                dos.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            errMsg.printStackTrace();
        }
    }

    private static String printStackTraceToString(Throwable e) {
        StringBuilder sb = new StringBuilder();
        String returnString = null;
        sb.append(e.toString());
        sb.append("\n");
        StackTraceElement[] element = e.getStackTrace();
        int idx = 0;
        while (idx < element.length) {
            sb.append("\tat ");
            sb.append(element[idx].toString());
            sb.append("\n");
            ++idx;
        }
        returnString = sb.toString();
        return returnString;
    }

    public static void dlgErrorMessage(final String title, final String message) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                MessageDialog.openError((Shell)window.getShell(), (String)title, (String)message);
            }
        });
    }
}

