/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.cli;

import java.io.File;
import org.tizen.dynamicanalyzer.cli.commands.AppsCommand;
import org.tizen.dynamicanalyzer.cli.commands.Command;
import org.tizen.dynamicanalyzer.cli.commands.DevicesCommand;
import org.tizen.dynamicanalyzer.cli.commands.ExitCode;
import org.tizen.dynamicanalyzer.cli.commands.StartCommand;
import org.tizen.dynamicanalyzer.cli.commands.StopCommand;

public final class CliFrontend {
    private static Command[] commandList = new Command[]{new DevicesCommand(), new AppsCommand(), new StartCommand(), new StopCommand()};

    private static void printHelp() {
        String exec = new File(CliFrontend.class.getProtectionDomain().getCodeSource().getLocation().getPath()).getName();
        System.out.printf("Usage: %s <command> [options ...]%nList of commands:%n", exec);
        for (Command command : commandList) {
            command.printHelp();
        }
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            CliFrontend.printHelp();
            return;
        }
        for (Command command : commandList) {
            if (!args[0].equals(command.getName())) continue;
            String[] commandArgs = new String[args.length - 1];
            System.arraycopy(args, 1, commandArgs, 0, args.length - 1);
            if (!command.checkArgs(commandArgs)) {
                CliFrontend.printHelp();
                System.exit(ExitCode.EX_ARGUMENTS_ERROR.getCode());
            }
            System.exit(command.processCommand(commandArgs).getCode());
        }
        CliFrontend.printHelp();
    }
}

