/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.cli.manager;

import java.io.Serializable;
import java.util.Date;
import org.tizen.dynamicanalyzer.cli.tracing.TracingArguments;

public class TracingProcessContext
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -5458874901547893614L;
    private TracingArguments args;
    private boolean finished;
    private int errCode;
    private Date startTime;
    private Date finishTime;

    public TracingArguments getArgs() {
        return this.args;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public int getErrCode() {
        return this.errCode;
    }

    public Date getStartTime() {
        return (Date)this.startTime.clone();
    }

    public Date getFinishTime() {
        return (Date)this.finishTime.clone();
    }

    public TracingProcessContext(TracingArguments args) {
        this.args = args;
        this.finished = false;
        this.startTime = new Date();
    }

    public void finishContext(int errCode) {
        if (this.finished) {
            return;
        }
        this.errCode = errCode;
        this.finished = true;
        this.finishTime = new Date();
    }

    public TracingProcessContext clone() {
        TracingProcessContext copy = null;
        try {
            copy = (TracingProcessContext)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
        copy.args = this.args.clone();
        copy.startTime = (Date)this.startTime.clone();
        if (this.finishTime != null) {
            copy.finishTime = (Date)this.finishTime.clone();
        }
        return copy;
    }
}

