/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.cli.manager;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStreamWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import org.tizen.dynamicanalyzer.cli.manager.TracingProcessContext;
import org.tizen.dynamicanalyzer.cli.tracing.TracingArguments;
import org.tizen.dynamicanalyzer.cli.tracing.TracingArgumentsParser;
import org.tizen.dynamicanalyzer.cli.tracing.TracingProcess;
import org.tizen.dynamicanalyzer.cli.utils.Message;
import org.tizen.dynamicanalyzer.common.path.PathManager;
import org.tizen.dynamicanalyzer.project.Project;
import org.tizen.dynamicanalyzer.util.Logger;

public class TracingProcessManager {
    private static final String TRACING_PROCESS_CANONICAL_NAME = TracingProcess.class.getCanonicalName();
    private static final String TRACING_PROCESS_LIBRARY_PATH = TracingProcessManager.getTracingProcessLibraryPath();
    static BufferedWriter bw;
    private TracingProcessContext ctx;
    private Process tracingProcess;
    private volatile Thread monitoringThread;
    private volatile long tracingTime;
    private ServerConnection serverConnection;
    private Thread commThread;

    private static String getTracingProcessLibraryPath() {
        try {
            return new File(TracingProcess.class.getProtectionDomain().getCodeSource().getLocation().getPath()).getAbsolutePath();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static TracingProcessManager createTracingProcess(TracingArguments args, int port) throws IOException {
        String currentClasspath = System.getProperty("java.class.path");
        ArrayList<String> commandLine = new ArrayList<String>(Arrays.asList("java", "-classpath", TRACING_PROCESS_LIBRARY_PATH + ":" + currentClasspath, TRACING_PROCESS_CANONICAL_NAME));
        if (args.getOutput() == null) {
            File output = new File(PathManager.DA_SAVE_PATH + File.separator + Project.constructSaveName((String)args.getApplication(), (Date)new Date()));
            args.setOutput(output);
        }
        commandLine.addAll(Arrays.asList(TracingArgumentsParser.toStringArray(args)));
        ProcessBuilder pBuilder = new ProcessBuilder(commandLine).redirectInput(ProcessBuilder.Redirect.PIPE).redirectOutput(ProcessBuilder.Redirect.INHERIT).redirectError(ProcessBuilder.Redirect.INHERIT);
        Process process = pBuilder.start();
        bw = new BufferedWriter(new OutputStreamWriter(process.getOutputStream(), StandardCharsets.UTF_8));
        try {
            bw.write(Integer.toString(port));
            bw.newLine();
            bw.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new TracingProcessManager(args, process, port);
    }

    private void startMonitoring() {
        this.monitoringThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    TracingProcessManager.this.waitForCompletion();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }, "wait-completion-thread-" + this.ctx.getArgs().getDevice());
        this.monitoringThread.setDaemon(true);
        this.monitoringThread.start();
    }

    private TracingProcessManager(TracingArguments args, Process process, int port) {
        this.ctx = new TracingProcessContext(args);
        this.tracingProcess = process;
        try {
            ServerSocket ss = new ServerSocket(port);
            Socket socket = ss.accept();
            this.serverConnection = new ServerConnection(socket);
            this.commThread = new Thread((Runnable)this.serverConnection, "Communication thread");
            this.commThread.start();
            ss.close();
        }
        catch (IOException e1) {
            Logger.error((Object)"Failed to establish communication between TracingProcessManager and TracingProcess");
        }
        this.startMonitoring();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForCompletion() throws InterruptedException {
        int errCode = this.tracingProcess.waitFor();
        TracingProcessManager tracingProcessManager = this;
        synchronized (tracingProcessManager) {
            this.ctx.finishContext(errCode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopTracing() throws InterruptedException, IOException {
        TracingProcessManager tracingProcessManager = this;
        synchronized (tracingProcessManager) {
            if (this.ctx.isFinished()) {
                return;
            }
            this.serverConnection.sendMessage(Message.MessageType.STOP_TRACING, new String[0]);
        }
        this.waitForCompletion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stopTracing(long timeoutMs) throws InterruptedException {
        TracingProcessManager tracingProcessManager = this;
        synchronized (tracingProcessManager) {
            if (this.ctx.isFinished()) {
                return true;
            }
        }
        Thread workingThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    TracingProcessManager.this.stopTracing();
                }
                catch (IOException | InterruptedException exception) {
                    // empty catch block
                }
            }
        }, "stop-tracing-thread-" + this.ctx.getArgs().getDevice());
        workingThread.start();
        workingThread.join(timeoutMs);
        if (workingThread.isAlive()) {
            workingThread.interrupt();
        }
        TracingProcessManager tracingProcessManager2 = this;
        synchronized (tracingProcessManager2) {
            return this.ctx.isFinished();
        }
    }

    public long getTracingTime() {
        if (this.tracingTime > 0L) {
            return this.tracingTime;
        }
        try {
            this.serverConnection.sendMessage(Message.MessageType.REQUEST_TRACING_TIME, new String[0]);
            while (this.commThread.isAlive()) {
                this.serverConnection.wait();
            }
        }
        catch (IOException | InterruptedException e) {
            Logger.error((Object)"Communication failed");
        }
        return this.tracingTime;
    }

    public synchronized void forceStopTracing() {
        if (this.ctx.isFinished()) {
            return;
        }
        this.tracingProcess.destroy();
        try {
            this.waitForCompletion();
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)"Something goes wrong while destroying tracing process.");
        }
    }

    public synchronized TracingProcessContext getContext() {
        return this.ctx.clone();
    }

    public synchronized boolean isFinished() {
        return this.ctx.isFinished();
    }

    private class ServerConnection
    implements Runnable {
        ObjectOutputStream oos;
        ObjectInputStream ois;

        private ServerConnection(Socket socket) throws IOException {
            this.oos = new ObjectOutputStream(socket.getOutputStream());
            this.ois = new ObjectInputStream(socket.getInputStream());
        }

        public void sendMessage(Message message) throws IOException {
            this.oos.writeObject(message);
            this.oos.flush();
        }

        public void sendMessage(Message.MessageType messageT, String ... args) throws IOException {
            this.sendMessage(new Message(messageT, args));
        }

        @Override
        public void run() {
            try {
                boolean childAlive = true;
                while (childAlive) {
                    Object rawObj = this.ois.readObject();
                    if (!(rawObj instanceof Message)) continue;
                    Message message = (Message)rawObj;
                    switch (message.messageT) {
                        case STOP_DONE: {
                            childAlive = false;
                            bw.close();
                            break;
                        }
                        case INFO_TRACING_TIME: {
                            TracingProcessManager.this.tracingTime = Long.parseLong(message.args[0]);
                            break;
                        }
                        case ERROR_OCCURED: {
                            TracingProcessManager.this.ctx.finishContext(Integer.parseInt(message.args[0]));
                            break;
                        }
                        default: {
                            Logger.warning((Object)"wrong request type for TracingProcessManager");
                        }
                    }
                    this.notifyAll();
                }
            }
            catch (ClassNotFoundException e) {
                Logger.error((Object)"Error while communicating with TracingProcess. Message type can't be resolved.");
                this.notifyAll();
            }
            catch (IOException e) {
                Logger.info((Object)"Communication stopped, stream closed");
                this.notifyAll();
            }
        }
    }
}

