/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.cli.tracing;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.commons.cli.ParseException;
import org.tizen.dynamicanalyzer.cli.CliInternals;
import org.tizen.dynamicanalyzer.cli.commands.ExitCode;
import org.tizen.dynamicanalyzer.cli.tracing.SystemExit;
import org.tizen.dynamicanalyzer.cli.tracing.TracingArguments;
import org.tizen.dynamicanalyzer.cli.tracing.TracingArgumentsParser;
import org.tizen.dynamicanalyzer.cli.utils.Message;
import org.tizen.dynamicanalyzer.common.DAResult;
import org.tizen.dynamicanalyzer.common.DAState;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.util.Logger;

public class TracingProcess {
    private volatile DAResult.ErrorCode status = DAResult.ErrorCode.ERR_UNKNOWN;
    private final TracingArguments args;
    private ClientConnection socketConnection;
    private long startTime;
    private volatile long tracingTime;

    public TracingProcess(TracingArguments args) {
        this.args = args;
    }

    public synchronized DAResult.ErrorCode startTrace() {
        DAResult.ErrorCode result = CliInternals.startTracing(this.args);
        if (result != DAResult.ErrorCode.SUCCESS) {
            this.socketConnection.sendMessage(Message.MessageType.ERROR_OCCURED, Integer.toString(result.getErrorNumber()));
            return result;
        }
        try {
            DAState.waitPrepared();
        }
        catch (InterruptedException e) {
            Logger.error((Object)e);
            return DAResult.ErrorCode.ERR_EXCEPTION_OCCURRED;
        }
        if (!DAState.isRunning() && result == DAResult.ErrorCode.SUCCESS) {
            result = DAResult.ErrorCode.ERR_EXCEPTION_OCCURRED;
        }
        this.startTime = System.nanoTime() / 1000L;
        return result;
    }

    public synchronized void stopTrace() {
        this.tracingTime = System.nanoTime() / 1000L - this.startTime;
        Global.getProject().setTotalStopTime(this.tracingTime);
        this.socketConnection.sendMessage(Message.MessageType.INFO_TRACING_TIME, Long.toString(this.tracingTime));
        CliInternals.stopTracing();
    }

    public boolean saveTrace() {
        return CliInternals.saveTrace(this.args.getOutput().getName());
    }

    public void waitForCompletion() throws InterruptedException {
        DAState.waitDone();
    }

    public synchronized DAResult.ErrorCode getStatus() {
        return this.status;
    }

    private static DAResult.ErrorCode performAllTasks(String[] args, int port) {
        Logger.init((int)1);
        TracingArguments argsParsed = null;
        try {
            argsParsed = TracingArgumentsParser.parse(args);
        }
        catch (ParseException e) {
            Logger.error((String)"Error while parsing arguments: %s.", (Object[])new Object[]{e.toString()});
            Logger.error((String)"Start tracing arguments was: %s.", (Object[])new Object[]{Arrays.toString(args)});
            return DAResult.ErrorCode.ERR_WRONG_MESSAGE_FORMAT;
        }
        TracingProcess tracingProcess = new TracingProcess(argsParsed);
        try {
            Socket socket = new Socket(InetAddress.getLocalHost(), port);
            tracingProcess.socketConnection = tracingProcess.getConnProc(socket);
            Thread commThread = new Thread(tracingProcess.socketConnection);
            commThread.start();
        }
        catch (IOException ioe) {
            Logger.error((Object)"IOException in socket connection.");
        }
        Logger.info((String)"Going to start tracing on device '%s'.", (Object[])new Object[]{argsParsed.getDevice()});
        DAResult.ErrorCode result = tracingProcess.startTrace();
        if (result != DAResult.ErrorCode.SUCCESS) {
            Logger.error((String)"Error while start tracing: %s.", (Object[])new Object[]{result.toString()});
            return result;
        }
        try {
            tracingProcess.waitForCompletion();
        }
        catch (InterruptedException e) {
            Logger.error((Object)"Main tracing thread was interrupted.");
            return DAResult.ErrorCode.ERR_EXCEPTION_OCCURRED;
        }
        if (!tracingProcess.saveTrace()) {
            Logger.error((Object)"Failed to save tracing results");
            return DAResult.ErrorCode.ERR_EXCEPTION_OCCURRED;
        }
        return tracingProcess.getStatus();
    }

    private ClientConnection getConnProc(Socket socket) {
        try {
            return new ClientConnection(socket);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static int getPort() {
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in, StandardCharsets.UTF_8));
        try {
            return Integer.parseInt(br.readLine());
        }
        catch (IOException | NumberFormatException e) {
            System.exit(ExitCode.EX_CONNECTION_ERROR.getCode());
            return 9000;
        }
    }

    public static void main(String[] args) {
        DAResult.ErrorCode exitCode = TracingProcess.performAllTasks(args, TracingProcess.getPort());
        SystemExit.exit(exitCode.getErrorNumber());
    }

    private class ClientConnection
    implements Runnable {
        ObjectOutputStream oos;
        ObjectInputStream ois;

        private ClientConnection(Socket socket) throws IOException {
            this.ois = new ObjectInputStream(socket.getInputStream());
            this.oos = new ObjectOutputStream(socket.getOutputStream());
            this.oos.flush();
        }

        public void sendMessage(Message message) {
            try {
                this.oos.writeObject(message);
                this.oos.flush();
            }
            catch (IOException e) {
                Logger.error((Object)"Got Exception while sending message to TracingProcessManager");
            }
        }

        public void sendMessage(Message.MessageType messageT, String ... args) {
            this.sendMessage(new Message(messageT, args));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                block9: while (true) {
                    Object rawObj;
                    if (!((rawObj = this.ois.readObject()) instanceof Message)) {
                        continue;
                    }
                    Message message = (Message)rawObj;
                    switch (message.messageT) {
                        case STOP_TRACING: {
                            Logger.info((Object)"Stopinng TracingProcess");
                            ClientConnection clientConnection = this;
                            synchronized (clientConnection) {
                                if (TracingProcess.this.tracingTime == 0L) {
                                    TracingProcess.this.stopTrace();
                                }
                            }
                            this.sendMessage(Message.MessageType.STOP_DONE, new String[0]);
                            continue block9;
                        }
                        case REQUEST_TRACING_TIME: {
                            this.sendMessage(Message.MessageType.INFO_TRACING_TIME, Long.toString(TracingProcess.this.tracingTime));
                            continue block9;
                        }
                    }
                    Logger.warning((Object)("wrong request type " + message.messageT.toString() + " for TracingProcess"));
                }
            }
            catch (ClassNotFoundException e) {
                Logger.error((Object)"Error while communicating with TracingProcessManager. Message type can't be resolved.");
                return;
            }
            catch (IOException e) {
                Logger.info((Object)"Communication stopped, stream closed");
            }
        }
    }
}

