/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.sdblib.command;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.HashMap;
import org.tizen.sdblib.IDevice;
import org.tizen.sdblib.IShellOutputReceiver;
import org.tizen.sdblib.SdbHelper;
import org.tizen.sdblib.SdbResponse;
import org.tizen.sdblib.SmartDevelopmentBridge;
import org.tizen.sdblib.command.Argument;
import org.tizen.sdblib.command.ICommand;
import org.tizen.sdblib.command.ICommandWithArgument;
import org.tizen.sdblib.command.ICommandWithArgument2;
import org.tizen.sdblib.command.Matcher;
import org.tizen.sdblib.exception.SdbCommandRejectedException;
import org.tizen.sdblib.exception.ShellCommandUnresponsiveException;
import org.tizen.sdblib.util.Assert;
import org.tizen.sdblib.util.IOUtil;
import org.tizen.sdblib.util.Log;

public class Command
implements ICommand,
ICommandWithArgument,
ICommandWithArgument2 {
    protected final SmartDevelopmentBridge sdb;
    protected final String cmd;
    protected final String protocol;
    public static final String PROTOCOL_SHELL = "shell:";
    public static final String PROTOCOL_APPCMD = "appcmd:";
    protected final HashMap<Argument, Object> arguments = new HashMap();

    public Command(SmartDevelopmentBridge sdb, String cmd) {
        Assert.notNull(sdb);
        Assert.notNull(cmd);
        this.sdb = sdb;
        this.cmd = cmd;
        this.protocol = PROTOCOL_SHELL;
    }

    public Command(SmartDevelopmentBridge sdb, String cmd, String protocol) {
        Assert.notNull(sdb);
        Assert.notNull(cmd);
        Assert.notNull(protocol);
        this.sdb = sdb;
        this.cmd = cmd;
        this.protocol = protocol;
    }

    @Override
    public void in(IDevice device, IShellOutputReceiver receiver) throws IOException {
        this.in(device, receiver, "UTF-8");
    }

    @Override
    public void in(IDevice device, IShellOutputReceiver receiver, String characterSet) throws IOException {
        Assert.notNull(receiver);
        SocketChannel channel = this.sdb.openChannel();
        try {
            channel.configureBlocking(false);
            this.sendRequest(device, channel);
            byte[] data = new byte[16384];
            ByteBuffer buf = ByteBuffer.wrap(data);
            int timeToResponseCount = 0;
            ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
            while (true) {
                if (receiver != null && receiver.isCancelled()) {
                    Log.v("sdb", "execute: cancelled");
                    break;
                }
                int count = channel.read(buf);
                if (count < 0) {
                    if (receiver != null) {
                        receiver.flush();
                    }
                    Log.v("sdb", "execute '" + this.cmd + "' on '" + device + "' : EOF hit. Read: " + count);
                    break;
                }
                if (count == 0) {
                    try {
                        int wait = 250;
                        int maxTimeToRespond = this.getMaxTimeToRespond();
                        if (maxTimeToRespond > 0 && (timeToResponseCount += wait) > maxTimeToRespond) {
                            throw new ShellCommandUnresponsiveException();
                        }
                        Thread.sleep(wait);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                timeToResponseCount = 0;
                if (receiver != null) {
                    byteOut.write(buf.array(), buf.arrayOffset(), buf.position());
                    try {
                        receiver.append(SdbHelper.bytes2string(byteOut.toByteArray(), characterSet));
                    }
                    catch (Exception exception) {
                        receiver.append(new String(byteOut.toByteArray()));
                    }
                    byteOut.reset();
                }
                buf.rewind();
            }
        }
        finally {
            IOUtil.tryClose(channel);
            IOUtil.tryClose(receiver);
            Log.v("sdb", "execute: returning");
        }
    }

    @Override
    public void in(IDevice device) throws IOException {
        Log.v("sdb", "execute: running " + this.cmd);
        SocketChannel channel = this.sdb.openChannel();
        try {
            this.sendRequest(device, channel);
        }
        finally {
            IOUtil.tryClose(channel);
            Log.v("sdb", "execute: returning");
        }
    }

    protected void sendRequest(IDevice device, SocketChannel channel) throws IOException {
        SdbHelper.initializeDevice(channel, device.getSerialNumber());
        byte[] request = SdbHelper.formSdbRequest(String.valueOf(this.protocol) + this.cmd);
        SdbHelper.write(channel, request);
        SdbResponse resp = SdbHelper.readSdbResponse(channel);
        if (!resp.okay) {
            Log.e("sdb", "sdb rejected shell command (" + this.cmd + "): " + resp.message);
            throw new SdbCommandRejectedException(resp.message);
        }
    }

    @Override
    public ICommandWithArgument2 and(Argument key, Object value) {
        return this.with(key, value);
    }

    @Override
    public ICommandWithArgument2 with(Argument key, Object value) {
        Assert.notNull((Object)key);
        Assert.isFalse(this.arguments.containsKey((Object)key));
        this.arguments.put(key, value);
        return this;
    }

    protected int getMaxTimeToRespond() {
        Object obj = this.arguments.get((Object)Argument.MaxTimeToRespond);
        if (!(obj instanceof Integer)) {
            return -1;
        }
        return (Integer)obj;
    }

    @Override
    public <T> T in(IDevice device, Matcher<T> matcher) {
        try {
            this.in(device, (IShellOutputReceiver)matcher);
        }
        catch (IOException e) {
            Log.e("command", "execute " + this.cmd + " failed:" + e);
        }
        return matcher.getResult();
    }
}

