/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.handlers;

import java.io.File;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.swt.widgets.Display;
import org.tizen.dynamicanalyzer.common.AnalyzerManager;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.database.SqlConnectionManager;
import org.tizen.dynamicanalyzer.database.compatible.DBConverter;
import org.tizen.dynamicanalyzer.handlers.CommonAction;
import org.tizen.dynamicanalyzer.handlers.UIActionHolder;
import org.tizen.dynamicanalyzer.nl.AnalyzerLabels;
import org.tizen.dynamicanalyzer.project.BinaryInfo;
import org.tizen.dynamicanalyzer.project.Project;
import org.tizen.dynamicanalyzer.setting.UILayoutDataManager;
import org.tizen.dynamicanalyzer.swap.logparser.DataManagerRegistry;
import org.tizen.dynamicanalyzer.ui.range.RangeDataManager;
import org.tizen.dynamicanalyzer.ui.range.RangePage;
import org.tizen.dynamicanalyzer.ui.summary.profiling.FunctionUsageProfiler;
import org.tizen.dynamicanalyzer.ui.summary.profiling.ProfileDataMaker;
import org.tizen.dynamicanalyzer.ui.summary.profiling.ProfilingChildData;
import org.tizen.dynamicanalyzer.ui.summary.profiling.ProfilingChildDataDBTable;
import org.tizen.dynamicanalyzer.ui.summary.profiling.ProfilingData;
import org.tizen.dynamicanalyzer.ui.summary.profiling.ProfilingDataDBTable;
import org.tizen.dynamicanalyzer.ui.summary.profiling.WebProfileDataMaker;
import org.tizen.dynamicanalyzer.ui.summary.profiling.WebProfilingData;
import org.tizen.dynamicanalyzer.ui.summary.profiling.WebProfilingDataDBTable;
import org.tizen.dynamicanalyzer.ui.timeline.TimelinePage;
import org.tizen.dynamicanalyzer.ui.toolbar.Toolbar;
import org.tizen.dynamicanalyzer.ui.toolbar.opentrace.OpenTraceProgressManager;
import org.tizen.dynamicanalyzer.ui.userinterface.UIDataManager;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.utils.AnalyzerUtil;
import org.tizen.dynamicanalyzer.widgets.da.view.DAPageComposite;

public class OpenTraceHandler
extends AbstractHandler {
    public static final String ID = OpenTraceHandler.class.getName();
    Project project = null;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        DAPageComposite page;
        this.project = Global.getProject();
        OpenTraceProgressManager.getInstance().openTracePrgressStart(AnalyzerLabels.OPEN_TRACE_PROGRESS_LOADING);
        SqlConnectionManager.closeConnection();
        SqlConnectionManager.establishConnection(String.valueOf(this.project.getSavePath()) + File.separator + "da.trace");
        DBConverter converter = new DBConverter(this.project.getVersion());
        if (!converter.convert()) {
            OpenTraceProgressManager.getInstance().closeOpenTraceDialog(AnalyzerLabels.OPEN_TRACE_PROGRESS_LOADING_FAILED);
            UIActionHolder.getUIAction().showWarning(AnalyzerLabels.OPEN_TRACE_PROGRESS_INVALID);
            CommonAction.clear();
            return null;
        }
        this.project.upgrade();
        boolean bsuccess = this.project.openDetail();
        if (!bsuccess) {
            OpenTraceProgressManager.getInstance().closeOpenTraceDialog(AnalyzerLabels.OPEN_TRACE_PROGRESS_LOADING_FAILED);
            UIActionHolder.getUIAction().showWarning(AnalyzerLabels.OPEN_TRACE_PROGRESS_VERSION_INVALID_REMOVE);
            CommonAction.clear();
            return null;
        }
        int percent = OpenTraceProgressManager.getInstance().getPercent();
        if (!(this.loadProfilingData() && this.loadProfilingChildData() && this.loadWebProfilingData())) {
            OpenTraceProgressManager.getInstance().closeOpenTraceDialog(AnalyzerLabels.OPEN_TRACE_PROGRESS_LOADING_FAILED);
            UIActionHolder.getUIAction().showWarning(AnalyzerLabels.OPEN_TRACE_PROGRESS_INVALID_REMOVE);
            CommonAction.clear();
            return null;
        }
        OpenTraceProgressManager.getInstance().setProgressPercent(AnalyzerLabels.OPEN_TRACE_PROGRESS_LOADING, percent += 60);
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                Toolbar.INSTANCE.setTime(OpenTraceHandler.this.project.getTotalStopTime());
                Toolbar.INSTANCE.setAllControlState(true);
            }
        });
        OpenTraceProgressManager.getInstance().setProgressPercent(AnalyzerLabels.OPEN_TRACE_PROGRESS_LOADING, percent += 3);
        UIActionHolder.getUIAction().setUIElements(this.project);
        if (RangeDataManager.getInstance().isBeingAnalyzed() && (page = AnalyzerManager.getCurrentPage()) instanceof RangePage) {
            AnalyzerUtil.changePage(TimelinePage.pageID);
        }
        UILayoutDataManager.INSTANCE.setDirty(true);
        DataManagerRegistry.openData();
        OpenTraceProgressManager.getInstance().openTraceComplete();
        return null;
    }

    private boolean loadProfilingData() {
        boolean isSuccess = true;
        List<List<Object>> profilingDatas = FunctionUsageProfiler.getInstance().getProfilingDataTable().getProfilingDataFromDB();
        if (profilingDatas == null) {
            Logger.debug((Object)"failed - loadProfilingData");
            isSuccess = false;
        } else {
            int i = 0;
            while (i < profilingDatas.size()) {
                List<Object> profilingData = profilingDatas.get(i);
                int pid = (Integer)profilingData.get(ProfilingDataDBTable.COLUMN.PID.index);
                ProfileDataMaker profiler = FunctionUsageProfiler.getInstance().getProfileDataMakerByPid(pid);
                int profilingDataID = (Integer)profilingData.get(ProfilingDataDBTable.COLUMN.PROFILING_DATA_ID.index);
                byte type = (Byte)profilingData.get(ProfilingDataDBTable.COLUMN.TYPE.index);
                int exCount = (Integer)profilingData.get(ProfilingDataDBTable.COLUMN.EXCLUSIVE_COUNT.index);
                int inCount = (Integer)profilingData.get(ProfilingDataDBTable.COLUMN.INCLUSIVE_COUNT.index);
                int callCount = (Integer)profilingData.get(ProfilingDataDBTable.COLUMN.CALL_COUNT.index);
                long inElapsedTime = (Long)profilingData.get(ProfilingDataDBTable.COLUMN.INCLUSIVE_EXECUTION_TIME.index);
                long exElapsedTime = (Long)profilingData.get(ProfilingDataDBTable.COLUMN.EXCLUSIVE_EXECUTION_TIME.index);
                ProfilingData fupData = null;
                BinaryInfo bInfo = null;
                switch (type) {
                    case 0: 
                    case 1: 
                    case 3: {
                        int binaryId = (Integer)profilingData.get(ProfilingDataDBTable.COLUMN.BINARY_ID.index);
                        bInfo = this.project.getDeviceStatusInfo().getBinaryInfo(binaryId);
                        String name = bInfo.getTargetBinaryPath();
                        fupData = new ProfilingData(profilingDataID, name, exCount, inCount, callCount, inElapsedTime, exElapsedTime, profiler);
                        break;
                    }
                    case 2: {
                        int functionId = (Integer)profilingData.get(ProfilingDataDBTable.COLUMN.FUNCTION_ID.index);
                        String name = this.project.getFunctionName(functionId);
                        fupData = new ProfilingData(profilingDataID, name, exCount, inCount, callCount, inElapsedTime, exElapsedTime, profiler);
                        break;
                    }
                    default: {
                        Logger.error((Object)"invalid profiling data type");
                    }
                }
                if (fupData == null) {
                    isSuccess = false;
                } else {
                    if (type == 0) {
                        profiler.setAppBin(fupData);
                    } else if (type == 1) {
                        profiler.setDependentLib(fupData);
                    }
                    profiler.getProfilingDataMap().put(profilingDataID, fupData);
                    UIDataManager.getInstance().getfunctionProfilingDataChecker().addProfilingData(fupData);
                    profiler.setTotalSampleCount(profiler.getTotalSampleCount() + fupData.getExCount());
                }
                ++i;
            }
        }
        return isSuccess;
    }

    private boolean loadProfilingChildData() {
        boolean isSuccess = true;
        List<List<Object>> profilingChilds = FunctionUsageProfiler.getInstance().getProfilingChildDataTable().getProfilingChildDataFromDB();
        if (profilingChilds == null) {
            Logger.debug((Object)"failed - loadProfilingChildData");
            isSuccess = false;
        } else {
            int size = profilingChilds.size();
            int i = 0;
            while (i < size) {
                List<Object> data = profilingChilds.get(i);
                int parentID = (Integer)data.get(ProfilingChildDataDBTable.COLUMN.PROFILING_DATA_ID.index);
                int pid = (Integer)data.get(ProfilingChildDataDBTable.COLUMN.PID.index);
                List childSeqList = (List)data.get(ProfilingChildDataDBTable.COLUMN.CHILD_SEQUENCE_ARRAY.index);
                ProfileDataMaker profiler = FunctionUsageProfiler.getInstance().getProfileDataMakerByPid(pid);
                ProfilingData parent = profiler.getProfilingDataMap().get(parentID);
                ProfilingChildData child = parent.getChildData();
                child.getChildren().addAll(childSeqList);
                ++i;
            }
        }
        return isSuccess;
    }

    private boolean loadWebProfilingData() {
        boolean isSuccess = true;
        List<List<Object>> profilingDatas = FunctionUsageProfiler.getInstance().getWebProfilingDataTable().getWebProfilingDataFromDB();
        if (profilingDatas == null) {
            Logger.debug((Object)"failed - loadWebProfilingData");
            isSuccess = false;
        } else {
            int i = 0;
            while (i < profilingDatas.size()) {
                List<Object> profilingData = profilingDatas.get(i);
                int profilingDataID = (Integer)profilingData.get(WebProfilingDataDBTable.COLUMN.PROFILING_DATA_ID.getIndex());
                int pid = (Integer)profilingData.get(WebProfilingDataDBTable.COLUMN.PID.getIndex());
                int functionLineNumber = (Integer)profilingData.get(WebProfilingDataDBTable.COLUMN.FUNCTION_LINE_NUMBER.getIndex());
                String functionName = (String)profilingData.get(WebProfilingDataDBTable.COLUMN.FUNCTION_NAME.getIndex());
                String functionURL = (String)profilingData.get(WebProfilingDataDBTable.COLUMN.FUNCTION_URL.getIndex());
                int callCount = (Integer)profilingData.get(WebProfilingDataDBTable.COLUMN.CALL_COUNT.getIndex());
                long inElapsedTime = (Long)profilingData.get(WebProfilingDataDBTable.COLUMN.INCLUSIVE_EXECUTION_TIME.getIndex());
                long exElapsedTime = (Long)profilingData.get(WebProfilingDataDBTable.COLUMN.EXCLUSIVE_EXECUTION_TIME.getIndex());
                List childSeqList = (List)profilingData.get(WebProfilingDataDBTable.COLUMN.CHILD_SEQUENCE_ARRAY.getIndex());
                WebProfilingData fupData = new WebProfilingData(profilingDataID, functionLineNumber, functionName, functionURL, callCount, inElapsedTime, exElapsedTime, childSeqList);
                WebProfileDataMaker profiler = FunctionUsageProfiler.getInstance().getWebProfileDataMakerByPid(pid);
                if (functionName.equals(FunctionUsageProfiler.APPLICATION)) {
                    profiler.setAppBin(fupData);
                }
                profiler.webProfilingDataMap().put(profilingDataID, fupData);
                ++i;
            }
        }
        return isSuccess;
    }
}

