/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.project.callstack;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.common.SymbolManager;
import org.tizen.dynamicanalyzer.nl.InformationViewLabels;
import org.tizen.dynamicanalyzer.project.BinaryInfo;
import org.tizen.dynamicanalyzer.project.LibraryObject;
import org.tizen.dynamicanalyzer.project.ProcessInformation;
import org.tizen.dynamicanalyzer.project.ProcessMemoryMap;
import org.tizen.dynamicanalyzer.project.Project;
import org.tizen.dynamicanalyzer.swap.model.data.LogData;
import org.tizen.dynamicanalyzer.swap.platform.BinarySettingData;
import org.tizen.dynamicanalyzer.swap.platform.BinarySettingManager;
import org.tizen.dynamicanalyzer.ui.info.callstack.CallStackData;
import org.tizen.dynamicanalyzer.ui.info.callstack.CallStackItem;
import org.tizen.dynamicanalyzer.ui.info.callstack.CallStackUnit;
import org.tizen.dynamicanalyzer.ui.summary.profiling.ProfileDataMaker;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.utils.AnalyzerUtil;

public abstract class BaseCallstackManager {
    protected Map<Integer, Map<Long, CallStackUnit>> callstackApiAddrByPidMap = new ConcurrentHashMap<Integer, Map<Long, CallStackUnit>>();
    protected NavigableMap<Long, CallStackData> callstackDataBySeqMap = new ConcurrentSkipListMap<Long, CallStackData>();
    protected Map<Integer, List<CallStackItem>> userCallstackByTidMap = new HashMap<Integer, List<CallStackItem>>();

    public abstract void makeUserCallstack(LogData var1, ProfileDataMaker var2);

    public abstract long getSeqOfUserCallstackForTime(int var1, long var2);

    public Map<Long, CallStackUnit> getCallStackApiAddrByPidMap(int pid) {
        Map<Long, CallStackUnit> callstackApiByAddrMap = this.callstackApiAddrByPidMap.get(pid);
        if (callstackApiByAddrMap == null) {
            callstackApiByAddrMap = new ConcurrentHashMap<Long, CallStackUnit>();
            this.callstackApiAddrByPidMap.put(pid, callstackApiByAddrMap);
        }
        return callstackApiByAddrMap;
    }

    public NavigableMap<Long, CallStackData> getCallStackDataBySeqMap() {
        return this.callstackDataBySeqMap;
    }

    public List<CallStackItem> getUserCallstack(int tid) {
        List<CallStackItem> userCallstack = this.userCallstackByTidMap.get(tid);
        if (userCallstack == null) {
            userCallstack = new ArrayList<CallStackItem>();
            this.userCallstackByTidMap.put(tid, userCallstack);
        }
        return userCallstack;
    }

    public void clear() {
        this.callstackApiAddrByPidMap.clear();
        this.callstackDataBySeqMap.clear();
        this.userCallstackByTidMap.clear();
    }

    private String getUserFunctionPosition(int pid, long time) {
        Project project = Global.getProject();
        ProcessInformation process = project.getProcessInformation(pid);
        ProcessMemoryMap pmap = process.getProcessMemoryMap(time);
        if (pmap != null) {
            int binaryID = pmap.getMainbinary().getBinaryID();
            return project.getDeviceStatusInfo().getBinaryInfo(binaryID).getTargetBinaryPath();
        }
        return "";
    }

    public String getCallStackSymbol(long addr, int pid, long time) {
        String functionName = null;
        String symbol = null;
        Project project = Global.getProject();
        ProcessInformation process = project.getProcessInformation(pid);
        ProcessMemoryMap pmap = process.getProcessMemoryMap(time);
        if (pmap != null) {
            if (addr >= pmap.getMainbinary().getLowestAddress() && addr <= pmap.getMainbinary().getHighestAddress()) {
                String baseAddr = Long.toString(pmap.getMainbinary().getLowestAddress());
                String pcStr = Long.toString(addr);
                LibraryObject libobj = pmap.getLibraryByAddress(addr);
                if (libobj != null) {
                    BinaryInfo binInfo = project.getDeviceStatusInfo().getBinaryInfo(libobj.getBinaryID());
                    String localPath = binInfo.getTempBinaryPath();
                    boolean isPieBuild = true;
                    if (binInfo.getType() != 1) {
                        isPieBuild = false;
                    }
                    functionName = SymbolManager.addr2func(localPath, pcStr, isPieBuild, baseAddr);
                }
                if (functionName == null || functionName.isEmpty() || functionName.equals("_end")) {
                    functionName = InformationViewLabels.CALLSTACK_TABLE_UNKNOWN_FUNCTION;
                } else {
                    String prevFunctionName = functionName;
                    functionName = SymbolManager.demanglingFunctionName(prevFunctionName);
                }
                symbol = String.valueOf(this.getUserFunctionPosition(pid, time)) + "(" + functionName;
            } else {
                List<BinarySettingData> binDataList = BinarySettingManager.getInstance().getBinarySettingList();
                LibraryObject libraryObject = pmap.getLibraryByAddress(addr);
                if (libraryObject != null) {
                    int binaryID = libraryObject.getBinaryID();
                    BinaryInfo binfo = Global.getProject().getDeviceStatusInfo().getBinaryInfo(binaryID);
                    String path = binfo.getTargetBinaryPath();
                    boolean isInBinarySetting = false;
                    for (BinarySettingData binData : binDataList) {
                        if (!path.equals(binData.getBinaryPath())) continue;
                        isInBinarySetting = true;
                        break;
                    }
                    if (isInBinarySetting) {
                        String localPath = binfo.getTempBinaryPath();
                        String baseAddr = Long.toString(libraryObject.getLowestAddress());
                        String pcStr = Long.toString(addr);
                        boolean isPieBuild = true;
                        if (binfo.getType() != 1) {
                            isPieBuild = false;
                        }
                        if ((functionName = SymbolManager.addr2func(localPath, pcStr, isPieBuild, baseAddr)) == null || functionName.isEmpty() || functionName.equals("_end")) {
                            functionName = InformationViewLabels.CALLSTACK_TABLE_UNKNOWN_FUNCTION;
                        } else {
                            String prevFunctionName = functionName;
                            functionName = SymbolManager.demanglingFunctionName(prevFunctionName);
                        }
                    } else {
                        functionName = InformationViewLabels.CALLSTACK_TABLE_UNKNOWN_FUNCTION;
                    }
                    symbol = String.valueOf(path) + "(" + functionName;
                }
            }
        }
        if (symbol == null) {
            Logger.debug((Object)("binary for the sample pc is not found :" + AnalyzerUtil.toHexdecimal(addr)));
            symbol = String.valueOf(InformationViewLabels.CALLSTACK_TABLE_UNKNOWN_LIBRARY) + "(" + AnalyzerUtil.toHexdecimal(addr);
        }
        return symbol;
    }

    protected boolean isAddrInBinaryRange(int pid, long time, long addr) {
        ProcessMemoryMap pmap = Global.getProject().getProcessInformation(pid).getProcessMemoryMap(time);
        if (pmap == null) {
            return false;
        }
        if (addr >= pmap.getMainbinary().getLowestAddress() && addr <= pmap.getMainbinary().getHighestAddress()) {
            return true;
        }
        List<BinarySettingData> binDataList = BinarySettingManager.getInstance().getBinarySettingList();
        ArrayList<String> binPaths = new ArrayList<String>();
        for (BinarySettingData binData : binDataList) {
            binPaths.add(binData.getBinaryPath());
        }
        int size = binPaths.size();
        int i = 0;
        while (i < size) {
            String binPath = (String)binPaths.get(i);
            BinaryInfo bininfo = Global.getProject().getDeviceStatusInfo().getBinaryInfo(binPath);
            LibraryObject libObj = pmap.getLibraryByBinaryID(bininfo.getID());
            if (libObj != null && addr >= libObj.getLowestAddress() && addr <= libObj.getHighestAddress()) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

