/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.swap.model.data;

import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.model.DATime;
import org.tizen.dynamicanalyzer.swap.model.data.LogData;

public class ProbeCommonData
extends LogData {
    protected int apiID = 0;
    protected int pid = 0;
    protected int tid = 0;
    protected String args = null;
    protected String ret = null;
    protected long errno = 0L;
    protected int internalCall = 0;
    protected long callerAddress = 0L;
    protected int reserved1 = 0;
    protected int reserved2 = 0;
    protected String libName = null;
    private String apiName = null;

    public ProbeCommonData() {
    }

    public ProbeCommonData(long seq, long time, int apiId, int pid, int tid, String args, String ret, int errno) {
        this.seq = seq;
        this.time = time;
        this.apiID = apiId;
        this.pid = pid;
        this.tid = tid;
        this.args = args;
        this.ret = ret;
        this.errno = errno;
    }

    @Override
    public ProbeCommonData clone() throws CloneNotSupportedException {
        ProbeCommonData log = (ProbeCommonData)super.clone();
        log.apiID = this.apiID;
        log.pid = this.pid;
        log.tid = this.tid;
        log.args = this.args;
        log.ret = this.ret;
        log.errno = this.errno;
        log.internalCall = this.internalCall;
        log.callerAddress = this.callerAddress;
        log.reserved1 = this.reserved1;
        log.reserved2 = this.reserved2;
        log.libName = this.libName;
        log.apiName = this.apiName;
        return log;
    }

    @Override
    protected boolean parse(DATime startTime) {
        super.parse(startTime);
        this.apiID = this.getInt();
        this.pid = this.getInt();
        this.tid = this.getInt();
        this.args = this.parseArgs();
        if (this.args.length() > 1024) {
            this.args = this.args.substring(0, 1024);
        }
        this.ret = this.parseReturn();
        if (this.ret.length() > 1024) {
            this.ret = this.ret.substring(0, 1024);
        }
        this.errno = this.getLong();
        this.internalCall = this.getInt();
        this.callerAddress = this.getLong();
        this.reserved1 = this.getInt();
        this.reserved2 = this.getInt();
        int binID = Global.getBinaryID(this.pid, this.time, this.callerAddress);
        this.libName = Global.getLibraryName(binID);
        return true;
    }

    public int getApiId() {
        return this.apiID;
    }

    public void setApiId(int apiId) {
        this.apiID = apiId;
    }

    @Override
    public int getPid() {
        return this.pid;
    }

    public void setPid(int pid) {
        this.pid = pid;
    }

    public int getTid() {
        return this.tid;
    }

    public void setTid(int tid) {
        this.tid = tid;
    }

    public String getArgs() {
        return this.args;
    }

    public void setArgs(String args) {
        this.args = args;
    }

    public String getReturn() {
        return this.ret;
    }

    public void setReturn(String ret) {
        this.ret = ret;
    }

    public long getErrno() {
        return this.errno;
    }

    public void setErrNo(long errno) {
        this.errno = errno;
    }

    public int getInternalCall() {
        return this.internalCall;
    }

    public void setInternalCall(int internalCall) {
        this.internalCall = internalCall;
    }

    public long getCallerPcAddr() {
        return this.callerAddress;
    }

    public void setCallerAddress(long callerAddress) {
        this.callerAddress = callerAddress;
    }

    public int getReserved1() {
        return this.reserved1;
    }

    public void setReserved1(int reserved1) {
        this.reserved1 = reserved1;
    }

    public int getReserved2() {
        return this.reserved2;
    }

    public void setReserved2(int reserved2) {
        this.reserved2 = reserved2;
    }

    public String getApiName() {
        if (this.apiName == null) {
            this.apiName = Global.getFunctionName(this.apiID);
        }
        return this.apiName;
    }

    public void setApiName(String apiName) {
        this.apiName = apiName;
    }

    public String getLibName() {
        return this.libName;
    }

    public void setLibName(String libName) {
        this.libName = libName;
    }

    public boolean isInternal() {
        boolean ret = false;
        int flag = this.getInternalCall();
        ret = flag == 1;
        return ret;
    }
}

