/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.swap.platform.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.widgets.Display;
import org.tizen.dynamicanalyzer.common.DAResult;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.communicator.DACommunicator;
import org.tizen.dynamicanalyzer.communicator.UnsupportedProtocolException;
import org.tizen.dynamicanalyzer.handlers.UIActionHolder;
import org.tizen.dynamicanalyzer.project.BinaryInfo;
import org.tizen.dynamicanalyzer.project.DeviceStatusInfo;
import org.tizen.dynamicanalyzer.swap.platform.BinarySettingData;
import org.tizen.dynamicanalyzer.swap.platform.BinarySettingManager;
import org.tizen.dynamicanalyzer.swap.platform.ui.BinarySettingProgressManager;
import org.tizen.dynamicanalyzer.ui.toolbar.setting.SettingDialogBinarySettingsPage;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.sdblib.service.FileEntry;

public class BinarySettingProcessor
implements Runnable {
    private static final int TYPE_ADD = 1;
    private static final int TYPE_LOAD = 2;
    private static final int TYPE_UPDATE = 3;
    private static Thread binaryThread = null;
    private static Object result = null;
    private static SettingDialogBinarySettingsPage page = null;
    private static int type = 1;

    public static void runAddThread(Object input, SettingDialogBinarySettingsPage inputPage) {
        page = inputPage;
        result = input;
        type = 1;
        binaryThread = new Thread(null, new BinarySettingProcessor(), "Binary add thread");
        binaryThread.start();
    }

    public static void runLoadingThread(SettingDialogBinarySettingsPage inputPage) {
        page = inputPage;
        type = 2;
        binaryThread = new Thread(null, new BinarySettingProcessor(), "Binary loading thread");
        binaryThread.start();
    }

    public static void runUpdateDebugRoot(SettingDialogBinarySettingsPage inputPage) {
        page = inputPage;
        type = 3;
        binaryThread = new Thread(null, new BinarySettingProcessor(), "update debug root thread");
        binaryThread.start();
    }

    public static void stopThread() {
        if (binaryThread != null && binaryThread.isAlive()) {
            binaryThread.interrupt();
        }
    }

    public static void clear() {
        BinarySettingProcessor.stopThread();
        result = null;
    }

    @Override
    public void run() {
        if (type == 1) {
            List entries = (List)result;
            ArrayList<String> binPaths = new ArrayList<String>();
            for (FileEntry entry : entries) {
                if (entry.isDirectory() || entry.isRoot()) continue;
                binPaths.add(entry.getFullPath());
            }
            BinarySettingProgressManager.getInstance().setValue(5);
            DAResult result = new DAResult(DAResult.ErrorCode.ERR_BIN_INFO_GET_FAIL);
            if (binPaths.size() > 0) {
                try {
                    result = DACommunicator.getBinaryInformation(binPaths);
                }
                catch (InterruptedException interruptedException) {
                    Logger.warning((Object)"Interrupted during get binary info");
                }
                catch (UnsupportedProtocolException unsupportedProtocolException) {
                    Logger.warning((Object)"Getting binary info is not supported by communicator");
                }
                if (!result.isSuccess()) {
                    UIActionHolder.getUIAction().showWarning(result);
                }
            }
            BinarySettingProgressManager.getInstance().setValue(50);
            ArrayList<String> addBinPaths = new ArrayList<String>();
            ArrayList<BinarySettingData> addBinData = new ArrayList<BinarySettingData>();
            if (result.isSuccess()) {
                DeviceStatusInfo sinfo = Global.getCurrentDeviceInfo().getDeviceStatusInfo();
                for (String path : binPaths) {
                    BinaryInfo bininfo = sinfo.getBinaryInfo(path);
                    if (bininfo == null || bininfo.getTempBinaryPath() == null) continue;
                    BinarySettingData binaryData = new BinarySettingData();
                    binaryData.setBinaryPath(path);
                    binaryData.setDebugRpmPath(BinarySettingManager.getInstance().getDebugRpmPath(path, page.getDebugRootPath()));
                    addBinPaths.add(path);
                    addBinData.add(binaryData);
                }
            }
            BinarySettingProgressManager.getInstance().setValue(60);
            if (addBinData.size() > 0) {
                BinarySettingManager.getInstance().addBinarySettingData(addBinData);
                BinarySettingProgressManager.getInstance().setValue(70);
                BinarySettingManager.getInstance().checkSourcePath(addBinData);
                BinarySettingProgressManager.getInstance().setValue(80);
                try {
                    DACommunicator.addInstrumentation(addBinPaths);
                }
                catch (InterruptedException interruptedException) {
                    Logger.warning((Object)"Interrupted during send add instrumetation message");
                }
                catch (UnsupportedProtocolException unsupportedProtocolException) {
                    Logger.warning((Object)"Message to add instrumentation is not supported by communicator");
                }
                BinarySettingProgressManager.getInstance().setValue(90);
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        page.initInputRows();
                    }
                });
            }
            BinarySettingProgressManager.getInstance().setValue(100);
        } else if (type == 2) {
            BinarySettingProgressManager.getInstance().setValue(30);
            List<BinarySettingData> binarySettings = BinarySettingManager.getInstance().getBinarySettingList();
            BinarySettingProgressManager.getInstance().setValue(50);
            ArrayList<String> paths = new ArrayList<String>();
            for (BinarySettingData data : binarySettings) {
                paths.add(data.getBinaryPath());
            }
            if (paths.size() > 0) {
                DAResult result = new DAResult(DAResult.ErrorCode.ERR_BIN_INFO_GET_FAIL);
                try {
                    result = DACommunicator.getBinaryInformation(paths);
                }
                catch (InterruptedException interruptedException) {
                    Logger.warning((Object)"Interrupted during get binary info");
                }
                catch (UnsupportedProtocolException unsupportedProtocolException) {
                    Logger.warning((Object)"Getting binary info is not supported by communicator");
                }
                if (!result.isSuccess()) {
                    UIActionHolder.getUIAction().showWarning(result);
                }
            }
            DeviceStatusInfo sinfo = Global.getCurrentDeviceInfo().getDeviceStatusInfo();
            for (String path : paths) {
                BinaryInfo bininfo = sinfo.getBinaryInfo(path);
                if (bininfo != null && bininfo.getTempBinaryPath() != null) continue;
                BinarySettingManager.getInstance().removeBinarySettingData(path);
            }
            BinarySettingProgressManager.getInstance().setValue(80);
            paths.clear();
            List<BinarySettingData> binDatas = BinarySettingManager.getInstance().getBinarySettingList();
            for (BinarySettingData data : binDatas) {
                paths.add(data.getBinaryPath());
            }
            try {
                DACommunicator.addInstrumentation(paths);
            }
            catch (InterruptedException interruptedException) {
                Logger.warning((Object)"Interrupted during send add instrumentation message");
            }
            catch (UnsupportedProtocolException unsupportedProtocolException) {
                Logger.warning((Object)"Message to add instrumentation is not supported by communicator");
            }
            BinarySettingProgressManager.getInstance().setValue(95);
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    page.updateLayout();
                }
            });
        } else {
            BinarySettingProgressManager.getInstance().setValue(30);
            List<BinarySettingData> binarySettings = BinarySettingManager.getInstance().getBinarySettingList();
            BinarySettingProgressManager.getInstance().setValue(40);
            int count = 41;
            for (BinarySettingData binData : binarySettings) {
                if (count < 90) {
                    BinarySettingProgressManager.getInstance().setValue(count++);
                }
                if (binData.getDebugRpmPath() != null && !binData.getDebugRpmPath().isEmpty()) continue;
                String debugPath = BinarySettingManager.getInstance().getDebugRpmPath(binData.getBinaryPath(), page.getDebugRootPath());
                binData.setDebugRpmPath(debugPath);
            }
            BinarySettingProgressManager.getInstance().setValue(50);
            BinarySettingManager.getInstance().checkSourcePath(binarySettings);
            BinarySettingProgressManager.getInstance().setValue(70);
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    page.initInputRows();
                }
            });
            BinarySettingProgressManager.getInstance().setValue(95);
        }
        BinarySettingProgressManager.getInstance().stopProgress();
    }
}

