/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.swap.platform.ui;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.tizen.dynamicanalyzer.communicator.DACommunicator;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.resources.FontResources;
import org.tizen.dynamicanalyzer.resources.ImageResources;
import org.tizen.dynamicanalyzer.swap.platform.BinarySettingData;
import org.tizen.dynamicanalyzer.swap.platform.BinarySettingManager;
import org.tizen.dynamicanalyzer.ui.common.explorer.FileExplorerDialog;
import org.tizen.dynamicanalyzer.util.CommonUtil;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButton;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButtonClickEventListener;
import org.tizen.dynamicanalyzer.widgets.da.base.DATextBox;

public class InputRow
extends Composite {
    private Label binaryNameLabel = null;
    private DATextBox debugPathText = null;
    private DATextBox sourcePathText = null;
    private DACustomButton findDebugButton = null;
    private DACustomButton findSourceButton = null;
    private DACustomButton removeButton = null;
    private int index = -1;
    private String binaryName = null;
    private DACustomButtonClickEventListener findDebugButtonListener = new DACustomButtonClickEventListener(){

        public void handleClickEvent(DACustomButton button) {
            FileExplorerDialog dialog = new FileExplorerDialog(InputRow.this.getShell());
            dialog.setFilter("debug");
            dialog.getExplorer().setRoot(CommonUtil.getHomeDirectory());
            Object result = dialog.open();
            ArrayList<BinarySettingData> bins = new ArrayList<BinarySettingData>();
            if (result != null) {
                List files = (List)result;
                if (!files.isEmpty()) {
                    File file = (File)files.get(0);
                    InputRow.this.debugPathText.setText(file.getAbsolutePath());
                    BinarySettingData binData = BinarySettingManager.getInstance().getBinarySetting(InputRow.this.binaryName);
                    if (binData != null) {
                        binData.setDebugRpmPath(file.getAbsolutePath());
                        bins.add(binData);
                    }
                }
                BinarySettingManager.getInstance().checkSourcePath(bins);
            }
        }
    };
    private DACustomButtonClickEventListener findSourceButtonListener = new DACustomButtonClickEventListener(){

        public void handleClickEvent(DACustomButton button) {
            List files;
            FileExplorerDialog dialog = new FileExplorerDialog(InputRow.this.getShell());
            dialog.getExplorer().setRoot(CommonUtil.getHomeDirectory());
            Object result = dialog.open();
            if (result != null && !(files = (List)result).isEmpty()) {
                File file = (File)files.get(0);
                if (!file.isDirectory()) {
                    file = file.getParentFile();
                }
                if (file != null) {
                    InputRow.this.sourcePathText.setText(file.getAbsolutePath());
                    BinarySettingData binData = BinarySettingManager.getInstance().getBinarySetting(InputRow.this.binaryName);
                    if (binData != null) {
                        binData.setUserSourceDir(file.getAbsolutePath());
                    }
                }
            }
        }
    };

    public InputRow(Composite parent, DACustomButtonClickEventListener removeListener) {
        super(parent, 2048);
        this.setBackground(ColorResources.BINARY_SETTINGS_INPUT_BOX_COLOR);
        Rectangle pRect = parent.getBounds();
        Control lastChlid = null;
        Control[] children = parent.getChildren();
        if (children.length - 1 > 0) {
            lastChlid = children[children.length - 2];
        }
        FormData data = new FormData();
        data.top = lastChlid != null ? new FormAttachment(lastChlid, 1) : new FormAttachment(0, 1);
        data.height = 80;
        data.left = new FormAttachment(0, 1);
        data.width = pRect.width - 5;
        this.setLayoutData(data);
        this.setLayout((Layout)new FormLayout());
        this.binaryNameLabel = new Label((Composite)this, 0x40000000);
        this.binaryNameLabel.setBackground(ColorResources.BINARY_SETTINGS_INPUT_BOX_COLOR);
        this.binaryNameLabel.setFont(FontResources.getDADefaultFont());
        Label debugLabel = new Label((Composite)this, 0x40000000);
        debugLabel.setBackground(ColorResources.BINARY_SETTINGS_INPUT_BOX_COLOR);
        debugLabel.setFont(FontResources.getDADefaultFont());
        debugLabel.setForeground(ColorResources.BINARY_SETTINGS_LABEL_COLOR);
        debugLabel.setText("Debug package");
        Label sourceLabel = new Label((Composite)this, 0x40000000);
        sourceLabel.setBackground(ColorResources.BINARY_SETTINGS_INPUT_BOX_COLOR);
        sourceLabel.setForeground(ColorResources.BINARY_SETTINGS_LABEL_COLOR);
        sourceLabel.setFont(FontResources.getDADefaultFont());
        sourceLabel.setText("Source Directory path");
        this.debugPathText = new DATextBox((Composite)this, 4);
        this.findDebugButton = new DACustomButton((Composite)this, ImageResources.FIND_BUTTON_NORMAL, ImageResources.FIND_BUTTON_PUSH, ImageResources.FIND_BUTTON_HOVER, ImageResources.FIND_BUTTON_DISABLE);
        this.findDebugButton.addClickListener(this.findDebugButtonListener);
        this.findSourceButton = new DACustomButton((Composite)this, ImageResources.FIND_BUTTON_NORMAL, ImageResources.FIND_BUTTON_PUSH, ImageResources.FIND_BUTTON_HOVER, ImageResources.FIND_BUTTON_DISABLE);
        this.findSourceButton.addClickListener(this.findSourceButtonListener);
        this.removeButton = new DACustomButton((Composite)this, ImageResources.DELETE_BUTTON_NORMAL, ImageResources.DELETE_BUTTON_PUSH, ImageResources.DELETE_BUTTON_HOVER, ImageResources.DELETE_BUTTON_DISABLE);
        this.removeButton.addClickListener(removeListener);
        this.sourcePathText = new DATextBox((Composite)this, 4);
        this.sourcePathText.setBackground(ColorResources.WHITE);
        data = new FormData();
        data.top = new FormAttachment(0, 10);
        data.left = new FormAttachment(0, 10);
        data.right = new FormAttachment(100, -50);
        data.height = 20;
        this.binaryNameLabel.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0, 7);
        data.right = new FormAttachment(100, -6);
        data.width = 27;
        data.height = 19;
        this.removeButton.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.binaryNameLabel, 0);
        data.left = new FormAttachment(0, 10);
        data.height = 20;
        data.width = 232;
        debugLabel.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.binaryNameLabel, 0);
        data.left = new FormAttachment((Control)debugLabel, 38);
        data.right = new FormAttachment(90, -10);
        data.height = 20;
        data.width = 232;
        sourceLabel.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)debugLabel, 0);
        data.left = new FormAttachment(0, 5);
        data.width = 232;
        data.height = 15;
        this.debugPathText.setLayoutData(data);
        data = new FormData();
        data.top = new FormAttachment((Control)debugLabel, 0);
        data.left = new FormAttachment((Control)this.debugPathText.getControl(), 1);
        data.width = 19;
        data.height = 19;
        this.findDebugButton.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)debugLabel, 0);
        data.left = new FormAttachment((Control)this.findDebugButton, 13);
        data.width = 232;
        data.height = 15;
        this.sourcePathText.setLayoutData(data);
        data = new FormData();
        data.top = new FormAttachment((Control)debugLabel, 0);
        data.left = new FormAttachment((Control)this.sourcePathText.getControl(), 1);
        data.width = 19;
        data.height = 19;
        this.findSourceButton.setLayoutData((Object)data);
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int i) {
        this.index = i;
    }

    public void setBinaryName(String binaryName) {
        this.binaryName = binaryName;
        String binaryDetailInfo = DACommunicator.getBinaryDetailInformation(binaryName);
        if (binaryDetailInfo != null && !binaryDetailInfo.isEmpty()) {
            this.binaryNameLabel.setText(String.valueOf(binaryName) + " " + "(" + binaryDetailInfo + ")");
        } else {
            this.binaryNameLabel.setText(binaryName);
        }
    }

    public String getBinaryName() {
        return this.binaryName;
    }

    public void setDebugText(String text) {
        if (text == null) {
            this.debugPathText.setText("");
        } else {
            this.debugPathText.setText(text);
        }
    }

    public String getDebugText() {
        return this.debugPathText.getText();
    }

    public void setSourceText(String text) {
        if (text == null) {
            this.sourcePathText.setText("");
        } else {
            this.sourcePathText.setText(text);
        }
    }

    public String getSourceText() {
        return this.sourcePathText.getText();
    }

    public String getSaveData() {
        StringBuffer strBuffer = new StringBuffer();
        strBuffer.append(this.binaryName).append(",");
        if (this.debugPathText.getText() == null || this.debugPathText.getText().isEmpty()) {
            strBuffer.append(" ").append(",");
        } else {
            strBuffer.append(this.debugPathText.getText()).append(",");
        }
        if (this.sourcePathText.getText() == null || this.sourcePathText.getText().isEmpty()) {
            strBuffer.append(" ");
        } else {
            strBuffer.append(this.sourcePathText.getText());
        }
        return strBuffer.toString();
    }
}

