/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.common.explorer;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.nebula.widgets.grid.Grid;
import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.tizen.dynamicanalyzer.nl.WidgetLabels;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.ui.common.explorer.DAFileExplorer;
import org.tizen.dynamicanalyzer.ui.common.explorer.ExplorerUtil;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButton;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButtonClickEventListener;
import org.tizen.dynamicanalyzer.widgets.da.base.DAButton;
import org.tizen.dynamicanalyzer.widgets.da.base.DAMessageBox;

public class FileExplorerDialog
extends DAMessageBox {
    private DAFileExplorer explorer = null;
    private DACustomButton okButton = null;
    private DACustomButton cancelButton = null;

    public FileExplorerDialog(Shell parentShell) {
        super(parentShell);
        this.shell.setLayout((Layout)new FormLayout());
        this.shell.setSize(446, 600);
        this.shell.setBackground(ColorResources.DIALOG_BG_UPPER);
        this.shell.setText("Select binary");
        this.explorer = new DAFileExplorer((Composite)this.shell);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 17);
        data.left = new FormAttachment(0, 6);
        data.height = 476;
        data.width = 434;
        this.explorer.setLayoutData(data);
        Composite buttonComp = new Composite((Composite)this.shell, 0);
        buttonComp.setLayout((Layout)new FormLayout());
        buttonComp.setBackground(ColorResources.DIALOG_BG_LOWER);
        buttonComp.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                Composite comp = (Composite)e.widget;
                Rectangle rect = comp.getClientArea();
                e.gc.setForeground(ColorResources.DIALOG_SUNKEN_1);
                e.gc.drawLine(rect.x, rect.y, rect.x + rect.width, rect.y);
                e.gc.setForeground(ColorResources.DIALOG_SUNKEN_2);
                e.gc.drawLine(rect.x, rect.y + 1, rect.x + rect.width, rect.y + 1);
            }
        });
        FormData compData = new FormData();
        compData.top = new FormAttachment((Control)this.explorer, 20);
        compData.left = new FormAttachment(0, 0);
        compData.right = new FormAttachment(100, 0);
        compData.bottom = new FormAttachment(100, 0);
        buttonComp.setLayoutData((Object)compData);
        this.okButton = new DAButton(buttonComp, 0);
        data = new FormData();
        data.top = new FormAttachment(0, 11);
        data.left = new FormAttachment(50, -90);
        data.height = 24;
        data.width = 86;
        this.okButton.setLayoutData((Object)data);
        this.okButton.setText(WidgetLabels.OK);
        this.okButton.addClickListener(new DACustomButtonClickEventListener(){

            public void handleClickEvent(DACustomButton button) {
                FileExplorerDialog.this.result = FileExplorerDialog.this.explorer.getSelection();
                if (FileExplorerDialog.this.result != null) {
                    FileExplorerDialog.this.shell.dispose();
                }
            }
        });
        this.cancelButton = new DAButton(buttonComp, 0);
        data = new FormData();
        data.top = new FormAttachment(0, 11);
        data.left = new FormAttachment(50, 4);
        data.height = 24;
        data.width = 86;
        this.cancelButton.setLayoutData((Object)data);
        this.cancelButton.setText(WidgetLabels.CANCEL);
        this.cancelButton.addClickListener(new DACustomButtonClickEventListener(){

            public void handleClickEvent(DACustomButton button) {
                FileExplorerDialog.this.result = false;
                FileExplorerDialog.this.shell.dispose();
            }
        });
        this.explorer.getTable().addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
                Grid table = (Grid)e.widget;
                GridItem[] items = table.getSelection();
                if (items == null || items.length == 0) {
                    return;
                }
                GridItem item = items[0];
                File entry = (File)item.getData(ExplorerUtil.DATA_FIEL_KEY);
                if (!entry.isDirectory()) {
                    ArrayList<File> entries = new ArrayList<File>();
                    entries.add(entry);
                    FileExplorerDialog.this.result = entries;
                    FileExplorerDialog.this.shell.dispose();
                }
            }
        });
    }

    protected boolean run() {
        super.run();
        this.explorer.updateData();
        return true;
    }

    public DAFileExplorer getExplorer() {
        return this.explorer;
    }

    public void setFilter(String filter) {
        this.explorer.setFilterString(filter);
    }

    public void setTitle(String title) {
        this.shell.setText(title);
    }
}

