/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.kernel.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import org.tizen.dynamicanalyzer.database.DBInserter;
import org.tizen.dynamicanalyzer.database.DBTable;
import org.tizen.dynamicanalyzer.database.SqlConnectionManager;
import org.tizen.dynamicanalyzer.swap.logparser.LogPackage;
import org.tizen.dynamicanalyzer.swap.logparser.Logs;
import org.tizen.dynamicanalyzer.swap.logparser.PageDataManager;
import org.tizen.dynamicanalyzer.swap.model.data.LogData;
import org.tizen.dynamicanalyzer.swap.model.data.LogDataTimeComparator;
import org.tizen.dynamicanalyzer.ui.kernel.data.ContextDataDBTable;
import org.tizen.dynamicanalyzer.ui.kernel.data.FunctionDataDBTable;
import org.tizen.dynamicanalyzer.ui.kernel.data.KernelDataMaker;
import org.tizen.dynamicanalyzer.ui.kernel.data.KernelDataPerThread;

public class KernelDataManager
extends PageDataManager {
    private static final String PIDTID_QUERY_CONTEXT = "select distinct " + ContextDataDBTable.COLUMN.PID.name + ", " + ContextDataDBTable.COLUMN.TID.name + " from %s";
    private static final String PIDTID_QUERY_FUNCTION = "select distinct " + FunctionDataDBTable.COLUMN.PID.name + ", " + FunctionDataDBTable.COLUMN.TID.name + " from %s";
    private static final String COUNT_QUERY_CONTEXT = "select count(*) from %s where " + ContextDataDBTable.COLUMN.TID.name + "=%s";
    private static final String COUNT_QUERY_FUNCTION = "select count(*) from %s where " + FunctionDataDBTable.COLUMN.TID.name + "=%s";
    private static KernelDataManager instance = new KernelDataManager();
    private KernelDataMaker kdataMaker = null;
    private ContextDataDBTable contextDataTable = new ContextDataDBTable();
    private FunctionDataDBTable functionDataTable = new FunctionDataDBTable();

    private KernelDataManager() {
        DBInserter cDBInserter = this.makeInserter(this.contextDataTable);
        DBInserter fDBInserter = this.makeInserter(this.functionDataTable);
        this.kdataMaker = new KernelDataMaker(cDBInserter, fDBInserter);
    }

    public DBTable getContextDataTable() {
        return this.contextDataTable;
    }

    public DBTable getFunctionDataTable() {
        return this.functionDataTable;
    }

    public KernelDataMaker getDataMaker() {
        return this.kdataMaker;
    }

    public static KernelDataManager getInstance() {
        return instance;
    }

    public void clear() {
        this.kdataMaker.clear();
    }

    private ArrayList<LogData> getLogsFromLogPackage(LogPackage logPack) {
        LogData top;
        Logs contextEntryLogs = logPack.getLogs(16);
        Logs contextExitLogs = logPack.getLogs(17);
        Logs functionEntryLogs = logPack.getLogs(8);
        Logs functionExitLogs = logPack.getLogs(9);
        ArrayList<LogData> kernelLogs = new ArrayList<LogData>();
        PriorityQueue<LogData> pqueue = new PriorityQueue<LogData>(5, new LogDataTimeComparator());
        List<LogData> contextEntryLogList = null;
        List<LogData> contextExitLogList = null;
        List<LogData> functionEntryLogList = null;
        List<LogData> functionExitLogList = null;
        Iterator<LogData> centryiter = null;
        Iterator<LogData> cexititer = null;
        Iterator<LogData> fentryiter = null;
        Iterator<LogData> fexititer = null;
        if (contextEntryLogs != null && (centryiter = (contextEntryLogList = contextEntryLogs.getLogs()).iterator()).hasNext()) {
            pqueue.offer(centryiter.next());
        }
        if (contextExitLogs != null && (cexititer = (contextExitLogList = contextExitLogs.getLogs()).iterator()).hasNext()) {
            pqueue.offer(cexititer.next());
        }
        if (functionEntryLogs != null && (fentryiter = (functionEntryLogList = functionEntryLogs.getLogs()).iterator()).hasNext()) {
            pqueue.offer(fentryiter.next());
        }
        if (functionExitLogs != null && (fexititer = (functionExitLogList = functionExitLogs.getLogs()).iterator()).hasNext()) {
            pqueue.offer(fexititer.next());
        }
        while ((top = pqueue.poll()) != null) {
            switch (top.getMsgID()) {
                case 16: {
                    if (centryiter == null || !centryiter.hasNext()) break;
                    pqueue.offer(centryiter.next());
                    break;
                }
                case 17: {
                    if (cexititer == null || !cexititer.hasNext()) break;
                    pqueue.offer(cexititer.next());
                    break;
                }
                case 8: {
                    if (fentryiter == null || !fentryiter.hasNext()) break;
                    pqueue.offer(fentryiter.next());
                    break;
                }
                case 9: {
                    if (fexititer == null || !fexititer.hasNext()) break;
                    pqueue.offer(fexititer.next());
                    break;
                }
            }
            kernelLogs.add(top);
        }
        return kernelLogs;
    }

    @Override
    protected void makeData(LogPackage pack) {
        ArrayList<LogData> logs = this.getLogsFromLogPackage(pack);
        if (!logs.isEmpty()) {
            this.kdataMaker.makeData(logs);
        }
    }

    @Override
    public void openData(Map<String, String> dataMap) {
        List<Object> row;
        int i;
        int threadsize;
        this.kdataMaker.clear();
        HashMap<Integer, KernelDataPerThread> threadMap = new HashMap<Integer, KernelDataPerThread>();
        String query = String.format(PIDTID_QUERY_CONTEXT, this.contextDataTable.getTableName());
        List<List<Object>> contextPidTid = SqlConnectionManager.executeQuery(query);
        query = String.format(PIDTID_QUERY_FUNCTION, this.functionDataTable.getTableName());
        List<List<Object>> functionPidTid = SqlConnectionManager.executeQuery(query);
        if (contextPidTid != null) {
            threadsize = contextPidTid.size();
            i = 0;
            while (i < threadsize) {
                row = contextPidTid.get(i);
                int pid = (Integer)row.get(0);
                int tid = (Integer)row.get(1);
                KernelDataPerThread kdata = new KernelDataPerThread(pid, tid);
                threadMap.put(tid, kdata);
                query = String.format(COUNT_QUERY_CONTEXT, this.contextDataTable.getTableName(), Integer.toString(tid));
                List<List<Object>> coreCount = SqlConnectionManager.executeQuery(query);
                Object count = coreCount == null ? Integer.valueOf(0) : coreCount.get(0).get(0);
                if (count instanceof Integer) {
                    kdata.setCoreFragmentCount((Integer)count);
                } else if (count instanceof Long) {
                    kdata.setCoreFragmentCount(((Long)count).intValue());
                }
                query = String.format(COUNT_QUERY_FUNCTION, this.functionDataTable.getTableName(), Integer.toString(tid));
                List<List<Object>> functionCount = SqlConnectionManager.executeQuery(query);
                count = functionCount == null ? Integer.valueOf(0) : functionCount.get(0).get(0);
                if (count instanceof Integer) {
                    kdata.setFunctionFragmentCount((Integer)count);
                } else if (count instanceof Long) {
                    kdata.setFunctionFragmentCount(((Long)count).intValue());
                }
                ++i;
            }
        }
        if (functionPidTid != null) {
            threadsize = functionPidTid.size();
            i = 0;
            while (i < threadsize) {
                row = functionPidTid.get(i);
                int tid = (Integer)row.get(1);
                KernelDataPerThread kdata = (KernelDataPerThread)threadMap.get(tid);
                if (kdata != null) {
                    kdata.createFunctionStack();
                }
                ++i;
            }
        }
        for (Map.Entry entry : threadMap.entrySet()) {
            KernelDataPerThread kdata = (KernelDataPerThread)entry.getValue();
            this.kdataMaker.addThreadData(kdata);
        }
    }
}

