/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.memory.chart;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.nl.TimelineChartLabels;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.resources.ImageResources;
import org.tizen.dynamicanalyzer.ui.memory.chart.MemoryChart;
import org.tizen.dynamicanalyzer.ui.memory.data.ProcessMemoryDBTable;
import org.tizen.dynamicanalyzer.utils.AnalyzerUtil;
import org.tizen.dynamicanalyzer.utils.Formatter;
import org.tizen.dynamicanalyzer.widgets.chart.DAChart;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartPlot;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartSeries;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartSeriesItem;
import org.tizen.dynamicanalyzer.widgets.chartBoard.DAChartBoard;
import org.tizen.dynamicanalyzer.widgets.chartBoard.DAChartBoardItem;

public class HeapMemoryChart
extends MemoryChart {
    private Map<Integer, Map<Integer, DAChartSeries>> seriesPerProcessMap = new HashMap<Integer, Map<Integer, DAChartSeries>>();
    private List<DAChartBoardItem> childBoardItemList = new ArrayList<DAChartBoardItem>();
    private DAChartBoardItem parentBoardItem;
    private static final int appAllocSeriesID = -10;
    private int libId;
    private String libName;
    private DAChartSeries totalSeries;
    private DAChartSeries appSeries;

    public String getLibName() {
        return this.libName;
    }

    public void setLibName(String libName) {
        this.libName = libName;
    }

    public int getLibId() {
        return this.libId;
    }

    public void setLibId(int libId) {
        this.libId = libId;
    }

    public HeapMemoryChart(String pageID, String chartName, int libId, String libName, DAChartBoardItem chartBoardItem, DAChart chart) {
        super(pageID, chartName, chartBoardItem, chart);
        this.libId = libId;
        this.libName = libName;
        this.chartType = -104;
        this.chartIcon = ImageResources.FEATURE_HEAPALLOC_SMALL_NOR;
        this.addIcon = ImageResources.FEATURE_HEAPALLOC_SMALL_NOR;
        if (libId == -10) {
            this.totalSeries = new DAChartSeries(TimelineChartLabels.HEAP_CHART_SERIES_NAME_TOTAL_ALLOCATION, 3, ColorResources.CHART_SERIES_YELLOW);
            chart.addSeries(this.totalSeries);
        }
        this.appSeries = new DAChartSeries(this.getLibName(libName), 3, ColorResources.CHART_SERIES_YELLOW, 0.5);
        chart.addSeries(this.appSeries);
    }

    private String getLibName(String libPath) {
        int index = libPath.lastIndexOf("/");
        return libPath.substring(index + 1);
    }

    @Override
    public void inputChartSeries(List<Object> dataList) {
        if (this.totalSeries != null) {
            this.totalSeries.clear();
        }
        this.appSeries.clear();
        if (Global.getProject() == null) {
            return;
        }
        String processName = AnalyzerUtil.getProcessName(this.pid);
        if (processName == null) {
            return;
        }
        Map processDataMap = (Map)dataList.get(1);
        List processData = (List)processDataMap.get(this.pid);
        if (processData == null) {
            return;
        }
        int i = 0;
        while (i < processData.size()) {
            List row = (List)processData.get(i);
            double time = (double)((Long)row.get(ProcessMemoryDBTable.COLUMN.SAMPLING_TIME.index)).longValue() / 1000000.0;
            long totalAlloc = 0L;
            List libIdList = (List)row.get(ProcessMemoryDBTable.COLUMN.HEAP_ALLOCATION_BINARY_ID.index);
            List libByteList = (List)row.get(ProcessMemoryDBTable.COLUMN.HEAP_ALLOCATION_BYTE.index);
            int index = libIdList.indexOf(this.libId);
            if (index != -1) {
                long targetAlloc = (Long)libByteList.get(index);
                this.appSeries.addSeriesItem(new DAChartSeriesItem(time, (double)targetAlloc, Formatter.toByteFormat(targetAlloc)));
            }
            for (Long libbyte : libByteList) {
                totalAlloc += libbyte.longValue();
            }
            if (this.totalSeries != null) {
                this.totalSeries.addSeriesItem(new DAChartSeriesItem(time, (double)totalAlloc, Formatter.toByteFormat(totalAlloc)));
            }
            ++i;
        }
    }

    @Override
    public DAChartBoardItem createBoardItem(DAChartBoard board) {
        this.parentBoardItem = super.createBoardItem(board);
        this.chart.getPlot().setAxisUnit("B");
        this.chart.getPlot().setAxisUnitType(DAChartPlot.UnitType.BINARY);
        this.chart.getPlot().setShowAxis(true);
        this.clear();
        return this.parentBoardItem;
    }

    @Override
    public void clear() {
        this.seriesPerProcessMap.clear();
        int i = 0;
        while (i < this.childBoardItemList.size()) {
            this.childBoardItemList.get(i).dispose();
            ++i;
        }
    }
}

