/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.memory.table;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.widgets.Composite;
import org.tizen.dynamicanalyzer.common.DAState;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.model.TableInput;
import org.tizen.dynamicanalyzer.nl.MemoryPageLabels;
import org.tizen.dynamicanalyzer.ui.memory.data.HeapDataManager;
import org.tizen.dynamicanalyzer.ui.toolbar.Toolbar;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableComposite;
import org.tizen.dynamicanalyzer.ui.widgets.table.DefaultTableComparator;
import org.tizen.dynamicanalyzer.ui.widgets.table.TableColumnSizePackListener;

public class MemoryStatisticsTable
extends DATableComposite {
    private int[] columnSizes = new int[]{265, 98, 88, 88, 88, 88, 15, 800};
    private int[] columnAlignment = new int[]{131072, 131072, 131072, 131072, 131072, 131072, 131072, 0x1000000};
    private Long StartTime;
    private Long EndTime;
    private String[] columnNames = new String[]{MemoryPageLabels.MEMORY_STATISTICS_VIEW_PATH, MemoryPageLabels.MEMORY_STATISTICS_VIEW_PERSISTENT_BYTE, MemoryPageLabels.MEMORY_STATISTICS_VIEW_PERSISTENT, MemoryPageLabels.MEMORY_STATISTICS_VIEW_FREED, MemoryPageLabels.MEMORY_STATISTICS_VIEW_TOTAL_BYTE, MemoryPageLabels.MEMORY_STATISTICS_VIEW_TOTAL, "", "Streaming is not supported. Please select range or stop Tracing"};
    private int[] sortTypes;

    public MemoryStatisticsTable(Composite parent, int style, int tableStyle) {
        super(parent, style, tableStyle);
        int[] nArray = new int[8];
        nArray[0] = 2;
        nArray[1] = 1;
        nArray[2] = 1;
        nArray[3] = 1;
        nArray[4] = 1;
        nArray[5] = 1;
        nArray[7] = 2;
        this.sortTypes = nArray;
        this.StartTime = 0L;
        this.EndTime = 0L;
        this.setTableName(MemoryPageLabels.MEMORY_STATISTICS_VIEW_TITLE);
        this.setComparator(new DefaultTableComparator());
        this.setSortTypes(this.sortTypes);
        this.setColumnAlignment(this.columnAlignment);
        this.setColumns(this.columnNames);
        this.setColumnSize(this.columnSizes);
        this.setTableToolTipEnable(false);
        this.comparator.setType(1);
        this.comparator.setColumn(1);
        this.comparator.setDirection(false);
        parent.addControlListener((ControlListener)new TableColumnSizePackListener(this, this.columnSizes));
    }

    public void setSelectionRange(Long start, Long end) {
        this.StartTime = start;
        this.EndTime = end;
    }

    @Override
    protected List<TableInput> makeTableInput() {
        List<TableInput> wholedata;
        ArrayList<TableInput> output = new ArrayList<TableInput>();
        if (Global.getProject() == null) {
            return output;
        }
        if (!DAState.isRunning() && this.StartTime == 0L && this.EndTime == 0L && Toolbar.INSTANCE.getSelectedPid() <= 0 && (wholedata = HeapDataManager.getInstance().getWholeStatisticsTreeInput()).size() != 0) {
            return wholedata;
        }
        String pidliststring = this.getTargetPIDString();
        Map<Integer, List<Object>> staticdatas = HeapDataManager.getInstance().remainedAllocStaticData(this.StartTime, this.EndTime, pidliststring);
        long persistentSize = 0L;
        long persistentCount = 0L;
        long freecount = 0L;
        long totalSize = 0L;
        int index = 0;
        for (Map.Entry<Integer, List<Object>> elem : staticdatas.entrySet()) {
            Long cfr_ignored_0 = (Long)elem.getValue().get(0);
            String apiName = Global.getLibraryName(elem.getKey());
            TableInput staticInput = HeapDataManager.getInstance().makeTreeInputForDatas(apiName, elem.getValue(), index++);
            if (staticInput != null) {
                output.add(staticInput);
            }
            persistentSize += ((Long)elem.getValue().get(0)).longValue();
            persistentCount += ((Long)elem.getValue().get(1)).longValue();
            freecount += ((Long)elem.getValue().get(2)).longValue();
            totalSize += ((Long)elem.getValue().get(3)).longValue();
        }
        ArrayList<Object> total = new ArrayList<Object>();
        total.add(persistentSize);
        total.add(persistentCount);
        total.add(freecount);
        total.add(totalSize);
        total.add(persistentCount + freecount);
        TableInput totalInput = HeapDataManager.getInstance().makeTreeInputForDatas("Total", total, index++);
        output.add(0, totalInput);
        return output;
    }

    private String getTargetPIDString() {
        ArrayList<Integer> pidlist = new ArrayList<Integer>();
        int[] pids = Global.getProject().getProcessIDs();
        int targetPID = Toolbar.INSTANCE.getSelectedPid();
        if (targetPID > 0) {
            pidlist.add(targetPID);
        } else {
            int i = 0;
            while (i < pids.length) {
                pidlist.add(pids[i]);
                ++i;
            }
        }
        String pidliststring = "(";
        int i = 0;
        while (i < pidlist.size()) {
            pidliststring = String.valueOf(pidliststring) + Integer.toString((Integer)pidlist.get(i));
            if (i != pidlist.size() - 1) {
                pidliststring = String.valueOf(pidliststring) + ", ";
            }
            ++i;
        }
        pidliststring = String.valueOf(pidliststring) + ")";
        return pidliststring;
    }

    public void removeSelection() {
        this.table.removeAll();
        this.updateTable();
    }

    @Override
    public void clear() {
        this.table.removeAll();
        this.getSelectionIndex().clear();
        this.getSelections().clear();
        this.StartTime = 0L;
        this.EndTime = 0L;
    }
}

