/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.network;

import java.util.List;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.tizen.dynamicanalyzer.common.AnalyzerManager;
import org.tizen.dynamicanalyzer.common.DASelectionData;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.nl.NetworkPageLabels;
import org.tizen.dynamicanalyzer.project.ProcessInformation;
import org.tizen.dynamicanalyzer.project.ProcessMemoryMap;
import org.tizen.dynamicanalyzer.project.Project;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.resources.FontResources;
import org.tizen.dynamicanalyzer.resources.ImageResources;
import org.tizen.dynamicanalyzer.swap.model.data.LogData;
import org.tizen.dynamicanalyzer.ui.common.SetRangeMarkerMouseMoveListener;
import org.tizen.dynamicanalyzer.ui.network.NetworkChart;
import org.tizen.dynamicanalyzer.ui.network.NetworkChartBoard;
import org.tizen.dynamicanalyzer.ui.network.NetworkPage;
import org.tizen.dynamicanalyzer.ui.network.data.NetworkDataManager;
import org.tizen.dynamicanalyzer.ui.page.BaseView;
import org.tizen.dynamicanalyzer.ui.range.RangeDataManager;
import org.tizen.dynamicanalyzer.ui.timeline.logparser.LifecycleLogParser;
import org.tizen.dynamicanalyzer.ui.toolbar.DAToolBarCustomCombo;
import org.tizen.dynamicanalyzer.ui.toolbar.ToolBarComboListener;
import org.tizen.dynamicanalyzer.ui.toolbar.Toolbar;
import org.tizen.dynamicanalyzer.util.WorkbenchUtil;
import org.tizen.dynamicanalyzer.utils.AnalyzerUtil;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButtonRenderer;
import org.tizen.dynamicanalyzer.widgets.button.IDACustomButtonRenderer;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartPlotIntervalMarker;
import org.tizen.dynamicanalyzer.widgets.chartBoard.DAChartBoard;
import org.tizen.dynamicanalyzer.widgets.chartBoard.DAChartBoardItem;
import org.tizen.dynamicanalyzer.widgets.chartBoard.DAChartBoardSelectionListener;
import org.tizen.dynamicanalyzer.widgets.da.view.DAViewComposite;
import org.tizen.dynamicanalyzer.widgets.da.view.DAViewData;
import org.tizen.dynamicanalyzer.widgets.scale.DAScaleSelectionListener;
import org.tizen.dynamicanalyzer.widgets.timeline.DATimeline;

public class NetworkChartView
extends DAViewComposite {
    public static final int NETWORK_CHART_HEIGHT = 40;
    private final Composite contents;
    private NetworkChartBoard networkChartBoard;
    private final StackLayout stackLayout;
    private DAChartBoardItem lastSelectedItemForSummary = null;
    private DAToolBarCustomCombo processCombo;
    private final RangeDataManager rangeDataManager = RangeDataManager.getInstance();

    public NetworkChartView(Composite parent, int style) {
        super(parent, style, false);
        this.setLayout((Layout)new FillLayout());
        AnalyzerUtil.setLatestTraceMode(NetworkPage.pageID, true);
        this.setTitle(NetworkPageLabels.NETWORK_CHART);
        this.contents = this.getContentArea();
        this.contents.setBackground(ColorResources.WINDOW_BG_COLOR);
        this.stackLayout = new StackLayout();
        this.contents.setLayout((Layout)this.stackLayout);
        this.networkChartBoard = new NetworkChartBoard(this.contents, NetworkPageLabels.NETWORK_CHART);
        this.networkChartBoard.setNameFont(FontResources.CHART_NAME_FONT);
        this.networkChartBoard.addSelectionListener(new DAChartBoardSelectionListener(){

            public void handleSelectionEvent(DAChartBoardItem item) {
                NetworkChartView.this.callUpdatePage(item);
            }
        });
        ScrollBar hScrollBar = this.networkChartBoard.getHScrollBar();
        hScrollBar.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (NetworkChartView.this.networkChartBoard.isMaximumScrolled()) {
                    AnalyzerUtil.setLatestTraceMode(NetworkPage.pageID, true);
                } else {
                    AnalyzerUtil.setLatestTraceMode(NetworkPage.pageID, false);
                }
            }
        });
        this.stackLayout.topControl = this.networkChartBoard;
        DATimeline timeline = this.networkChartBoard.getTimeline();
        timeline.setTimeTickFont(FontResources.TIMELINE_TICK_FONT);
        timeline.setTimeBalloonFont(FontResources.TIMELINE_BALLOON_FONT);
        LifecycleLogParser.getInstance().registerLifecycleBar(this.networkChartBoard.getLifecycleBar());
        LifecycleLogParser.getInstance().registerTimeline(timeline);
        SetRangeMarkerMouseMoveListener listener = new SetRangeMarkerMouseMoveListener(this.rangeDataManager, this.networkChartBoard, timeline);
        timeline.addMouseMoveListener((MouseMoveListener)listener);
        timeline.addMouseListener((MouseListener)listener);
        this.processCombo = this.makeDACustomCombo(this.networkChartBoard.getTitleComp());
        FormData data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment(0, 0);
        data.width = 190;
        data.height = 20;
        this.processCombo.setLayoutData(data);
        this.initProcessCombo();
        this.updateScale();
        this.networkChartBoard.getScale().addSelectionListener(new DAScaleSelectionListener(){

            public void widgetSelected() {
                Toolbar.INSTANCE.setScaleSelection(NetworkChartView.this.networkChartBoard.getScale().getSelection());
                NetworkChartView.this.updateScale();
            }
        });
        this.networkChartBoard.getListComposite().addListener(37, new Listener(){

            public void handleEvent(Event event) {
                Toolbar.INSTANCE.setScaleSelection(NetworkChartView.this.networkChartBoard.getScale().getSelection());
            }
        });
    }

    public void callUpdatePage(DAChartBoardItem selectedItem) {
        this.lastSelectedItemForSummary = selectedItem;
        DAChartPlotIntervalMarker intervalMarker = (DAChartPlotIntervalMarker)this.networkChartBoard.getMarkers().get(0);
        long selectedStartTime = (long)(intervalMarker.getStartVal() * 1000000.0);
        long selectedEndTime = (long)(intervalMarker.getEndVal() * 1000000.0);
        AnalyzerManager.getCurrentPage().updateView((DAViewData)new DASelectionData(NetworkPage.chartViewID, selectedStartTime, selectedEndTime, selectedItem.getData(), null));
    }

    private void updateScale() {
        int scaleSelection = Toolbar.INSTANCE.getScaleSelection();
        this.networkChartBoard.getBoardManager().scaleChanged(scaleSelection);
        this.networkChartBoard.setScaleVal(scaleSelection);
    }

    private void updateProcessCombo() {
        int index = Toolbar.INSTANCE.getProcessCombo().getSelectionIndex();
        if (index + 1 > this.processCombo.getItems().size()) {
            this.addProcessListToProcessCombo();
        }
        this.processCombo.select(index);
    }

    private void addProcessListToProcessCombo() {
        Project project = Global.getProject();
        if (project == null) {
            return;
        }
        int[] pids = project.getProcessIDs();
        int pcount = pids.length;
        int i = 0;
        while (i < pcount) {
            ProcessMemoryMap map;
            ProcessInformation process = project.getProcessInformation(pids[i]);
            String binName = process.getProcessName();
            if ((binName == null || binName.isEmpty()) && (map = process.getLastProcessMemoryMap()) != null) {
                int bid = map.getMainbinary().getBinaryID();
                String binPath = project.getDeviceStatusInfo().getBinaryInfo(bid).getTargetBinaryPath();
                if (binPath != null && !binPath.isEmpty()) {
                    int index = binPath.lastIndexOf("/");
                    binName = binPath.substring(index + 1, binPath.length());
                }
            }
            StringBuffer buffer = new StringBuffer();
            buffer.append(process.getPid()).append(" : ");
            buffer.append(binName);
            this.processCombo.add(buffer.toString());
            Toolbar.INSTANCE.getProcessCombo().add(buffer.toString());
            ++i;
        }
    }

    private DAToolBarCustomCombo makeDACustomCombo(Composite parent) {
        int PROCESS_COMBO = 2;
        DAToolBarCustomCombo returnCombo = new DAToolBarCustomCombo(parent, 0);
        returnCombo.setComboGradation(ColorResources.WHITE, ColorResources.WHITE, ColorResources.WHITE, ColorResources.WHITE, ColorResources.WHITE, ColorResources.WHITE, ColorResources.WHITE, ColorResources.WHITE);
        returnCombo.setOutlineColors(ColorResources.GRAY_170, ColorResources.GRAY_170, ColorResources.GRAY_170, ColorResources.GRAY_170);
        returnCombo.setComboImages(ImageResources.DROP_ARROW_DOWN_NOR, ImageResources.DROP_ARROW_DOWN_SEL, ImageResources.DROP_ARROW_DOWN_HOVER, ImageResources.DROP_ARROW_DOWN_DIM);
        returnCombo.setComboImagePoint(new Point(160, 9));
        returnCombo.setComboButtonColor(ColorResources.WHITE, ColorResources.WHITE, ColorResources.WHITE, ColorResources.WHITE);
        returnCombo.setArrowOutlineColors(ColorResources.GRAY_220, ColorResources.GRAY_220, ColorResources.GRAY_220, ColorResources.GRAY_220);
        returnCombo.setButtonImages(ImageResources.COMBO_DROPDOWN_UP, ImageResources.COMBO_DROPDOWN_DOWN);
        returnCombo.setFontPoint(new Point(5, 5));
        returnCombo.setEnabled(true);
        returnCombo.setComboFont(FontResources.COMBO);
        returnCombo.setItemFont(FontResources.DROPDOWN);
        returnCombo.setFontColors(ColorResources.BLACK, ColorResources.BLACK, ColorResources.BLACK, ColorResources.GRAY_170);
        returnCombo.setButtonRenderer((IDACustomButtonRenderer)new DACustomButtonRenderer());
        returnCombo.setDeviceCombo(PROCESS_COMBO);
        return returnCombo;
    }

    public void initProcessCombo() {
        this.processCombo.initCombo();
        this.processCombo.add("All Processes");
        this.processCombo.select(0);
        this.processCombo.addSelectionListener(new ToolBarComboListener(){

            @Override
            public void selectionEvent(DAToolBarCustomCombo combo) {
                int i = 0;
                while (i < Toolbar.INSTANCE.getProcessCombo().getItems().size()) {
                    if (combo.getText().equals(Toolbar.INSTANCE.getProcessCombo().getItem(i))) {
                        Toolbar.INSTANCE.getProcessCombo().select(i);
                    }
                    ++i;
                }
                BaseView baseView = (BaseView)WorkbenchUtil.getViewPart((String)BaseView.ID);
                baseView.getTopComposite().updateView();
            }
        });
        this.processCombo.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                Project project = Global.getProject();
                if (project == null) {
                    return;
                }
                NetworkChartView.this.processCombo.initCombo();
                NetworkChartView.this.processCombo.add("All Processes");
                Toolbar.INSTANCE.getProcessCombo().initCombo();
                Toolbar.INSTANCE.getProcessCombo().add("All Processes");
                int[] pids = project.getProcessIDs();
                int pcount = pids.length;
                int i = 0;
                while (i < pcount) {
                    ProcessMemoryMap map;
                    ProcessInformation process = project.getProcessInformation(pids[i]);
                    String binName = process.getProcessName();
                    if ((binName == null || binName.isEmpty()) && (map = process.getLastProcessMemoryMap()) != null) {
                        int bid = map.getMainbinary().getBinaryID();
                        String binPath = project.getDeviceStatusInfo().getBinaryInfo(bid).getTargetBinaryPath();
                        if (binPath != null && !binPath.isEmpty()) {
                            int index = binPath.lastIndexOf("/");
                            binName = binPath.substring(index + 1, binPath.length());
                        }
                    }
                    StringBuffer buffer = new StringBuffer();
                    buffer.append(process.getPid()).append(" : ");
                    buffer.append(binName);
                    NetworkChartView.this.processCombo.add(buffer.toString());
                    Toolbar.INSTANCE.getProcessCombo().add(buffer.toString());
                    ++i;
                }
            }
        });
    }

    public void updateMarker() {
        List<Double> markerTimeList = Toolbar.INSTANCE.getMarkerTimeList();
        List<NetworkChart> chartList = this.networkChartBoard.getNetworkChartList();
        for (NetworkChart chart : chartList) {
            chart.getChart().getPlot().clearMarkerTime();
        }
        for (double time : markerTimeList) {
            for (NetworkChart chart : chartList) {
                chart.getChart().getPlot().addMarkerTime(time);
            }
            this.networkChartBoard.getTimeline().addMarker(time);
        }
    }

    public void updateView() {
        this.updateScale();
        this.updateProcessCombo();
        this.updateMarker();
        this.networkChartBoard.updateChart();
        if (AnalyzerUtil.isLatestTraceMode(NetworkPage.pageID)) {
            this.networkChartBoard.updateVisibleStartTime();
            this.networkChartBoard.setTotalEndTime(Toolbar.INSTANCE.getTime(), true);
        } else {
            this.networkChartBoard.setTotalEndTime(Toolbar.INSTANCE.getTime(), false);
        }
        if (RangeDataManager.getInstance().isBeingAnalyzed()) {
            ((DAChartPlotIntervalMarker)this.networkChartBoard.getMarkers().get(1)).setInterval((double)this.rangeDataManager.getAnalysisStartTime() / 1000000.0, (double)this.rangeDataManager.getAnalysisEndTime() / 1000000.0);
        } else {
            ((DAChartPlotIntervalMarker)this.networkChartBoard.getMarkers().get(1)).setInterval(-1.0, -1.0);
        }
        ((DAChartPlotIntervalMarker)this.networkChartBoard.getMarkers().get(2)).setInterval((double)this.rangeDataManager.getMarkerStartTime() / 1000000.0, (double)this.rangeDataManager.getMarkerEndTime() / 1000000.0);
    }

    public void updateView(DAViewData data) {
        this.updateScale();
        this.updateProcessCombo();
        this.updateMarker();
        this.networkChartBoard.updateChart();
        if (!(data instanceof DASelectionData)) {
            return;
        }
        DASelectionData selData = (DASelectionData)data;
        String id = data.getViewID();
        if (id.equals(NetworkPage.chartViewID) || id.equals(NetworkPage.detailViewID)) {
            return;
        }
        if (id.equals(NetworkPage.listViewID)) {
            this.moveChartPosition(selData.getStartTime(), -1L);
        } else {
            this.updateFromOtherView(selData.getData());
        }
    }

    private void updateFromOtherView(Object obData) {
        if (obData == null || !(obData instanceof LogData)) {
            return;
        }
        LogData ldata = (LogData)obData;
        long dataTime = ldata.getTime();
        if (this.lastSelectedItemForSummary != null) {
            AnalyzerManager.getCurrentPage().updateView((DAViewData)new DASelectionData(NetworkPage.chartViewID, dataTime, dataTime, this.lastSelectedItemForSummary.getData(), null));
        }
        this.moveChartPosition(dataTime, ldata.getSeq());
    }

    private void moveChartPosition(long dataTime, long seq) {
        double selectionTime = (double)dataTime / 1000000.0;
        this.networkChartBoard.setVisibleMiddleTime(selectionTime);
        DAChartPlotIntervalMarker intervalMarker = (DAChartPlotIntervalMarker)this.networkChartBoard.getMarkers().get(0);
        intervalMarker.setInterval(selectionTime, selectionTime);
        if (seq > 0L) {
            int parentChartIndex = NetworkDataManager.getInstance().getParentIndexOfSeq(seq);
            int childChartIndex = NetworkDataManager.getInstance().getChildIndexOfSeq(seq);
            this.networkChartBoard.selectItem(parentChartIndex, childChartIndex);
        }
    }

    public void clear() {
        this.networkChartBoard.clear();
    }

    public Control getControl() {
        return this.networkChartBoard;
    }

    public void setRangeMarker(double starttime, double endtime) {
        ((DAChartPlotIntervalMarker)this.networkChartBoard.getMarkers().get(2)).setInterval(starttime, endtime);
    }

    public DAChartBoard getChartBoard() {
        return this.networkChartBoard;
    }
}

