/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.opengl.chart;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.widgets.Composite;
import org.tizen.dynamicanalyzer.ui.common.TimeLineChartKeyListener;
import org.tizen.dynamicanalyzer.ui.common.TimelineChartMouseEventListener;
import org.tizen.dynamicanalyzer.ui.common.TimelineChartMouseTrackAdapter;
import org.tizen.dynamicanalyzer.ui.opengl.GLPage;
import org.tizen.dynamicanalyzer.ui.opengl.chart.GLChartBoard;
import org.tizen.dynamicanalyzer.ui.opengl.chart.GLFrameRateChart;
import org.tizen.dynamicanalyzer.ui.opengl.chart.listener.GLFrameRateMouseListener;
import org.tizen.dynamicanalyzer.ui.range.RangeDataManager;
import org.tizen.dynamicanalyzer.ui.timeline.chart.CPUChart;
import org.tizen.dynamicanalyzer.ui.timeline.chart.ScreenshotChart;
import org.tizen.dynamicanalyzer.ui.timeline.chart.TimelineChart;
import org.tizen.dynamicanalyzer.ui.timeline.common.TimelineChartManager;
import org.tizen.dynamicanalyzer.ui.timeline.common.TimelineDataManager;
import org.tizen.dynamicanalyzer.ui.toolbar.Toolbar;
import org.tizen.dynamicanalyzer.utils.AnalyzerUtil;
import org.tizen.dynamicanalyzer.widgets.chart.DAChart;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartPlotIntervalMarker;
import org.tizen.dynamicanalyzer.widgets.chartBoard.DAChartBoardItem;

public class GLFrameRateChartBoard
extends GLChartBoard {
    private List<TimelineChart> timelineChartList = new ArrayList<TimelineChart>();

    public GLFrameRateChartBoard(Composite parent, String title, int boardStyle) {
        super(parent, title, boardStyle);
    }

    public void updateView() {
        long totalEndTime = Toolbar.INSTANCE.getTime();
        if (AnalyzerUtil.isLatestTraceMode(GLPage.pageID)) {
            this.updateVisibleStartTime();
            this.setTotalEndTime(totalEndTime, true);
        } else {
            this.setTotalEndTime(totalEndTime, false);
        }
        TimelineChartManager.getInstance().makeChartSeries(AnalyzerUtil.translateSecToMicroSec(this.getVisibleStartTime()), AnalyzerUtil.translateSecToMicroSec(this.getVisibleEndTime()));
        RangeDataManager.getInstance().getMarkerStartTime();
        RangeDataManager.getInstance().getMarkerEndTime();
        double analysisStartTime = (double)RangeDataManager.getInstance().getAnalysisStartTime() / 1000000.0;
        double analysisEndTime = (double)RangeDataManager.getInstance().getAnalysisEndTime() / 1000000.0;
        if (RangeDataManager.getInstance().isBeingAnalyzed()) {
            ((DAChartPlotIntervalMarker)this.getMarkers().get(1)).setInterval(analysisStartTime, analysisEndTime);
        } else {
            ((DAChartPlotIntervalMarker)this.getMarkers().get(1)).setInterval(-1.0, -1.0);
        }
        this.updateViewFromDBData();
    }

    public void initializeCharts() {
        this.initIntervalMarkers();
        GLFrameRateChart frameRateChart = GLFrameRateChart.getInstance();
        DAChartBoardItem frameRateChartItem = frameRateChart.createBoardItem(this, true);
        DAChart frameRateChartWidget = frameRateChartItem.getChart();
        GLFrameRateMouseListener glFrameRateMouseEventListener = new GLFrameRateMouseListener(frameRateChart.getPopupMenu(), this.getTimeline());
        frameRateChartWidget.getPlot().setMarkers(this.getMarkers());
        frameRateChartWidget.addMouseListener((MouseListener)glFrameRateMouseEventListener);
        frameRateChartWidget.addMouseMoveListener((MouseMoveListener)glFrameRateMouseEventListener);
        frameRateChartWidget.addMouseTrackListener((MouseTrackListener)new TimelineChartMouseTrackAdapter(this.getTimeline()));
        this.initializeTimelineCharts();
    }

    @Override
    protected void updateViewFromDBData() {
        GLFrameRateChart.getInstance().updateView(this.getVisibleStartTime(), this.getVisibleEndTime());
        this.updateTimelineCharts();
    }

    private void updateTimelineCharts() {
        long startTime = AnalyzerUtil.translateSecToMicroSec(this.getVisibleStartTime());
        long endTime = AnalyzerUtil.translateSecToMicroSec(this.getVisibleEndTime());
        List<List<Object>> systemDBData = TimelineDataManager.getInstance().getSystemDataFromDB(startTime, endTime);
        List<List<Object>> screenShotDBData = TimelineDataManager.getInstance().getScreenShotDataFromDB(startTime, endTime);
        int selectedPID = 0;
        if (Toolbar.INSTANCE != null) {
            selectedPID = Toolbar.INSTANCE.getSelectedPid();
        }
        Map<Integer, List<List<Object>>> targetProcessDBData = TimelineDataManager.getInstance().getTargetProcessDataFromDB(startTime, endTime, selectedPID);
        for (TimelineChart chart : this.timelineChartList) {
            ArrayList<Object> dataList;
            if (chart.getProbeType() == 5) {
                dataList = new ArrayList<Object>();
                dataList.add(systemDBData);
                dataList.add(targetProcessDBData);
                chart.inputChartSeries(dataList);
                continue;
            }
            if (chart.getProbeType() != 262) continue;
            dataList = new ArrayList();
            dataList.add(screenShotDBData);
            chart.inputChartSeries(dataList);
        }
    }

    private void initializeTimelineCharts() {
        this.timelineChartList.clear();
        this.timelineChartList.add(new CPUChart(GLPage.pageID));
        this.timelineChartList.add(new ScreenshotChart(GLPage.pageID));
        int i = 0;
        while (i < this.timelineChartList.size()) {
            TimelineChart timelineChart = this.timelineChartList.get(i);
            DAChartBoardItem item = timelineChart.createBoardItem(this);
            item.setHeight(80);
            DAChart chartWidget = item.getChart();
            chartWidget.getPlot().setAxisRangeX(this.getVisibleStartTime(), this.getVisibleEndTime());
            chartWidget.getPlot().setMarkers(this.getMarkers());
            TimelineChartMouseEventListener chartMouseEventListener = new TimelineChartMouseEventListener(timelineChart.getPopupMenu(), this.getTimeline(), GLPage.pageID);
            chartWidget.addMouseListener((MouseListener)chartMouseEventListener);
            chartWidget.addMouseMoveListener((MouseMoveListener)chartMouseEventListener);
            chartWidget.addMouseTrackListener((MouseTrackListener)new TimelineChartMouseTrackAdapter(this.getTimeline()));
            TimeLineChartKeyListener timelineKeyListener = new TimeLineChartKeyListener(this);
            chartWidget.addKeyListener((KeyListener)timelineKeyListener);
            ++i;
        }
    }

    public List<TimelineChart> getChartList() {
        return this.timelineChartList;
    }
}

