/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.page;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.bindings.Binding;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.keys.IBindingService;
import org.eclipse.ui.part.ViewPart;
import org.tizen.dynamicanalyzer.annotation.UIMethod;
import org.tizen.dynamicanalyzer.callback.ExecutionCallbackManager;
import org.tizen.dynamicanalyzer.callback.IExecutionCallback;
import org.tizen.dynamicanalyzer.common.DAResult;
import org.tizen.dynamicanalyzer.common.DAState;
import org.tizen.dynamicanalyzer.common.PreWindowShellCloseCallback;
import org.tizen.dynamicanalyzer.common.path.PathManager;
import org.tizen.dynamicanalyzer.communicator.DACommunicator;
import org.tizen.dynamicanalyzer.communicator.DeviceManager;
import org.tizen.dynamicanalyzer.communicator.IDECommunicator;
import org.tizen.dynamicanalyzer.communicator.UnsupportedProtocolException;
import org.tizen.dynamicanalyzer.control.SideWorker;
import org.tizen.dynamicanalyzer.handlers.CommandAction;
import org.tizen.dynamicanalyzer.nl.TimelineChartLabels;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.setting.FlatFeature;
import org.tizen.dynamicanalyzer.setting.SettingDataManager;
import org.tizen.dynamicanalyzer.setting.TargetData;
import org.tizen.dynamicanalyzer.swap.logparser.DataManagerRegistry;
import org.tizen.dynamicanalyzer.swap.platform.BinarySettingManager;
import org.tizen.dynamicanalyzer.ui.page.MenuBar;
import org.tizen.dynamicanalyzer.ui.page.PageInfoRegistry;
import org.tizen.dynamicanalyzer.ui.range.RangeDataManager;
import org.tizen.dynamicanalyzer.ui.timeline.TimelinePage;
import org.tizen.dynamicanalyzer.ui.toolbar.Toolbar;
import org.tizen.dynamicanalyzer.ui.toolbar.setting.FlatFeatureDialog;
import org.tizen.dynamicanalyzer.ui.toolbar.setting.PreferencesDialog;
import org.tizen.dynamicanalyzer.ui.toolbar.setting.TargetDialog;
import org.tizen.dynamicanalyzer.util.CommonUtil;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.util.WorkbenchUtil;
import org.tizen.dynamicanalyzer.utils.AnalyzerUtil;
import org.tizen.dynamicanalyzer.widgets.da.view.DABaseComposite;
import org.tizen.dynamicanalyzer.widgets.da.view.DAPageComposite;
import org.tizen.dynamicanalyzer.widgets.da.view.DATabComposite;
import org.tizen.dynamicanalyzer.workbench.LayoutManager;

public class BaseView
extends ViewPart {
    public static final String ID = BaseView.class.getName();
    DAPageComposite topComposite = null;
    DATabComposite tabView = null;
    private static final int MINIMUM_SHELL_WIDTH = 800;
    private static final int MINIMUM_SHELL_HEIGHT_WIN = 657;
    private static final int MINIMUM_SHELL_HEIGHT_LINUX = 622;

    public void createPartControl(Composite parent) {
        WorkbenchUtil.getWorkbenchWindow().getShell().setCursor(null);
        Composite newParent = LayoutManager.createComposite((Composite)parent);
        Composite toolbarComposite = LayoutManager.getToolbarComposite();
        Toolbar.INSTANCE.create(toolbarComposite);
        this.tabView = new DATabComposite(newParent, 0x20000000);
        this.tabView.enableImageTab(true);
        this.tabView.setTabBGColor(ColorResources.WHITE, ColorResources.WHITE);
        this.createPagesByTarget(null);
        this.RunInitializing();
        MenuBar.getInstance().makeMenuBar();
        this.setMinumumShellSize();
        this.unbindNeedlessCommand();
        this.addKeyListener();
    }

    private void unbindNeedlessCommand() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IBindingService bindingService = (IBindingService)workbench.getAdapter(IBindingService.class);
        Binding[] bindingArray = bindingService.getBindings();
        int n = bindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            Binding binding = bindingArray[n2];
            if (binding.getTriggerSequence().toString().equals("CTRL+N")) {
                binding.getParameterizedCommand().getCommand().undefine();
            }
            ++n2;
        }
    }

    public void addKeyListener() {
        PlatformUI.getWorkbench().getDisplay().addFilter(1, new Listener(){

            public void handleEvent(Event e) {
                Shell currentShell = WorkbenchUtil.getWorkbenchWindow().getShell();
                if ((e.stateMask & 0x40000) == 262144 && e.keyCode == 113) {
                    currentShell.close();
                } else if ((e.stateMask & 0x40000) == 262144 && e.keyCode == 110) {
                    if (MenuBar.getInstance().getFileNew().isEnabled()) {
                        MenuBar.getInstance().getFileNew().notifyListeners(13, new Event());
                    }
                } else if ((e.stateMask & 0x40000) == 262144 && e.keyCode == 116) {
                    TargetDialog targetDialog = new TargetDialog(currentShell);
                    targetDialog.open();
                } else if ((e.stateMask & 0x40000) == 262144 && e.keyCode == 104) {
                    if (MenuBar.getInstance().getViewDetail().getSelection()) {
                        MenuBar.getInstance().getViewDetail().setSelection(false);
                    } else {
                        MenuBar.getInstance().getViewDetail().setSelection(true);
                    }
                    MenuBar.getInstance().getViewDetail().notifyListeners(13, new Event());
                } else if (e.keyCode == 0x1000012) {
                    BaseView baseView;
                    TargetData target;
                    Set<String> targetChartList;
                    if (DAState.isRunning() && !(targetChartList = SettingDataManager.INSTANCE.getSelectedChartSet((target = SettingDataManager.INSTANCE.getConnectedTarget()).getTargetName())).contains(TimelineChartLabels.SCREENSHOT_CHART_TITLE) && (baseView = (BaseView)WorkbenchUtil.getViewPart((String)ID)).getTopComposite() instanceof TimelinePage) {
                        TimelinePage timelinePage = (TimelinePage)baseView.getTopComposite();
                        timelinePage.getTimelineChartView().addScreenshotChart();
                        target.addSelectedFlatFeature(FlatFeature.SCREENSHOT.getName());
                    }
                    try {
                        if (!DACommunicator.captureScreenshot().isSuccess()) {
                            Logger.error((Object)"Failed to capture screenshot");
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        Logger.warning((Object)"Interrupted during send screenshot message");
                    }
                    catch (UnsupportedProtocolException unsupportedProtocolException) {
                        Logger.warning((Object)"Message to capture screenshot is not supported by communicator");
                    }
                } else if (e.keyCode == 0x100000E) {
                    if (DAState.isStartable() && Toolbar.INSTANCE.getStartButton().getState() == 0) {
                        Toolbar.INSTANCE.clearMarkerTimeList();
                        RangeDataManager.getInstance().clearMarkerTime();
                        RangeDataManager.getInstance().clearTimelineMarker();
                        CommandAction.startTrace(false);
                    } else if (DAState.isRunning() && Toolbar.INSTANCE.getStartButton().getState() == 0) {
                        CommandAction.stopTrace(new DAResult(DAResult.ErrorCode.SUCCESS), false);
                    }
                }
            }
        });
        PlatformUI.getWorkbench().getDisplay().addFilter(2, new Listener(){

            public void handleEvent(Event e) {
                if (e.keyCode == 0x1000013) {
                    Shell currentShell = WorkbenchUtil.getWorkbenchWindow().getShell();
                    PreferencesDialog preferencesDialog = new PreferencesDialog(currentShell);
                    preferencesDialog.open();
                }
            }
        });
    }

    public void RunInitializing() {
        DAState.changeCurrentState(DAState.INIT);
        AnalyzerUtil.setPlatformSDK();
        DeviceManager.init();
        DeviceManager.addDeviceListener();
        BinarySettingManager.getInstance().initBinarySettings();
        Thread IDEComthread = new Thread(new Runnable(){

            @Override
            public void run() {
                IDECommunicator.startIDECommunicatorThread();
                SideWorker.INSTANCE.start();
            }
        });
        IDEComthread.start();
        File saveFolder = new File(PathManager.DA_TEMP_FOLDER_PATH);
        if (saveFolder.exists()) {
            if (AnalyzerUtil.deleteFile(saveFolder)) {
                Logger.debug((Object)"delete temp folder");
            } else {
                Logger.debug((Object)"BUG: temp folder is already exists but failed to delete");
            }
        }
        if (!saveFolder.isDirectory() && !saveFolder.mkdirs()) {
            Logger.debug((Object)"save folder create failed...");
        }
        if (Toolbar.INSTANCE.getDeviceCombo().getText() != "Select Target") {
            DeviceManager.loadDevices();
            if (!Toolbar.INSTANCE.updateDeviceCombo(null)) {
                Toolbar.INSTANCE.updateAppCombo(true);
            }
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                Shell shell = WorkbenchUtil.getWorkbenchWindow().getShell();
                FlatFeatureDialog featureDialog = new FlatFeatureDialog(shell);
                featureDialog.open();
            }
        });
        ExecutionCallbackManager.registerCallback((String)"WindowAdvisor.preWindowShellClose", (IExecutionCallback)new PreWindowShellCloseCallback());
    }

    private void setMinumumShellSize() {
        if (CommonUtil.isWin()) {
            WorkbenchUtil.getWorkbenchWindow().getShell().setMinimumSize(800, 657);
        } else {
            WorkbenchUtil.getWorkbenchWindow().getShell().setMinimumSize(800, 622);
        }
    }

    public void setFocus() {
    }

    public DATabComposite getMainTab() {
        return this.tabView;
    }

    public void createPagesByTarget(String targetName) {
        this.compositePages(PageInfoRegistry.getPageNamesByTarget(targetName));
    }

    public void compositePages(Set<String> pageSet) {
        if (pageSet != null) {
            ArrayList<String> pageList = new ArrayList<String>();
            List<String> pageOrder = PageInfoRegistry.getOrderedPageNames();
            for (String pageName : pageOrder) {
                if (!pageSet.contains(pageName)) continue;
                pageList.add(pageName);
            }
            Logger.debug(pageList);
            this.compositePages(pageList);
        } else {
            Logger.error((Object)"Page set is null");
        }
    }

    public void compositePages(List<String> pageNames) {
        if (pageNames != null && !pageNames.isEmpty()) {
            this.tabView.removeAll();
            for (String pageName : pageNames) {
                DABaseComposite newPage = PageInfoRegistry.createPageByName(pageName, this.tabView.getContentComposite());
                if (newPage != null) {
                    DataManagerRegistry.createDataManagers(pageName);
                    this.tabView.addView(newPage, false);
                    continue;
                }
                Logger.warning((Object)"Unknown tab ID");
            }
        } else {
            Logger.error((Object)"Page List is Null");
        }
    }

    public void removeTabViewPage(String tabViewId, boolean usingAnimation) {
        if (this.tabView.isExistingPage(tabViewId)) {
            this.tabView.removeView(tabViewId, usingAnimation);
        } else {
            Logger.debug((Object)("Remove failed : " + tabViewId + " does not exist"));
        }
    }

    public DAPageComposite getTopComposite() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                BaseView.this.topComposite = (DAPageComposite)BaseView.this.tabView.getTopComposite();
            }
        });
        return this.topComposite;
    }

    public DAPageComposite getTopPage() {
        return this.getTopComposite();
    }

    @UIMethod
    public void clear() {
        this.tabView.clear();
    }
}

