/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.summary.leaks;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import org.tizen.dynamicanalyzer.database.DBColumn;
import org.tizen.dynamicanalyzer.database.DBTable;
import org.tizen.dynamicanalyzer.util.Logger;

public class MemoryAllocationDataDBTable
extends DBTable {
    private static final String TABLENAME = "MEMORY_ALLOCATION_DATA";

    @Override
    public String getTableName() {
        return TABLENAME;
    }

    public MemoryAllocationDataDBTable() {
        this.addColumn(new DBColumn(COLUMN.SEQUENCE_NUMBER.name, "PRIMARY KEY", "BIGINT"));
        this.addColumn(new DBColumn(COLUMN.PID.name, "NOT NULL", "INTEGER"));
        this.addColumn(new DBColumn(COLUMN.API_ID.name, "NOT NULL", "INTEGER"));
        this.addColumn(new DBColumn(COLUMN.API_TYPE.name, "NOT NULL", "INTEGER"));
        this.addColumn(new DBColumn(COLUMN.ALLOCATED_ADDRESS.name, "NOT NULL", "BIGINT"));
        this.addColumn(new DBColumn(COLUMN.ALLOCATED_TIME.name, "NOT NULL", "BIGINT"));
        this.addColumn(new DBColumn(COLUMN.CALLER_PC_ADDRESS.name, "", "BIGINT"));
        this.addColumn(new DBColumn(COLUMN.ARGUMENT.name, "", "VARCHAR", 1024));
        this.addColumn(new DBColumn(COLUMN.RETURN_VALUE.name, "", "VARCHAR", 100));
        this.addColumn(new DBColumn(COLUMN.CALLER_LIBRARY_NAME.name, "NOT NULL", "VARCHAR", 1024));
        this.addColumn(new DBColumn(COLUMN.MESSAGE_ID.name, "NOT NULL", "INTEGER"));
        this.addColumn(new DBColumn(COLUMN.TID.name, "NOT NULL", "INTEGER"));
        this.addColumn(new DBColumn(COLUMN.ALLOCATED_MEMORY_SIZE.name, "NOT NULL", "BIGINT"));
        this.setIndexColumn(COLUMN.PID.index);
        this.setIndexColumn(COLUMN.ALLOCATED_ADDRESS.index);
    }

    @Override
    public boolean prepare(PreparedStatement prep, List<Object> rowData) {
        boolean isPrepared = true;
        int columnsize = this.getColumnSize();
        if (columnsize != rowData.size()) {
            isPrepared = false;
        } else {
            try {
                prep.setLong(1, (Long)rowData.get(COLUMN.SEQUENCE_NUMBER.index));
                prep.setInt(2, (Integer)rowData.get(COLUMN.PID.index));
                prep.setInt(3, (Integer)rowData.get(COLUMN.API_ID.index));
                prep.setInt(4, (Integer)rowData.get(COLUMN.API_TYPE.index));
                prep.setLong(5, (Long)rowData.get(COLUMN.ALLOCATED_ADDRESS.index));
                prep.setLong(6, (Long)rowData.get(COLUMN.ALLOCATED_TIME.index));
                prep.setLong(7, (Long)rowData.get(COLUMN.CALLER_PC_ADDRESS.index));
                prep.setString(8, (String)rowData.get(COLUMN.ARGUMENT.index));
                prep.setString(9, (String)rowData.get(COLUMN.RETURN_VALUE.index));
                prep.setString(10, (String)rowData.get(COLUMN.CALLER_LIBRARY_NAME.index));
                prep.setInt(11, (Integer)rowData.get(COLUMN.MESSAGE_ID.index));
                prep.setInt(12, (Integer)rowData.get(COLUMN.TID.index));
                prep.setLong(13, (Long)rowData.get(COLUMN.ALLOCATED_MEMORY_SIZE.index));
            }
            catch (SQLException e) {
                Logger.exception((Throwable)e);
                isPrepared = false;
            }
        }
        return isPrepared;
    }

    public static enum COLUMN {
        SEQUENCE_NUMBER(0, "SEQUENCE_NUMBER"),
        PID(1, "PID"),
        API_ID(2, "API_ID"),
        API_TYPE(3, "API_TYPE"),
        ALLOCATED_ADDRESS(4, "ALLOCATED_ADDRESS"),
        ALLOCATED_TIME(5, "ALLOCATED_TIME"),
        CALLER_PC_ADDRESS(6, "CALLER_PC_ADDRESS"),
        ARGUMENT(7, "ARGUMENT"),
        RETURN_VALUE(8, "RETURN_VALUE"),
        CALLER_LIBRARY_NAME(9, "CALLER_LIBRARY_NAME"),
        MESSAGE_ID(10, "MESSAGE_ID"),
        TID(11, "TID"),
        ALLOCATED_MEMORY_SIZE(12, "ALLOCATED_MEMORY_SIZE");

        public final int index;
        public final String name;

        private COLUMN(int index, String name) {
            this.index = index;
            this.name = name;
        }
    }
}

