/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.summary.profiling;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.tizen.dynamicanalyzer.database.DBColumn;
import org.tizen.dynamicanalyzer.database.DBTable;
import org.tizen.dynamicanalyzer.util.Logger;

public class FunctionSampleDBTable
extends DBTable {
    private static final String TABLENAME = "FUNCTION_SAMPLE";
    private static final String SELECT_COLUMN = String.valueOf(COLUMN.SAMPLE_TIME.name) + "," + COLUMN.PID.name + "," + COLUMN.TID.name + "," + COLUMN.PC_ADDRESS.name;
    public static final String SELECT_QUERY = "select " + SELECT_COLUMN + " from " + "FUNCTION_SAMPLE" + " where " + COLUMN.SAMPLE_TIME.name + " between %s and %s";

    @Override
    public String getTableName() {
        return TABLENAME;
    }

    public FunctionSampleDBTable() {
        this.addColumn(new DBColumn(COLUMN.SEQUENCE_NUMBER.name, "PRIMARY KEY", "BIGINT"));
        this.addColumn(new DBColumn(COLUMN.SAMPLE_TIME.name, "NOT NULL", "BIGINT"));
        this.addColumn(new DBColumn(COLUMN.PID.name, "NOT NULL", "INTEGER"));
        this.addColumn(new DBColumn(COLUMN.TID.name, "NOT NULL", "INTEGER"));
        this.addColumn(new DBColumn(COLUMN.PC_ADDRESS.name, "NOT NULL", "BIGINT"));
        this.addColumn(new DBColumn(COLUMN.CPU_NUMBER.name, "NOT NULL", "TINYINT"));
    }

    public List<List<Object>> getFunctionSampleFromDB() {
        return this.selectAllColumnData(null);
    }

    @Override
    public boolean prepare(PreparedStatement prep, List<Object> rowData) {
        boolean isPrepared = true;
        int columnsize = this.getColumnSize();
        if (columnsize != rowData.size()) {
            isPrepared = false;
        } else {
            try {
                prep.setLong(COLUMN.SEQUENCE_NUMBER.index + 1, (Long)rowData.get(COLUMN.SEQUENCE_NUMBER.index));
                prep.setLong(COLUMN.SAMPLE_TIME.index + 1, (Long)rowData.get(COLUMN.SAMPLE_TIME.index));
                prep.setInt(COLUMN.PID.index + 1, (Integer)rowData.get(COLUMN.PID.index));
                prep.setInt(COLUMN.TID.index + 1, (Integer)rowData.get(COLUMN.TID.index));
                prep.setLong(COLUMN.PC_ADDRESS.index + 1, (Long)rowData.get(COLUMN.PC_ADDRESS.index));
                prep.setByte(COLUMN.CPU_NUMBER.index + 1, (Byte)rowData.get(COLUMN.CPU_NUMBER.index));
            }
            catch (SQLException e) {
                Logger.exception((Throwable)e);
                isPrepared = false;
            }
        }
        return isPrepared;
    }

    @Override
    public List<Object> extractDataFromResultSet(ResultSet rs) {
        ArrayList<Object> row = new ArrayList<Object>();
        try {
            row.add(rs.getLong(1));
            row.add(rs.getLong(2));
            row.add(rs.getInt(3));
            row.add(rs.getInt(4));
            row.add(rs.getLong(5));
            row.add(rs.getByte(6));
        }
        catch (SQLException e) {
            Logger.exception((Throwable)e);
            return null;
        }
        return row;
    }

    public static enum COLUMN {
        SEQUENCE_NUMBER(0, "SEQUENCE_NUMBER"),
        SAMPLE_TIME(1, "SAMPLE_TIME"),
        PID(2, "PID"),
        TID(3, "TID"),
        PC_ADDRESS(4, "PC_ADDRESS"),
        CPU_NUMBER(5, "CPU_NUMBER");

        public final int index;
        public final String name;

        private COLUMN(int index, String name) {
            this.index = index;
            this.name = name;
        }
    }
}

