/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.timeline.calltrace;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.tizen.dynamicanalyzer.common.DASelectionData;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.database.SqlConnectionManager;
import org.tizen.dynamicanalyzer.nl.TimelinePageLabels;
import org.tizen.dynamicanalyzer.project.Project;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.ui.info.callstack.CallstackView;
import org.tizen.dynamicanalyzer.ui.interactive.InteractivePage;
import org.tizen.dynamicanalyzer.ui.interactive.data.InteractiveUIData;
import org.tizen.dynamicanalyzer.ui.timeline.TimelinePage;
import org.tizen.dynamicanalyzer.ui.timeline.calltrace.CallTraceTable;
import org.tizen.dynamicanalyzer.ui.timeline.calltrace.FunctionEntryDBTable;
import org.tizen.dynamicanalyzer.ui.timeline.calltrace.WebCallTraceTable;
import org.tizen.dynamicanalyzer.ui.timeline.common.TimelineTableView;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableDataFormat;
import org.tizen.dynamicanalyzer.ui.widgets.table.DAWindowingTableComposite;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.utils.AnalyzerUtil;
import org.tizen.dynamicanalyzer.widgets.da.view.DABaseComposite;
import org.tizen.dynamicanalyzer.widgets.da.view.DATabComposite;
import org.tizen.dynamicanalyzer.widgets.da.view.DAViewComposite;
import org.tizen.dynamicanalyzer.widgets.da.view.DAViewData;

public class CallTraceView
extends DAViewComposite {
    Composite contents = null;
    private StackLayout stackLayout;
    private CallTraceTable nativeTable = null;
    private WebCallTraceTable webTable = null;

    public CallTraceView(Composite parent, int style) {
        super(parent, style, false);
        this.setLayout((Layout)new FillLayout());
        this.setTitle(TimelinePageLabels.CALL_TRACE_VIEW_TITLE);
        this.contents = this.getContentArea();
        this.contents.setBackground(ColorResources.WINDOW_BG_COLOR);
        this.stackLayout = new StackLayout();
        this.contents.setLayout((Layout)this.stackLayout);
        this.nativeTable = new CallTraceTable(this.contents, 0, 67586);
        this.nativeTable.setTableName(TimelinePageLabels.CALL_TRACE_VIEW_TITLE);
        this.webTable = new WebCallTraceTable(this.contents, 0, 67586);
        Project currentProject = Global.getProject();
        if (currentProject == null) {
            this.stackLayout.topControl = this.nativeTable;
        } else {
            this.changeTable(currentProject.isWebApplication());
        }
    }

    public void updateView(DAViewData data) {
        if (data instanceof DASelectionData) {
            DASelectionData selData = (DASelectionData)data;
            long start = selData.getStartTime();
            long end = selData.getEndTime();
            this.updateView();
            if (selData.getViewID().equals(InteractivePage.listViewID)) {
                GridItem rootGridItem = this.findRootGridItem((GridItem)selData.getData());
                InteractiveUIData uiData = (InteractiveUIData)((DATableDataFormat)rootGridItem.getData()).getObject();
                long interactiveSeqNum = uiData.getSeq();
                int funcID = uiData.getVariableInfo().getFunctionID();
                end = start = this.findFuncCallTime(funcID, interactiveSeqNum);
            }
            ((DAWindowingTableComposite)this.stackLayout.topControl).setSelectionByTime(start, end);
            this.updateView();
            if (this.stackLayout.topControl == this.nativeTable && selData.getViewID().equals(TimelinePage.timelineViewID)) {
                DATabComposite tabView = (DATabComposite)AnalyzerUtil.getView(TimelinePage.pageID, TimelineTableView.tabID);
                if (tabView == null) {
                    Logger.warning((Object)"Tabview does not exist.");
                } else {
                    DABaseComposite comp = tabView.getTopComposite();
                    if (comp instanceof CallstackView) {
                        ((CallstackView)comp).updateView();
                    }
                }
            }
        }
    }

    public void changeTable(boolean isWeb) {
        this.stackLayout.topControl = isWeb ? this.webTable : this.nativeTable;
        this.contents.layout();
    }

    public void updateView() {
        ((DAWindowingTableComposite)this.stackLayout.topControl).updateTable();
    }

    public void clear() {
        ((DAWindowingTableComposite)this.stackLayout.topControl).getTable().removeAll();
        ((DAWindowingTableComposite)this.stackLayout.topControl).clear();
    }

    public Control getControl() {
        return this.stackLayout.topControl;
    }

    private GridItem findRootGridItem(GridItem gridItem) {
        if (gridItem.getParentItem() == null) {
            return gridItem;
        }
        return this.findRootGridItem(gridItem.getParentItem());
    }

    private long findFuncCallTime(int funcID, long interactiveSeqNum) {
        long callTime = 0L;
        String query = String.format(FunctionEntryDBTable.FIND_ENTRY_TIME_QUERY, funcID, interactiveSeqNum);
        ResultSet rs = SqlConnectionManager.executeQueryRS(query);
        if (rs == null) {
            return callTime;
        }
        try {
            try {
                rs.next();
                callTime = rs.getLong(1);
            }
            catch (SQLException e) {
                Logger.exception((Throwable)e);
                SqlConnectionManager.releaseResultSet(rs);
            }
        }
        finally {
            SqlConnectionManager.releaseResultSet(rs);
        }
        return callTime;
    }
}

