/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.timeline.uievent;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.nebula.widgets.grid.GridCellRenderer;
import org.eclipse.nebula.widgets.grid.GridColumn;
import org.eclipse.nebula.widgets.grid.GridHeaderRenderer;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.tizen.dynamicanalyzer.common.AnalyzerManager;
import org.tizen.dynamicanalyzer.model.TableInput;
import org.tizen.dynamicanalyzer.nl.TimelinePageLabels;
import org.tizen.dynamicanalyzer.nl.WidgetLabels;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.resources.FontResources;
import org.tizen.dynamicanalyzer.ui.range.RangeDataManager;
import org.tizen.dynamicanalyzer.ui.timeline.TimelinePage;
import org.tizen.dynamicanalyzer.ui.timeline.common.TimelineChartView;
import org.tizen.dynamicanalyzer.ui.timeline.uievent.UIEventListDialogTableCellRenderer;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableComposite;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableDataFormat;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableHeaderRenderer;
import org.tizen.dynamicanalyzer.ui.widgets.table.DefaultTableComparator;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButton;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButtonClickEventListener;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartSeries;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartSeriesItem;
import org.tizen.dynamicanalyzer.widgets.da.base.DAButton;

public class UIEventListDialog
extends Dialog {
    static final String KEY_START_OLD_CHECKED_ITEM = "start_old_checked_item";
    static final String KEY_END_OLD_CHECKED_ITEM = "end_old_checked_item";
    static final String KEY_OLD_HOVERED_ITEM = "old_hovered_item";
    static final String KEY_OLD_HOVERED_INDEX = "old_hovered_INDEX";
    static final String KEY_START_TIME = "start_time";
    static final String KEY_END_TIME = "end_time";
    private Shell shell;
    private Shell parent;
    private UIEventListTable uiEventListTable;
    private List<DAChartSeries> chartSeriesList;
    private List<Integer> startIndexList;
    private List<Integer> endIndexList;
    private String[] columnNames = new String[]{TimelinePageLabels.UI_EVENT_LIST_TYPE, TimelinePageLabels.UI_EVENT_LIST_NAME, TimelinePageLabels.UI_EVENT_LIST_TIME, TimelinePageLabels.UI_EVENT_LIST_SET_RANGE};
    private int[] columnSizes = new int[]{74, 102, 100, 140};
    private boolean[] columnVisibility = new boolean[]{true, true, true, true};
    int[] sortTypes;
    DefaultTableComparator comparator;
    private DACustomButtonClickEventListener okButtonListener;
    private DACustomButtonClickEventListener cancelButtonListener;

    public UIEventListDialog(Shell parent) {
        super(parent);
        int[] nArray = new int[4];
        nArray[0] = 3;
        nArray[1] = 3;
        nArray[2] = 3;
        this.sortTypes = nArray;
        this.comparator = new DefaultTableComparator();
        this.okButtonListener = new DACustomButtonClickEventListener(){

            public void handleClickEvent(DACustomButton button) {
                RangeDataManager rangeDataManager = RangeDataManager.getInstance();
                TimelineChartView tview = (TimelineChartView)AnalyzerManager.getCurrentPage().getView(TimelinePage.timelineViewID);
                Double startTime = (Double)UIEventListDialog.this.uiEventListTable.getTable().getData(UIEventListDialog.KEY_START_TIME);
                Double endTime = (Double)UIEventListDialog.this.uiEventListTable.getTable().getData(UIEventListDialog.KEY_END_TIME);
                if (startTime == null || endTime == null) {
                    return;
                }
                if (startTime != -1.0 && endTime != -1.0 && startTime > endTime) {
                    double temp = startTime;
                    startTime = endTime;
                    endTime = temp;
                }
                if (startTime != -1.0) {
                    rangeDataManager.setMarkerStartTime((long)(startTime * 1000000.0));
                    double revisedEndTime = rangeDataManager.getMarkerEndTime();
                    tview.setRangeMarker(startTime, revisedEndTime / 1000000.0);
                }
                if (endTime != -1.0) {
                    rangeDataManager.setMarkerEndTime((long)(endTime * 1000000.0));
                    double revisedStartTime = rangeDataManager.getMarkerStartTime();
                    tview.setRangeMarker(revisedStartTime / 1000000.0, endTime);
                }
                UIEventListDialog.this.shell.dispose();
            }
        };
        this.cancelButtonListener = new DACustomButtonClickEventListener(){

            public void handleClickEvent(DACustomButton button) {
                UIEventListDialog.this.uiEventListTable.getTable().setData(UIEventListDialog.KEY_START_TIME, (Object)-1.0);
                UIEventListDialog.this.uiEventListTable.getTable().setData(UIEventListDialog.KEY_END_TIME, (Object)-1.0);
                UIEventListDialog.this.shell.dispose();
            }
        };
        this.parent = parent;
    }

    public int open() {
        this.shell = new Shell(this.parent, 67680);
        this.shell.setText("Event list");
        this.shell.setSize(446, 450);
        this.shell.setLayout((Layout)new FormLayout());
        Composite tableComp = new Composite((Composite)this.shell, 0);
        tableComp.setBackground(ColorResources.CONFIGURATION_TABLE_COVER_BACKGROUND_COLOR);
        tableComp.setLayout((Layout)new FormLayout());
        FormData data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.bottom = new FormAttachment(100, -49);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        tableComp.setLayoutData((Object)data);
        this.uiEventListTable = new UIEventListTable(tableComp, 0, 768);
        this.uiEventListTable.setColumns(this.columnNames);
        this.uiEventListTable.setColumnSize(this.columnSizes);
        this.uiEventListTable.setColumnVisibility(this.columnVisibility);
        this.uiEventListTable.setSortTypes(this.sortTypes);
        this.comparator.setColumn(2);
        this.uiEventListTable.setComparator(this.comparator);
        this.uiEventListTable.getTable().setData(KEY_START_TIME, (Object)-1.0);
        this.uiEventListTable.getTable().setData(KEY_END_TIME, (Object)-1.0);
        data = new FormData();
        data.top = new FormAttachment((Control)tableComp, 15);
        data.bottom = new FormAttachment(100, -15);
        data.left = new FormAttachment(0, 6);
        data.right = new FormAttachment(100, -6);
        this.uiEventListTable.setLayoutData(data);
        Composite buttonComp = new Composite((Composite)this.shell, 0);
        buttonComp.setBackground(ColorResources.CONFIGURATION_BUTTON_COVER_BACKGROUND_COLOR);
        buttonComp.setLayout((Layout)new FormLayout());
        data = new FormData();
        data.top = new FormAttachment((Control)tableComp, 0);
        data.bottom = new FormAttachment(100, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        buttonComp.setLayoutData((Object)data);
        DAButton okButton = new DAButton(buttonComp, 8);
        okButton.addClickListener(this.okButtonListener);
        okButton.setText(WidgetLabels.OK);
        okButton.setFont(FontResources.EDIT_CHART_DLG_BUTTON);
        data = new FormData();
        data.top = new FormAttachment(0, 8);
        data.left = new FormAttachment(0, 119);
        data.width = 86;
        data.height = 24;
        okButton.setLayoutData((Object)data);
        DAButton cancelButton = new DAButton(buttonComp, 8);
        cancelButton.addClickListener(this.cancelButtonListener);
        cancelButton.setText(WidgetLabels.CANCEL);
        cancelButton.setFont(FontResources.EDIT_CHART_DLG_BUTTON);
        data = new FormData();
        data.top = new FormAttachment(0, 8);
        data.left = new FormAttachment((Control)okButton, 8);
        data.width = 86;
        data.height = 24;
        cancelButton.setLayoutData((Object)data);
        buttonComp.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                Composite comp = (Composite)e.widget;
                Rectangle rect = comp.getClientArea();
                e.gc.setForeground(ColorResources.DIALOG_SUNKEN_1);
                e.gc.drawLine(rect.x, rect.y, rect.x + rect.width, rect.y);
                e.gc.setForeground(ColorResources.DIALOG_SUNKEN_2);
                e.gc.drawLine(rect.x, rect.y + 1, rect.x + rect.width, rect.y + 1);
            }
        });
        this.uiEventListTable.updateTable();
        this.shell.open();
        return 0;
    }

    public void setSelectedEventInfo(List<DAChartSeries> chartSeriesList, List<Integer> startIndexList, List<Integer> endIndexList) {
        this.chartSeriesList = chartSeriesList;
        this.startIndexList = startIndexList;
        this.endIndexList = endIndexList;
    }

    private class UIEventListTable
    extends DATableComposite {
        private UIEventListTable(Composite parent, int style, int tableStyle) {
            super(parent, style, tableStyle);
        }

        @Override
        protected List<TableInput> makeTableInput() {
            ArrayList<TableInput> inputList = new ArrayList<TableInput>();
            int i = 0;
            while (i < UIEventListDialog.this.chartSeriesList.size()) {
                int toIndex;
                String seriesName = ((DAChartSeries)UIEventListDialog.this.chartSeriesList.get(i)).getName();
                int fromIndex = (Integer)UIEventListDialog.this.startIndexList.get(i);
                if (fromIndex <= (toIndex = ((Integer)UIEventListDialog.this.endIndexList.get(i)).intValue()) && fromIndex != -1 && toIndex != -1) {
                    List subItemList = ((DAChartSeries)UIEventListDialog.this.chartSeriesList.get(i)).getSeriesItemList().subList(fromIndex, toIndex);
                    for (DAChartSeriesItem item : subItemList) {
                        ArrayList<String> columnTexts = new ArrayList<String>();
                        columnTexts.add(seriesName);
                        columnTexts.add(item.getTooltipText().split("\n")[0]);
                        columnTexts.add(String.valueOf(item.getX()));
                        TableInput tableInput = new TableInput();
                        tableInput.setText(columnTexts);
                        DATableDataFormat dataFormat = new DATableDataFormat(0L);
                        dataFormat.setObject(item.getX());
                        tableInput.setData(dataFormat);
                        inputList.add(tableInput);
                    }
                }
                ++i;
            }
            return inputList;
        }

        @Override
        public void setColumns(String[] columnNames) {
            int size = columnNames.length;
            int i = 0;
            while (i < size) {
                GridColumn column = new GridColumn(this.table, 0);
                column.setText(columnNames[i]);
                column.setCellRenderer((GridCellRenderer)new UIEventListDialogTableCellRenderer());
                column.setHeaderRenderer((GridHeaderRenderer)new DATableHeaderRenderer());
                column.pack();
                ++i;
            }
        }
    }
}

