/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.toolbar.replayEditor.data;

import java.util.ArrayList;
import java.util.List;
import org.tizen.dynamicanalyzer.nl.ReplayEditLabels;
import org.tizen.dynamicanalyzer.swap.model.data.RecordEventObject;
import org.tizen.dynamicanalyzer.swap.model.data.ReplayData;
import org.tizen.dynamicanalyzer.ui.toolbar.replay.data.ReplayDataManager;
import org.tizen.dynamicanalyzer.ui.toolbar.replayEditor.data.ReplayEditDataType;
import org.tizen.dynamicanalyzer.ui.toolbar.replayEditor.data.ReplayEditTableData;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButton;

public class ReplayEditTableDataMaker
extends ReplayEditDataType {
    private DACustomButton saveButton = null;
    private DACustomButton okButton = null;
    private static ReplayEditTableDataMaker instance = null;
    private ReplayData replayDBData = null;
    private List<ReplayEditTableData> replayModifyDataList = null;

    public static ReplayEditTableDataMaker getInstance() {
        if (instance == null) {
            instance = new ReplayEditTableDataMaker();
        }
        return instance;
    }

    public void clean() {
        this.replayModifyDataList = null;
        this.replayDBData = null;
    }

    public List<ReplayEditTableData> getReplayEditTableData() {
        if (this.replayModifyDataList != null) {
            return this.replayModifyDataList;
        }
        this.replayModifyDataList = this.makeReplayEditData();
        return this.replayModifyDataList;
    }

    private List<List<RecordEventObject>> makeReplayUnitList() {
        ArrayList<List<RecordEventObject>> returnDataList = new ArrayList<List<RecordEventObject>>();
        ArrayList<RecordEventObject> unitDataList = new ArrayList<RecordEventObject>();
        if (this.getReplayDBData() == null || this.getReplayDBData().getRecordEvent() == null) {
            return returnDataList;
        }
        for (RecordEventObject reo : this.getReplayDBData().getRecordEvent()) {
            unitDataList.add(reo);
            if (reo.getEventType() != 0) continue;
            returnDataList.add(unitDataList);
            unitDataList = new ArrayList();
        }
        return returnDataList;
    }

    private List<ReplayEditTableData> makeReplayEditData() {
        ArrayList<ReplayEditTableData> returnDataList = new ArrayList<ReplayEditTableData>();
        List<List<RecordEventObject>> replayUnitList = this.makeReplayUnitList();
        if (replayUnitList == null) {
            return null;
        }
        for (List<RecordEventObject> unitList : replayUnitList) {
            if (this.isEventMouseUpTime(unitList.get(0))) {
                ((ReplayEditTableData)returnDataList.get(returnDataList.size() - 1)).setEventMouseUpTime(unitList.get(0).getTime());
                continue;
            }
            ReplayEditTableData itemData = this.getReplayEditTableData(unitList);
            returnDataList.add(itemData);
        }
        return returnDataList;
    }

    private ReplayEditTableData getReplayEditTableData(List<RecordEventObject> unitList) {
        ReplayEditTableData itemData = new ReplayEditTableData();
        int i = 0;
        while (i < unitList.size()) {
            RecordEventObject reo = unitList.get(i);
            if (!this.isEventEdgeLog(reo)) {
                if (i == 0) {
                    itemData.setEventMouseDownTime(reo.getTime());
                    itemData.setStrEventType(this.setEventType(reo.getEventType()));
                    itemData.setEventRid(reo.getMsgID());
                }
                this.setItemDataValue(itemData, reo);
            }
            ++i;
        }
        return itemData;
    }

    public ReplayData getReplayDBData() {
        if (this.replayDBData != null) {
            return this.replayDBData;
        }
        this.replayDBData = ReplayDataManager.getInstance().getReplayDBManager().getReplayLogs();
        return this.replayDBData;
    }

    public void setReplayDBData(ReplayData replayData) {
        this.replayDBData = replayData;
    }

    private boolean isEventEdgeLog(RecordEventObject reo) {
        return reo.getEventType() == 0;
    }

    private boolean isEventMouseUpTime(RecordEventObject reo) {
        if (reo.getEventType() == 1 && reo.getEventValue() == 0) {
            return true;
        }
        return reo.getEventType() == 3 && reo.getEventValue() == -1;
    }

    private void setItemDataValue(ReplayEditTableData itemData, RecordEventObject reo) {
        if (reo.getEventType() == 1) {
            this.setEventTypeKeyValue(itemData, reo);
        } else if (reo.getEventType() == 3) {
            this.setEventTypeTouchValue(itemData, reo);
        } else {
            Logger.error((Object)("Not define event type : " + reo.getEventType()));
        }
    }

    private void setEventTypeKeyValue(ReplayEditTableData itemData, RecordEventObject reo) {
        itemData.setStrEventValue1(this.setEventValue1(reo.getEventCode()));
        itemData.setStrEventValue2("-");
    }

    private void setEventTypeTouchValue(ReplayEditTableData itemData, RecordEventObject reo) {
        if (reo.getEventCode() == 57) {
            return;
        }
        if (reo.getEventCode() == 53) {
            itemData.setStrEventValue1(String.valueOf(ReplayEditLabels.CONTEXT_VALUE_X) + Integer.toString(reo.getEventValue()));
        } else if (reo.getEventCode() == 54) {
            itemData.setStrEventValue2(String.valueOf(ReplayEditLabels.CONTEXT_VALUE_Y) + Integer.toString(reo.getEventValue()));
        } else {
            Logger.error((Object)("Not define key event type : " + reo.getEventCode()));
        }
    }

    private String setEventType(int type) {
        if (type == 1) {
            return ReplayEditLabels.CONTEXT_KEY;
        }
        if (type == 3) {
            return ReplayEditLabels.CONTEXT_TOUCH;
        }
        Logger.error((Object)("Not define set key event type : " + type));
        return "";
    }

    private String setEventValue1(int type) {
        String strType = "";
        switch (type) {
            case 169: {
                strType = ReplayEditLabels.CONTEXT_KEY_MENU;
                break;
            }
            case 139: {
                strType = ReplayEditLabels.CONTEXT_KEY_HOME;
                break;
            }
            case 158: {
                strType = ReplayEditLabels.CONTEXT_KEY_BACK;
                break;
            }
            case 116: {
                strType = ReplayEditLabels.CONTEXT_KEY_POWER;
                break;
            }
            case 114: {
                strType = ReplayEditLabels.CONTEXT_KEY_VOLUME_DOWN;
                break;
            }
            case 115: {
                strType = ReplayEditLabels.CONTEXT_KEY_VOLUME_UP;
            }
        }
        return strType;
    }

    public DACustomButton getSaveButton() {
        return this.saveButton;
    }

    public void setSaveButton(DACustomButton saveButton) {
        this.saveButton = saveButton;
    }

    public DACustomButton getOkButton() {
        return this.okButton;
    }

    public void setOkButton(DACustomButton okButton) {
        this.okButton = okButton;
    }
}

