/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.toolbar.setting;

import org.eclipse.nebula.widgets.grid.Grid;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.tizen.dynamicanalyzer.nl.ConfigureLabels;
import org.tizen.dynamicanalyzer.nl.WidgetLabels;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.resources.FontResources;
import org.tizen.dynamicanalyzer.setting.SettingDataManager;
import org.tizen.dynamicanalyzer.setting.Template;
import org.tizen.dynamicanalyzer.ui.toolbar.setting.FeatureDialogFeaturesTable;
import org.tizen.dynamicanalyzer.ui.toolbar.setting.SettingDialogManager;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableComposite;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButton;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButtonClickEventListener;
import org.tizen.dynamicanalyzer.widgets.da.base.DAButton;
import org.tizen.dynamicanalyzer.widgets.da.base.DAMessageBox;

public class FeatureDialog
extends DAMessageBox {
    private DATableComposite featuresTable = null;
    int[] sortTypes = new int[]{3};
    private String[] columnNames = new String[]{ConfigureLabels.FEATURE_DIALOG_FEATURE_TABLE_COLUMN_NAME};
    private int[] columnSizes = new int[]{571};
    private boolean[] columnVisibility = new boolean[]{true};
    private DAButton okButton = null;
    private DAButton cancelButton = null;
    private DACustomButtonClickEventListener okButtonListener = new DACustomButtonClickEventListener(){

        public void handleClickEvent(DACustomButton button) {
            Grid table = ((FeatureDialogFeaturesTable)FeatureDialog.this.featuresTable).getTable();
            if (SettingDialogManager.INSTANCE.validInputText(table) && SettingDialogManager.INSTANCE.changedFeaturesFromTableItemsList(table)) {
                SettingDataManager.INSTANCE.getTarget(null).setSelectedTemplate(Template.TEMPLATE_CUSTOM);
                SettingDialogManager.INSTANCE.setFeaturesValueFromTableItemsList(table);
                FeatureDialog.this.result = true;
            }
            FeatureDialog.this.shell.dispose();
        }
    };
    private DACustomButtonClickEventListener cancelButtonListener = new DACustomButtonClickEventListener(){

        public void handleClickEvent(DACustomButton button) {
            FeatureDialog.this.shell.dispose();
        }
    };
    private SelectionListener featureTableSelectionListener = new SelectionListener(){

        public void widgetSelected(SelectionEvent e) {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    };
    private MouseListener mouseListener = new MouseListener(){

        public void mouseUp(MouseEvent e) {
        }

        public void mouseDown(MouseEvent e) {
            Grid table = ((FeatureDialogFeaturesTable)FeatureDialog.this.featuresTable).getTable();
            if (SettingDialogManager.INSTANCE.validInputText(table) && SettingDialogManager.INSTANCE.changedFeaturesFromTableItemsList(table)) {
                FeatureDialog.this.okButton.setButtonEnabled(true);
            } else {
                FeatureDialog.this.okButton.setButtonEnabled(false);
            }
        }

        public void mouseDoubleClick(MouseEvent e) {
        }
    };

    public FeatureDialog(Shell parentShell) {
        super(parentShell);
    }

    public void enableButteon() {
        this.okButton.setButtonEnabled(true);
        this.cancelButton.setButtonEnabled(true);
    }

    public void diableButteon() {
        this.okButton.setButtonEnabled(false);
        this.cancelButton.setButtonEnabled(true);
    }

    protected boolean run() {
        this.shell.setSize(610, 520);
        this.shell.setLayout((Layout)new FormLayout());
        this.shell.setText(ConfigureLabels.FEATURE_DIALOG_HEADER_TITLE);
        this.shell.setBackground(ColorResources.CONFIGURATION_TABLE_COVER_BACKGROUND_COLOR);
        Composite tableComp = new Composite((Composite)this.shell, 0);
        FormLayout compLayout = new FormLayout();
        tableComp.setLayout((Layout)compLayout);
        tableComp.setBackground(ColorResources.CONFIGURATION_TABLE_COVER_BACKGROUND_COLOR);
        FormData compData = new FormData();
        compData.top = new FormAttachment(0, 0);
        compData.left = new FormAttachment(0, 0);
        compData.right = new FormAttachment(100, 0);
        compData.bottom = new FormAttachment(100, -51);
        tableComp.setLayoutData((Object)compData);
        tableComp.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                Rectangle r = new Rectangle(6, 35, 432, 294);
                e.gc.setForeground(ColorResources.SETTING_STROKE);
                e.gc.drawRectangle(r);
            }
        });
        Label tableTitle = new Label(tableComp, 0x40000000);
        tableTitle.setText(ConfigureLabels.FEATURE_DIALOG_DESCRIPTION);
        tableTitle.setBackground(ColorResources.CONFIGURATION_TABLE_COVER_BACKGROUND_COLOR);
        tableTitle.setForeground(ColorResources.DEFAULT_FONT_COLOR);
        tableTitle.setFont(FontResources.SETTING_TITLE_FONT);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 17);
        data.left = new FormAttachment(0, 8);
        data.width = 432;
        data.height = 18;
        tableTitle.setLayoutData((Object)data);
        this.featuresTable = new FeatureDialogFeaturesTable(tableComp, 526852);
        this.featuresTable.setTree(true);
        this.featuresTable.setItemHeightSize(22);
        this.featuresTable.setTableName(ConfigureLabels.FEATURE_DIALOG_DESCRIPTION);
        this.featuresTable.setSortTypes(this.sortTypes);
        this.featuresTable.setColumns(this.columnNames);
        this.featuresTable.setColumnSize(this.columnSizes);
        this.featuresTable.setColumnVisibility(this.columnVisibility);
        this.featuresTable.setTableToolTipEnable(false);
        this.featuresTable.getTable().addSelectionListener(this.featureTableSelectionListener);
        this.featuresTable.getTable().addMouseListener(this.mouseListener);
        data = new FormData();
        data.top = new FormAttachment(0, 36);
        data.left = new FormAttachment(0, 7);
        data.right = new FormAttachment(100, -6);
        data.bottom = new FormAttachment(100, -14);
        this.featuresTable.setLayoutData(data);
        this.featuresTable.addControlListener(new ControlListener(){

            public void controlResized(ControlEvent e) {
                int size;
                Rectangle r = FeatureDialog.this.featuresTable.getClientArea();
                ((FeatureDialog)FeatureDialog.this).columnSizes[0] = size = r.width;
                FeatureDialog.this.featuresTable.setColumnSize(FeatureDialog.this.columnSizes);
                FeatureDialog.this.featuresTable.redraw();
            }

            public void controlMoved(ControlEvent e) {
            }
        });
        Composite buttonContentsComp = new Composite((Composite)this.shell, 0);
        compLayout = new FormLayout();
        buttonContentsComp.setLayout((Layout)compLayout);
        buttonContentsComp.setBackground(ColorResources.CONFIGURATION_BUTTON_COVER_BACKGROUND_COLOR);
        compData = new FormData();
        compData.top = new FormAttachment((Control)tableComp, 0);
        compData.left = new FormAttachment(0, 0);
        compData.right = new FormAttachment(100, 0);
        compData.bottom = new FormAttachment(100, 0);
        buttonContentsComp.setLayoutData((Object)compData);
        SettingDialogManager.INSTANCE.setFeatureDlg(this);
        buttonContentsComp.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                Composite comp = (Composite)e.widget;
                Rectangle rect = comp.getClientArea();
                e.gc.setForeground(ColorResources.SETTING_SUNKEN_LINE_1);
                e.gc.drawLine(0, 0, rect.width - 1, 0);
                e.gc.setForeground(ColorResources.SETTING_SUNKEN_LINE_2);
                e.gc.drawLine(0, 1, rect.width - 1, 1);
            }
        });
        this.cancelButton = new DAButton(buttonContentsComp, 0);
        this.cancelButton.addClickListener(this.cancelButtonListener);
        this.cancelButton.setText(WidgetLabels.CANCEL);
        this.cancelButton.setButtonFont(FontResources.DIALOG_BUTTON_FONT);
        FormData buttonData = new FormData();
        buttonData.right = new FormAttachment(100, -200);
        buttonData.top = new FormAttachment(0, 13);
        buttonData.width = 100;
        buttonData.height = 28;
        this.cancelButton.setLayoutData((Object)buttonData);
        this.okButton = new DAButton(buttonContentsComp, 0);
        this.okButton.addClickListener(this.okButtonListener);
        this.okButton.setText(WidgetLabels.OK);
        this.okButton.setButtonFont(FontResources.DIALOG_BUTTON_FONT);
        buttonData = new FormData();
        buttonData.right = new FormAttachment((Control)this.cancelButton, -8);
        buttonData.top = new FormAttachment(0, 13);
        buttonData.width = 100;
        buttonData.height = 28;
        this.okButton.setLayoutData((Object)buttonData);
        this.okButton.setButtonEnabled(false);
        this.featuresTable.updateTable();
        this.shell.open();
        return true;
    }
}

