/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.toolbar.setting;

import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.tizen.dynamicanalyzer.common.DAState;
import org.tizen.dynamicanalyzer.handlers.CommonAction;
import org.tizen.dynamicanalyzer.handlers.UIActionHolder;
import org.tizen.dynamicanalyzer.nl.AnalyzerLabels;
import org.tizen.dynamicanalyzer.nl.WidgetLabels;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.resources.FontResources;
import org.tizen.dynamicanalyzer.setting.SettingDataManager;
import org.tizen.dynamicanalyzer.shortcut.ShortCutManager;
import org.tizen.dynamicanalyzer.ui.toolbar.setting.FlatFeatureDialogFeatureListPage;
import org.tizen.dynamicanalyzer.ui.toolbar.setting.FlatFeatureDialogSelectedFeaturePage;
import org.tizen.dynamicanalyzer.ui.toolbar.setting.FlatFeatureDialogTargetPage;
import org.tizen.dynamicanalyzer.widgets.da.base.DAMessageBox;

public class FlatFeatureDialog
extends DAMessageBox {
    private static boolean opened = false;
    private Button cancelButton = null;
    private Button okButton = null;
    private FlatFeatureDialogTargetPage targetPage = null;
    private FlatFeatureDialogFeatureListPage featureListPage = null;
    private FlatFeatureDialogSelectedFeaturePage selectedFeaturePage = null;
    private Composite buttonContentsComp = null;
    public final int WINDOW_WIDTH = 1010;
    public final int WINDOW_HEIGHT = 620;
    public final int TITLE_BAR = 30;
    public final int TITLE_HEIGHT = 38;
    public final int LINE = 1;
    public final int WIDTH = 1010;
    public final int HEIGHT = 590;
    public final int BUTTONCOMP_TOP = 531;
    public final int BUTTONCOMP_WIDTH = 1010;
    public final int BUTTONCOMP_HEIGHT = 60;
    public final int TARGET_COMP_LEFT = 0;
    public final int TARGET_COMP_WIDTH = 180;
    public final int TARGET_COMP_HEIGHT = 527;
    public final int FEATURE_LEFT = 180;
    public final int FEATURE_WIDTH = 543;
    public final int FEATURE_HEIGHT = 527;
    public final int SELECTED_LEFT = 723;
    public final int SELECTED_WIDTH = 285;
    public final int SELECTED_HEIGHT = 527;
    private Listener okListener = new Listener(){

        public void handleEvent(Event event) {
            FlatFeatureDialog.this.doApply();
            FlatFeatureDialog.this.doRun();
            FlatFeatureDialog.this.shell.close();
        }
    };
    private Listener cancelListener = new Listener(){

        public void handleEvent(Event event) {
            FlatFeatureDialog.this.doRevert();
            FlatFeatureDialog.this.doRun();
            FlatFeatureDialog.this.shell.close();
        }
    };
    private ShellListener shellListener = new ShellListener(){

        public void shellActivated(ShellEvent e) {
        }

        public void shellClosed(ShellEvent e) {
        }

        public void shellDeactivated(ShellEvent e) {
        }

        public void shellDeiconified(ShellEvent e) {
        }

        public void shellIconified(ShellEvent e) {
        }
    };

    public FlatFeatureDialog(Shell parentShell) {
        super(parentShell);
    }

    private void doApply() {
        if (DAState.isStartable()) {
            UIActionHolder.getUIAction().setUIElementsBySetting();
            SettingDataManager.INSTANCE.applySettingData();
        }
    }

    private void doRevert() {
        SettingDataManager.INSTANCE.revertSettingData();
    }

    private void doRun() {
        if (DAState.isStartable()) {
            CommonAction.configure();
        }
    }

    protected boolean run() {
        if (opened) {
            return false;
        }
        int dialogLocationX = this.shell.getParent().getLocation().x + (this.shell.getParent().getSize().x - 1010) / 2;
        int dialogLocationY = this.shell.getParent().getLocation().y + (this.shell.getParent().getSize().y - 590) / 2;
        this.shell.setLocation(dialogLocationX, dialogLocationY);
        this.shell.setSize(1010, 590);
        this.shell.setLayout((Layout)new FormLayout());
        this.shell.setText(AnalyzerLabels.SETTING_TITLE);
        this.shell.setBackground(ColorResources.FEATURE_FEATURELISTCOMP_NORMAL_BACKGROUND);
        Composite targetComp = new Composite((Composite)this.shell, 0);
        FormLayout compLayout = new FormLayout();
        targetComp.setLayout((Layout)compLayout);
        targetComp.setBackground(ColorResources.FEATURE_TITLE_BACKGROUND);
        FormData compData = new FormData();
        compData.top = new FormAttachment(0, 0);
        compData.left = new FormAttachment(0, 0);
        compData.width = 180;
        compData.height = 527;
        targetComp.setLayoutData((Object)compData);
        Composite featureListComp = new Composite((Composite)this.shell, 0);
        compLayout = new FormLayout();
        featureListComp.setLayout((Layout)compLayout);
        featureListComp.setBackground(ColorResources.FEATURE_TITLE_BACKGROUND);
        compData = new FormData();
        compData.top = new FormAttachment(0, 0);
        compData.left = new FormAttachment(0, 180);
        compData.width = 543;
        compData.height = 527;
        featureListComp.setLayoutData((Object)compData);
        Composite selectedFeatureComp = new Composite((Composite)this.shell, 0);
        compLayout = new FormLayout();
        selectedFeatureComp.setLayout((Layout)compLayout);
        selectedFeatureComp.setBackground(ColorResources.FEATURE_TITLE_BACKGROUND);
        compData = new FormData();
        compData.top = new FormAttachment(0, 0);
        compData.left = new FormAttachment(0, 723);
        compData.width = 285;
        compData.height = 527;
        selectedFeatureComp.setLayoutData((Object)compData);
        this.buttonContentsComp = new Composite((Composite)this.shell, 0);
        this.buttonContentsComp.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                e.gc.setForeground(ColorResources.FEATURE_LINE);
                e.gc.drawLine(0, 0, 1010, 0);
            }
        });
        compLayout = new FormLayout();
        this.buttonContentsComp.setLayout((Layout)compLayout);
        this.buttonContentsComp.setBackground(ColorResources.WHITE);
        compData = new FormData();
        compData.top = new FormAttachment(0, 531);
        compData.left = new FormAttachment(0, 0);
        compData.width = 1010;
        compData.height = 60;
        this.buttonContentsComp.setLayoutData((Object)compData);
        this.okButton = new Button(this.buttonContentsComp, 8);
        this.okButton.addListener(13, this.okListener);
        this.okButton.setText(WidgetLabels.OK);
        this.okButton.setFont(FontResources.DIALOG_BUTTON_FONT);
        FormData buttonData = new FormData();
        buttonData.top = new FormAttachment(0, 3);
        buttonData.right = new FormAttachment(100, -15);
        buttonData.width = 100;
        buttonData.height = 25;
        this.okButton.setLayoutData((Object)buttonData);
        this.cancelButton = new Button(this.buttonContentsComp, 8);
        this.cancelButton.addListener(13, this.cancelListener);
        this.cancelButton.setText(WidgetLabels.CANCEL);
        this.cancelButton.setFont(FontResources.DIALOG_BUTTON_FONT);
        buttonData = new FormData();
        buttonData.top = new FormAttachment(0, 3);
        buttonData.right = new FormAttachment((Control)this.okButton, -8);
        buttonData.width = 100;
        buttonData.height = 25;
        this.cancelButton.setLayoutData((Object)buttonData);
        this.targetPage = new FlatFeatureDialogTargetPage(targetComp, this, 0x40000000);
        this.selectedFeaturePage = new FlatFeatureDialogSelectedFeaturePage(selectedFeatureComp, this, 0x40000000);
        this.featureListPage = new FlatFeatureDialogFeatureListPage(featureListComp, this, 0x40000000);
        this.shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                opened = false;
                ShortCutManager.getInstance().setEnabled(!opened);
            }
        });
        opened = true;
        ShortCutManager.getInstance().setEnabled(!opened);
        this.shell.addShellListener(this.shellListener);
        this.shell.open();
        return true;
    }

    public FlatFeatureDialogTargetPage getTargetPage() {
        return this.targetPage;
    }

    public FlatFeatureDialogFeatureListPage getFeatureListPage() {
        return this.featureListPage;
    }

    public FlatFeatureDialogSelectedFeaturePage getSelectedFeaturePage() {
        return this.selectedFeaturePage;
    }

    public Button getOKButton() {
        return this.okButton;
    }

    public Button getCancelButton() {
        return this.cancelButton;
    }
}

